/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.AbstractFileSystemAccess;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;

public class JavaIoFileSystemAccess
extends AbstractFileSystemAccess {
    @Inject
    private IEncodingProvider encodingProvider;
    @Inject
    private IResourceServiceProvider.Registry registry;

    public JavaIoFileSystemAccess() {
    }

    public JavaIoFileSystemAccess(IResourceServiceProvider.Registry registry, IEncodingProvider encodingProvider) {
        this.registry = registry;
        this.encodingProvider = encodingProvider;
    }

    public void generateFile(String fileName, String outputConfigName, CharSequence contents) {
        File file = this.getFile(fileName, outputConfigName);
        try {
            this.createFolder(file.getParentFile());
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.getEncoding(this.getURI(fileName, outputConfigName)));
            try {
                writer.append(this.postProcess(fileName, outputConfigName, contents));
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getEncoding(URI fileURI) {
        IResourceServiceProvider resourceServiceProvider = this.registry.getResourceServiceProvider(fileURI);
        if (resourceServiceProvider != null) {
            return resourceServiceProvider.getEncodingProvider().getEncoding(fileURI);
        }
        return this.encodingProvider.getEncoding(fileURI);
    }

    protected File getFile(String fileName, String outputConfigName) {
        String outlet = this.getPathes().get(outputConfigName);
        if (outlet == null) {
            throw new IllegalArgumentException("A slot with name '" + outputConfigName + "' has not been configured.");
        }
        String pathName = this.toSystemFileName(String.valueOf(outlet) + "/" + fileName);
        File file = new File(pathName).getAbsoluteFile();
        return file;
    }

    protected void createFolder(File parent) {
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    public void deleteFile(String fileName, String outputConfiguration) {
        File file = this.getFile(fileName, outputConfiguration);
        if (file.exists()) {
            file.delete();
        }
    }

    protected String toSystemFileName(String fileName) {
        return fileName.replace("/", File.separator);
    }

    public URI getURI(String fileName, String outputConfiguration) {
        return URI.createURI((String)this.getFile(fileName, outputConfiguration).toURI().toString());
    }
}

