/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.xtext.generator.IOutputConfigurationProvider;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseOutputConfigurationProvider
extends IOutputConfigurationProvider.Delegate {
    public static final String OUTPUT_PREFERENCE_TAG = "outlet";
    public static final String OUTPUT_NAME = "name";
    public static final String OUTPUT_DESCRIPTION = "description";
    public static final String OUTPUT_DIRECTORY = "directory";
    public static final String OUTPUT_CREATE_DIRECTORY = "createDirectory";
    public static final String OUTPUT_CLEAN_DIRECTORY = "cleanDirectory";
    public static final String OUTPUT_OVERRIDE = "override";
    public static final String OUTPUT_CLEANUP_DERIVED = "cleanupDerived";
    public static final String OUTPUT_DERIVED = "derived";
    private IPreferenceStoreAccess preferenceStoreAccess;

    public IPreferenceStoreAccess getPreferenceStoreAccess() {
        return this.preferenceStoreAccess;
    }

    @Inject
    public void setPreferenceStoreAccess(IPreferenceStoreAccess preferenceStoreAccess) {
        this.preferenceStoreAccess = preferenceStoreAccess;
    }

    @Inject
    public EclipseOutputConfigurationProvider(IOutputConfigurationProvider delegate) {
        super(delegate);
    }

    public Set<OutputConfiguration> getOutputConfigurations(IProject project) {
        IPreferenceStore store = this.getPreferenceStoreAccess().getContextPreferenceStore((Object)project);
        HashSet outputConfigurations = Sets.newHashSetWithExpectedSize((int)this.getOutputConfigurations().size());
        for (OutputConfiguration output : this.getOutputConfigurations()) {
            OutputConfiguration configuration = this.createAndOverlayOutputConfiguration(store, output);
            outputConfigurations.add(configuration);
        }
        return outputConfigurations;
    }

    protected OutputConfiguration createAndOverlayOutputConfiguration(IPreferenceStore store, OutputConfiguration output) {
        OutputConfiguration result = new OutputConfiguration(output.getName());
        boolean clearOutputDirectory = this.getBoolean(output, OUTPUT_CLEAN_DIRECTORY, store, output.isCanClearOutputDirectory());
        result.setCanClearOutputDirectory(clearOutputDirectory);
        boolean cleanUpDerivedResources = this.getBoolean(output, OUTPUT_CLEANUP_DERIVED, store, output.isCleanUpDerivedResources());
        result.setCleanUpDerivedResources(cleanUpDerivedResources);
        boolean createOutputDirectory = this.getBoolean(output, OUTPUT_CREATE_DIRECTORY, store, output.isCreateOutputDirectory());
        result.setCreateOutputDirectory(createOutputDirectory);
        boolean overrideExistingResources = this.getBoolean(output, OUTPUT_OVERRIDE, store, output.isOverrideExistingResources());
        result.setOverrideExistingResources(overrideExistingResources);
        boolean setDerivedProperty = this.getBoolean(output, OUTPUT_DERIVED, store, output.isSetDerivedProperty());
        result.setSetDerivedProperty(setDerivedProperty);
        String description = this.getString(output, OUTPUT_DESCRIPTION, store, output.getDescription());
        result.setDescription(description);
        String directory = this.getString(output, OUTPUT_DIRECTORY, store, output.getOutputDirectory());
        result.setOutputDirectory(directory);
        return result;
    }

    private boolean getBoolean(OutputConfiguration outputConfiguration, String name, IPreferenceStore preferenceStore, Boolean defaultValue) {
        String preferenceKey = this.getKey(outputConfiguration, name);
        return preferenceStore.contains(preferenceKey) ? preferenceStore.getBoolean(preferenceKey) : defaultValue.booleanValue();
    }

    private String getString(OutputConfiguration outputConfiguration, String name, IPreferenceStore preferenceStore, String defaultValue) {
        String preferenceKey = this.getKey(outputConfiguration, name);
        return preferenceStore.contains(preferenceKey) ? preferenceStore.getString(preferenceKey) : defaultValue;
    }

    private String getKey(OutputConfiguration outputConfiguration, String preferenceName) {
        return "outlet." + outputConfiguration.getName() + '.' + preferenceName;
    }
}

