/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.IGenerator2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.util.CancelIndicator;

public class GeneratorDelegate
implements IGenerator,
IGenerator2 {
    @Inject(optional=true)
    private IGenerator legacyGenerator;
    @Inject(optional=true)
    private IGenerator2 generator;

    public IGenerator getLegacyGenerator() {
        return this.legacyGenerator;
    }

    public void generate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        try {
            this.beforeGenerate(input, fsa, context);
            this.doGenerate(input, fsa, context);
        }
        finally {
            this.afterGenerate(input, fsa, context);
        }
    }

    @Override
    public void doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        if (this.generator != null) {
            this.generator.doGenerate(input, fsa, context);
        } else if (this.getLegacyGenerator() != null) {
            this.getLegacyGenerator().doGenerate(input, fsa);
        }
    }

    @Override
    public void beforeGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        if (this.generator != null) {
            this.generator.beforeGenerate(input, fsa, context);
        }
    }

    @Override
    public void afterGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        if (this.generator != null) {
            this.generator.afterGenerate(input, fsa, context);
        }
    }

    @Override
    public void doGenerate(Resource input, IFileSystemAccess fsa) {
        IFileSystemAccess2 casted = (IFileSystemAccess2)fsa;
        GeneratorContext context = new GeneratorContext();
        context.setCancelIndicator(CancelIndicator.NullImpl);
        try {
            this.beforeGenerate(input, casted, context);
            this.doGenerate(input, casted, context);
        }
        finally {
            this.afterGenerate(input, casted, context);
        }
    }
}

