/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.drop.IInternalSourceToRepresentationDropBehaviorProvider;
import org.eclipse.papyrus.uml.domain.services.modify.ElementFeatureModifier;
import org.eclipse.papyrus.uml.domain.services.status.State;
import org.eclipse.papyrus.uml.domain.services.status.Status;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Node;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class DeploymentInternalSourceToRepresentationDropBehaviorProvider
implements IInternalSourceToRepresentationDropBehaviorProvider {
    @Override
    public Status drop(EObject droppedElement, EObject oldContainer, EObject newContainer, ECrossReferenceAdapter crossRef, IEditableChecker editableChecker) {
        return (Status)new DeploymentDropOutsideRepresentationBehaviorProviderSwitch(oldContainer, newContainer, crossRef, editableChecker).doSwitch(droppedElement);
    }

    static class DeploymentDropOutsideRepresentationBehaviorProviderSwitch
    extends UMLSwitch<Status> {
        private static final String UNSUPPORTED_DROP_CONTAINER = "Unsupported drop container.";
        private final EObject oldContainer;
        private final EObject newContainer;
        private final ECrossReferenceAdapter crossRef;
        private final IEditableChecker editableChecker;

        DeploymentDropOutsideRepresentationBehaviorProviderSwitch(EObject oldContainer, EObject newContainer, ECrossReferenceAdapter crossRef, IEditableChecker editableChecker) {
            this.oldContainer = oldContainer;
            this.newContainer = newContainer;
            this.crossRef = crossRef;
            this.editableChecker = editableChecker;
        }

        public Status caseArtifact(Artifact artifact) {
            Status dropStatus = Status.createFailingStatus(UNSUPPORTED_DROP_CONTAINER);
            if (this.oldContainer != this.newContainer) {
                String refName;
                Optional<EReference> optionalContainmentFeature = this.getArtifactContainmentFeature(this.newContainer);
                ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
                if (optionalContainmentFeature.isPresent() && State.DONE == (dropStatus = modifier.removeValue(this.oldContainer, refName = artifact.eContainmentFeature().getName(), artifact)).getState()) {
                    dropStatus = modifier.addValue(this.newContainer, optionalContainmentFeature.get().getName(), artifact);
                }
            }
            return dropStatus;
        }

        private Optional<EReference> getArtifactContainmentFeature(EObject container) {
            Optional<Object> reference;
            if (container instanceof Package) {
                Package pkg = (Package)container;
                reference = Optional.of(UMLPackage.eINSTANCE.getPackage_PackagedElement());
            } else if (container instanceof Class) {
                Class clazz = (Class)container;
                reference = Optional.of(UMLPackage.eINSTANCE.getClass_NestedClassifier());
            } else if (container instanceof Artifact) {
                Artifact artifact = (Artifact)container;
                reference = Optional.of(UMLPackage.eINSTANCE.getArtifact_NestedArtifact());
            } else {
                reference = Optional.empty();
            }
            return reference;
        }

        public Status caseElement(Element droppedElement) {
            Status dropStatus = Status.createFailingStatus(UNSUPPORTED_DROP_CONTAINER);
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            if (this.oldContainer != this.newContainer) {
                String refName = droppedElement.eContainmentFeature().getName();
                if (this.oldContainer.eClass().getEStructuralFeature(refName) != null && this.newContainer.eClass().getEStructuralFeature(refName) != null && State.DONE == (dropStatus = modifier.removeValue(this.oldContainer, refName, droppedElement)).getState()) {
                    dropStatus = modifier.addValue(this.newContainer, refName, droppedElement);
                }
            }
            return dropStatus;
        }

        public Status caseNode(Node node) {
            Status dropStatus = Status.createFailingStatus(UNSUPPORTED_DROP_CONTAINER);
            if (this.oldContainer != this.newContainer) {
                String refName;
                Optional<EReference> optionalContainmentFeature = this.getNodeContainmentFeature(this.newContainer);
                ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
                if (optionalContainmentFeature.isPresent() && State.DONE == (dropStatus = modifier.removeValue(this.oldContainer, refName = node.eContainmentFeature().getName(), node)).getState()) {
                    dropStatus = modifier.addValue(this.newContainer, optionalContainmentFeature.get().getName(), node);
                }
            }
            return dropStatus;
        }

        private Optional<EReference> getNodeContainmentFeature(EObject container) {
            Optional<EReference> reference;
            if (container instanceof Package) {
                Package pkg = (Package)container;
                reference = Optional.of(UMLPackage.eINSTANCE.getPackage_PackagedElement());
            } else if (container instanceof Node) {
                Node node = (Node)container;
                reference = Optional.of(UMLPackage.eINSTANCE.getNode_NestedNode());
            } else {
                reference = Optional.empty();
            }
            return reference;
        }
    }
}

