/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.testutils;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.papyrus.junit.utils.rules.AbstractHouseKeeperRule;
import org.hamcrest.MatcherAssert;
import org.osgi.framework.Bundle;

public class RecursiveCopy {
    protected AbstractHouseKeeperRule houseKeeper;

    public RecursiveCopy(AbstractHouseKeeperRule houseKeeper) {
        this.houseKeeper = houseKeeper;
    }

    public void copy(Bundle srcBundle, String srcPath, IProject dstProject, String dstPath) {
        URL fileURL = srcBundle.getEntry(srcPath);
        MatcherAssert.assertThat((String)"source path is not contained in bundle", (fileURL != null ? 1 : 0) != 0);
        try {
            File file = new File(FileLocator.resolve((URL)fileURL).toURI());
            MatcherAssert.assertThat((String)"source file must exist", (boolean)file.exists());
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File subFile = fileArray[n2];
                    this.copy(srcBundle, srcPath + "/" + subFile.getName(), dstProject, dstPath + "/" + subFile.getName());
                    ++n2;
                }
            } else if (file.isFile()) {
                this.houseKeeper.createFile(dstProject, dstPath, srcPath);
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

