/**
 * Copyright (c) 2015 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.c.codegen.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.c.codegen.preferences.CCodeGenUtils;
import org.eclipse.papyrus.designer.languages.c.codegen.services.UmlCommentServices;
import org.eclipse.papyrus.designer.languages.c.codegen.utils.CClassUtils;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.CppRoot;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ExternLibrary;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.External;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Include;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Template;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class ImportScript {
  public static CharSequence genHeaderIncludes(final Classifier classifier) {
    StringConcatenation _builder = new StringConcatenation();
    String _partComment = UmlCommentServices.partComment(classifier, "Includes and declares");
    _builder.append(_partComment);
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("// Derived includes");
    _builder.newLine();
    {
      List<String> _sort = IterableExtensions.<String>sort(ImportScript.CClassAllIncludesHeader(classifier));
      for(final String path : _sort) {
        String _includeDirective = ImportScript.includeDirective(path);
        _builder.append(_includeDirective);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("// End of Derived includes");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("// Derived declarations");
    _builder.newLine();
    {
      List<String> _sort_1 = IterableExtensions.<String>sort(ImportScript.CClassAllDeclares(classifier));
      for(final String path_1 : _sort_1) {
        String _declareDirective = ImportScript.declareDirective(path_1);
        _builder.append(_declareDirective);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("// End of Derived declares");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    String _CIncludeHeader = ImportScript.CIncludeHeader(classifier);
    _builder.append(_CIncludeHeader, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// Std headers");
    _builder.newLine();
    CharSequence _genStdInclude = ImportScript.genStdInclude();
    _builder.append(_genStdInclude);
    _builder.append(" ");
    _builder.newLineIfNotEmpty();
    _builder.append("// End of Std headers");
    _builder.newLine();
    return _builder;
  }

  public static CharSequence genBodyIncludes(final Classifier classifier) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t\t");
    String _CIncludePreBody = ImportScript.CIncludePreBody(classifier);
    _builder.append(_CIncludePreBody, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("// Include self header");
    _builder.newLine();
    String _name = classifier.getName();
    String _plus = (_name + ".");
    String _headerSuffix = CCodeGenUtils.getHeaderSuffix();
    String _plus_1 = (_plus + _headerSuffix);
    String _includeDirective = ImportScript.includeDirective(_plus_1);
    _builder.append(_includeDirective);
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("// Derived includes");
    _builder.newLine();
    {
      List<String> _sort = IterableExtensions.<String>sort(ImportScript.CClassAllIncludesBody(classifier));
      for(final String path : _sort) {
        String _includeDirective_1 = ImportScript.includeDirective(path);
        _builder.append(_includeDirective_1);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    String _CIncludeBody = ImportScript.CIncludeBody(classifier);
    _builder.append(_CIncludeBody, "\t\t");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public static CharSequence genStdInclude() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#include <stdio.h>");
    _builder.newLine();
    _builder.append("#include <stdlib.h>");
    _builder.newLine();
    _builder.append("#include <stdint.h>");
    _builder.newLine();
    return _builder;
  }

  public static String includeDirective(final String path) {
    if (((path != null) && (path.length() > 0))) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("#include ");
      String _plus = (_builder.toString() + "\"");
      String _plus_1 = (_plus + path);
      return (_plus_1 + "\"");
    }
    return null;
  }

  public static Iterable<String> CClassAllIncludesHeader(final Classifier clazz) {
    return ImportScript.cClassAllIncludes(clazz, CClassUtils.includedClassifiers(clazz));
  }

  public static Iterable<String> CClassAllIncludesBody(final Classifier classifier) {
    return ImportScript.cClassAllIncludes(classifier, CClassUtils.includedImplementationClassifiers(classifier));
  }

  public static Iterable<String> cClassAllIncludes(final Classifier classifier, final EList<Classifier> list) {
    List<String> newList = new ArrayList<String>();
    for (final Classifier cl : list) {
      if ((((!Objects.equals(cl, classifier)) && (!GenUtils.hasStereotype(cl, NoCodeGen.class))) || GenUtils.hasStereotype(cl, External.class))) {
        if (((((cl instanceof Enumeration) || (cl instanceof PrimitiveType)) && 
          (!GenUtils.hasStereotype(cl, External.class))) && 
          (!GenUtils.hasStereotypeTree(cl, ExternLibrary.class)))) {
          if (((cl.getOwner() instanceof org.eclipse.uml2.uml.Package) && (!Objects.equals(cl.getOwner(), classifier.getOwner())))) {
          } else {
          }
        } else {
          List<String> _cClassIncludes = ImportScript.cClassIncludes(cl);
          for (final String includePath : _cClassIncludes) {
            boolean _contains = newList.contains(includePath);
            boolean _not = (!_contains);
            if (_not) {
              newList.add(includePath);
            }
          }
        }
      } else {
      }
    }
    final Function1<String, Boolean> _function = (String str) -> {
      return Boolean.valueOf((str != null));
    };
    return IterableExtensions.<String>filter(newList, _function);
  }

  public static String cOwnerPackageIncludePath(final org.eclipse.uml2.uml.Package pkg) {
    if (((pkg != null) && (!GenUtils.hasStereotype(pkg, CppRoot.class)))) {
      String _fullPath = GenUtils.getFullPath(pkg);
      String _plus = (_fullPath + "/Pkg_");
      String _name = pkg.getName();
      String _plus_1 = (_plus + _name);
      return (_plus_1 + ".h");
    } else {
      return null;
    }
  }

  public static List<String> cClassIncludes(final NamedElement ne) {
    List<String> result = new ArrayList<String>();
    boolean _hasStereotypeTree = GenUtils.hasStereotypeTree(ne, ExternLibrary.class);
    if (_hasStereotypeTree) {
      result.addAll(GenUtils.<ExternLibrary>getApplicationTree(ne, ExternLibrary.class).getIncludes());
      boolean _hasStereotype = GenUtils.hasStereotype(ne, External.class);
      if (_hasStereotype) {
        final String incPath = ImportScript.includeName(ne);
        if ((incPath != null)) {
          result.add(incPath);
        }
      }
    } else {
      result.add(ImportScript.includeName(ne));
    }
    return result;
  }

  public static String includeName(final NamedElement ne) {
    boolean _hasStereotypeTree = GenUtils.hasStereotypeTree(ne, Template.class);
    if (_hasStereotypeTree) {
      return UMLUtil.<Template>getStereotypeApplication(ne, Template.class).getDeclaration();
    } else {
      boolean _hasStereotypeTree_1 = GenUtils.hasStereotypeTree(ne, External.class);
      if (_hasStereotypeTree_1) {
        return UMLUtil.<External>getStereotypeApplication(ne, External.class).getIncPath();
      } else {
        String path = GenUtils.getFullPath(ne.getNearestPackage());
        boolean _equals = path.equals(ne.getModel().getName());
        if (_equals) {
          path = "";
        } else {
          String _name = ne.getModel().getName();
          String _plus = (_name + "/");
          boolean _startsWith = path.startsWith(_plus);
          if (_startsWith) {
            String _fullPath = GenUtils.getFullPath(ne.getNearestPackage());
            String _name_1 = ne.getModel().getName();
            String _plus_1 = (_name_1 + "/");
            String _replace = _fullPath.replace(_plus_1, "");
            String _plus_2 = (_replace + "/");
            path = _plus_2;
          }
        }
        String _name_2 = ne.getName();
        String _plus_3 = (path + _name_2);
        String _plus_4 = (_plus_3 + ".");
        String _headerSuffix = CCodeGenUtils.getHeaderSuffix();
        return (_plus_4 + _headerSuffix);
      }
    }
  }

  public static String declareDirective(final String path) {
    if (((path != null) && (path.length() > 0))) {
      return path;
    }
    return null;
  }

  public static Iterable<String> CClassAllDeclares(final Classifier clazz) {
    return ImportScript.cClassAllDeclares(clazz, CClassUtils.declaredClassifiers(clazz), CClassUtils.includedClassifiers(clazz));
  }

  public static Iterable<String> cClassAllDeclares(final Classifier classifier, final EList<Classifier> declaredClassifiers, final EList<Classifier> includedClassifiers) {
    List<String> newList = new ArrayList<String>();
    if ((declaredClassifiers != null)) {
      if ((includedClassifiers != null)) {
        declaredClassifiers.removeAll(includedClassifiers);
      }
      for (final Classifier cl : declaredClassifiers) {
        if ((((!Objects.equals(cl, classifier)) && (!GenUtils.hasStereotype(cl, NoCodeGen.class))) || GenUtils.hasStereotype(cl, External.class))) {
          String declaration = "";
          if (((!(cl instanceof Enumeration)) && (!(cl instanceof PrimitiveType)))) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("typedef struct ");
            String _name = cl.getName();
            _builder.append(_name);
            _builder.append(" ");
            String _name_1 = cl.getName();
            _builder.append(_name_1);
            _builder.append(";");
            declaration = _builder.toString();
          }
          boolean _notEquals = (!Objects.equals(declaration, ""));
          if (_notEquals) {
            boolean _contains = newList.contains(declaration);
            boolean _not = (!_contains);
            if (_not) {
              newList.add(declaration);
            }
          }
        }
      }
    }
    final Function1<String, Boolean> _function = (String str) -> {
      return Boolean.valueOf((str != null));
    };
    return IterableExtensions.<String>filter(newList, _function);
  }

  public static String CIncludeHeader(final NamedElement ne) {
    boolean _hasStereotype = GenUtils.hasStereotype(ne, Include.class);
    if (_hasStereotype) {
      UMLUtil.<Include>getStereotypeApplication(ne, Include.class);
      String header = UMLUtil.<Include>getStereotypeApplication(ne, Include.class).getHeader();
      if (((header != null) && (header.length() > 0))) {
        CharSequence _constIncludeHeaderStart = ImportScript.constIncludeHeaderStart();
        String _cleanCR = GenUtils.cleanCR(header);
        String _plus = (_constIncludeHeaderStart + _cleanCR);
        String _plus_1 = (_plus + "\n");
        CharSequence _constIncludeHeaderEnd = ImportScript.constIncludeHeaderEnd();
        String includeHeader = (_plus_1 + _constIncludeHeaderEnd);
        return includeHeader;
      }
    }
    return null;
  }

  public static CharSequence constIncludeHeaderStart() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Include from Include stereotype (header)");
    _builder.newLine();
    return _builder;
  }

  public static CharSequence constIncludeHeaderEnd() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// End of Include stereotype (header)");
    _builder.newLine();
    return _builder;
  }

  public static String CIncludePreBody(final NamedElement ne) {
    boolean _hasStereotype = GenUtils.hasStereotype(ne, Include.class);
    if (_hasStereotype) {
      String preBody = UMLUtil.<Include>getStereotypeApplication(ne, Include.class).getPreBody();
      if (((preBody != null) && (preBody.length() > 0))) {
        CharSequence _constIncludePreBodyStart = ImportScript.constIncludePreBodyStart();
        String _cleanCR = GenUtils.cleanCR(preBody);
        String _plus = (_constIncludePreBodyStart + _cleanCR);
        String _plus_1 = (_plus + "\n");
        CharSequence _constIncludePreBodyEnd = ImportScript.constIncludePreBodyEnd();
        String includePreBody = (_plus_1 + _constIncludePreBodyEnd);
        return includePreBody;
      }
    }
    return null;
  }

  public static CharSequence constIncludePreBodyStart() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Include from Include stereotype (preBody)");
    _builder.newLine();
    return _builder;
  }

  public static CharSequence constIncludePreBodyEnd() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// End of Include from Include stereotype (preBody)");
    _builder.newLine();
    return _builder;
  }

  public static String CIncludeBody(final NamedElement ne) {
    boolean _hasStereotype = GenUtils.hasStereotype(ne, Include.class);
    if (_hasStereotype) {
      String body = UMLUtil.<Include>getStereotypeApplication(ne, Include.class).getBody();
      if (((body != null) && (body.length() > 0))) {
        CharSequence _constIncludeBodyStart = ImportScript.constIncludeBodyStart();
        String _cleanCR = GenUtils.cleanCR(body);
        String _plus = (_constIncludeBodyStart + _cleanCR);
        String _plus_1 = (_plus + "\n");
        CharSequence _constIncludeBodyEnd = ImportScript.constIncludeBodyEnd();
        String includeBody = (_plus_1 + _constIncludeBodyEnd);
        return includeBody;
      }
    }
    return null;
  }

  public static CharSequence constIncludeBodyStart() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Include from Include stereotype (body)");
    _builder.newLine();
    return _builder;
  }

  public static CharSequence constIncludeBodyEnd() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// End of Include from Include stereotype (body)");
    _builder.newLine();
    return _builder;
  }
}
