/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.papyrus.uml.profile.drafter.Activator;
import org.eclipse.papyrus.uml.profile.drafter.ProfileApplicator;
import org.eclipse.papyrus.uml.profile.drafter.exceptions.DraftProfileException;
import org.eclipse.papyrus.uml.profile.drafter.ui.dialog.IStereotypeUpdateArgs;
import org.eclipse.papyrus.uml.profile.drafter.ui.dialog.StereotypeUpdateDialog;
import org.eclipse.papyrus.uml.profile.drafter.ui.handler.AbstractProfileBaseHandler;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.StereoptypeModel;
import org.eclipse.papyrus.uml.profile.drafter.utils.UMLMetamodelUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.ExtensionEnd;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class UpdateProfileHandler
extends AbstractProfileBaseHandler {
    private List<NamedElement> cachedSelectionAsNamedElement;
    private IStereotypeUpdateArgs updateArgs;
    private StereoptypeModel stereoptypeModel;

    @Override
    public String getCommandName() {
        return "Add Profile";
    }

    @Override
    protected boolean preExecute(ExecutionEvent event, IEvaluationContext context) throws ExecutionException {
        List<NamedElement> selected = this.getSelectionAsNamedElements(context);
        if (selected.isEmpty()) {
            return false;
        }
        StereotypeUpdateDialog newDialog = new StereotypeUpdateDialog(Display.getCurrent().getActiveShell(), "Update Stereotype", (Element)selected.get(0), new ArrayList<Class>(this.getSelectedElementMetaclasses(context)));
        if (newDialog.open() == 0) {
            this.stereoptypeModel = newDialog.getStereotypeModel();
            this.updateArgs = newDialog.getUpdateArgs();
            return this.updateArgs != null;
        }
        return false;
    }

    private Set<Class> getSelectedElementMetaclasses(IEvaluationContext context) {
        List<NamedElement> selectedElements = this.getSelectionAsNamedElements(context);
        if (selectedElements.isEmpty()) {
            return Collections.emptySet();
        }
        try {
            HashSet<Class> result = new HashSet<Class>();
            UMLMetamodelUtils umlMetamodelUtils = this.getUmlMetamodelUtils(context);
            for (NamedElement sel : selectedElements) {
                result.add(umlMetamodelUtils.getElementMetaclass((Element)sel));
            }
            return result;
        }
        catch (DraftProfileException e) {
            Activator.log.error((Throwable)e);
            return Collections.emptySet();
        }
    }

    @Override
    protected void doExecute(ExecutionEvent event, IEvaluationContext context) {
        List<NamedElement> selected = this.getSelectionAsNamedElements(context);
        ProfileApplicator profileApplicator = new ProfileApplicator(selected.get(0));
        try {
            profileApplicator.updateStereotype(this.stereoptypeModel);
        }
        catch (DraftProfileException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void resetCachedValues() {
        super.resetCachedValues();
        this.cachedSelectionAsNamedElement = null;
    }

    protected List<NamedElement> getSelectionAsNamedElements(IEvaluationContext context) {
        if (this.cachedSelectionAsNamedElement == null) {
            this.cachedSelectionAsNamedElement = this.getSelectionsByType(context, NamedElement.class);
        }
        return this.cachedSelectionAsNamedElement;
    }

    protected Extension createExtension(Stereotype source, Type target) {
        Extension newExtension = UMLFactory.eINSTANCE.createExtension();
        ExtensionEnd endSource = UMLFactory.eINSTANCE.createExtensionEnd();
        endSource.setName("extension_" + source.getName());
        endSource.setType((Type)source);
        endSource.setAggregation(AggregationKind.COMPOSITE_LITERAL);
        newExtension.getOwnedEnds().add((Object)endSource);
        Property property = UMLFactory.eINSTANCE.createProperty();
        property.setName("base_" + target.getName());
        property.setType(target);
        property.setAssociation((Association)newExtension);
        property.setAggregation(AggregationKind.NONE_LITERAL);
        newExtension.getMemberEnds().add((Object)property);
        source.getOwnedAttributes().add((Object)property);
        return newExtension;
    }

    @Override
    public boolean isEnabled(IEvaluationContext context, List<Object> selections) {
        return !selections.isEmpty();
    }
}

