/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.stereotype.display.command;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class CreateStereotypeLabelCommand
extends RecordingCommand {
    private static final String STEREOTYPE_LABEL_COMMAND_NAME = "Stereotype Label Creation Command";
    protected View owner;
    protected Stereotype stereotype;
    protected boolean isVisible;
    protected Element element;

    public CreateStereotypeLabelCommand(TransactionalEditingDomain domain, View owner, Stereotype stereotype) {
        super(domain, STEREOTYPE_LABEL_COMMAND_NAME);
        this.owner = owner;
        this.stereotype = stereotype;
    }

    protected void doExecute() {
        DecorationNode label = NotationFactory.eINSTANCE.createDecorationNode();
        label.setType("StereotypeLabel");
        label.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        label.setElement((EObject)this.stereotype);
        StringValueStyle stereotypeNameStyle = NotationFactory.eINSTANCE.createStringValueStyle();
        stereotypeNameStyle.setName("stereotype");
        stereotypeNameStyle.setStringValue(this.stereotype.getQualifiedName());
        label.getStyles().add((Object)stereotypeNameStyle);
        ViewUtil.insertChildView((View)this.owner, (View)label, (int)-1, (boolean)false);
        label.setMutable(true);
    }
}

