/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.databinding;

import java.lang.reflect.Proxy;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableEvent;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.papyrus.infra.tools.databinding.DelegatingInvocationHandler;
import org.eclipse.papyrus.infra.tools.databinding.DelegatingObservableList;
import org.eclipse.papyrus.infra.tools.databinding.DelegatingObservableSet;
import org.eclipse.papyrus.infra.tools.databinding.DelegatingObservableValue;
import org.eclipse.papyrus.infra.tools.databinding.IDelegatingObservable;
import org.eclipse.papyrus.infra.tools.databinding.ReferenceCountedObservable;

public abstract class DelegatingObservable<T extends IObservable>
extends ReferenceCountedObservable.Abstract
implements IDelegatingObservable {
    private final Class<T> delegateType;
    private T delegate;
    private T realObservable = this;
    private IChangeListener forwardingChangeListener;
    private IStaleListener forwardingStaleListener;
    private IDisposeListener delegateDisposeListener;

    DelegatingObservable(T delegate, Class<T> delegateType) {
        super(delegate.getRealm());
        this.delegateType = delegateType;
        this.setDelegate((IObservable)delegate);
    }

    DelegatingObservable(Realm realm, Class<T> delegateType) {
        super(realm);
        this.delegateType = delegateType;
    }

    public static IObservable wrap(IObservable observable) {
        IObservableList result;
        if (Proxy.isProxyClass(observable.getClass()) && Proxy.getInvocationHandler(observable) instanceof DelegatingInvocationHandler) {
            try {
                result = DelegatingInvocationHandler.wrapDynamicProxy(observable);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("observable is an invalid implementation of IDelegatingObservable", e);
            }
        } else if (observable instanceof IObservableList) {
            result = DelegatingObservableList.wrap((IObservableList)observable);
        } else if (observable instanceof IObservableSet) {
            result = DelegatingObservableSet.wrap((IObservableSet)observable);
        } else if (observable instanceof IObservableValue) {
            result = DelegatingObservableValue.wrap((IObservableValue)observable);
        } else {
            throw new IllegalArgumentException("no delegating wrapper implementation available for observable");
        }
        return result;
    }

    public static <T extends IObservable> T create(Realm realm, Class<T> observableType) {
        return DelegatingObservable.create(realm, observableType, null, new Class[0]);
    }

    public static <T extends IObservable> T create(Realm realm, Class<T> observableType, ClassLoader loader, Class<?> ... mixins) {
        if (observableType == IObservableList.class) {
            return (T)DelegatingObservableList.create(realm, loader, mixins);
        }
        if (observableType == IObservableSet.class) {
            return (T)DelegatingObservableSet.create(realm, loader, mixins);
        }
        if (observableType == IObservableValue.class) {
            return (T)DelegatingObservableValue.create(realm, loader, mixins);
        }
        throw new IllegalArgumentException("observableType");
    }

    @Override
    public final void setDelegate(IObservable delegate) {
        if (this.isDisposed()) {
            throw new IllegalStateException("disposed");
        }
        T oldDelegate = this.delegate;
        if (delegate != oldDelegate) {
            IObservable newDelegate;
            IObservable iObservable = newDelegate = delegate == null ? null : (IObservable)this.delegateType.cast(delegate);
            if (oldDelegate != null) {
                this.unhookDelegate(oldDelegate);
                ReferenceCountedObservable.Util.autorelease(oldDelegate);
            }
            this.delegate = newDelegate;
            if (newDelegate != null) {
                ReferenceCountedObservable.Util.retain(newDelegate);
                this.hookDelegate(newDelegate);
            }
            this.delegateChanged(oldDelegate, newDelegate);
        }
    }

    final void clearDelegate() {
        if (this.delegate != null) {
            this.unhookDelegate(this.delegate);
            this.delegate = null;
            this.fireChange();
        }
    }

    public final T getDelegate() {
        return this.delegate;
    }

    protected void delegateChanged(T oldDelegate, T newDelegate) {
        this.fireChange();
    }

    protected void hookDelegate(T delegate) {
        delegate.addChangeListener(this.getForwardingChangeListener());
        delegate.addStaleListener(this.getForwardingStaleListener());
        delegate.addDisposeListener(this.getDelegateDisposeListener());
    }

    protected void unhookDelegate(T delegate) {
        delegate.removeChangeListener(this.getForwardingChangeListener());
        delegate.removeStaleListener(this.getForwardingStaleListener());
        delegate.removeDisposeListener(this.getDelegateDisposeListener());
    }

    public boolean isStale() {
        this.getterCalled();
        return this.delegate != null && this.delegate.isStale();
    }

    protected void getterCalled() {
        ObservableTracker.getterCalled(this.getRealObservable());
    }

    public boolean equals(Object obj) {
        return obj == this || this.delegate != null && this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate == null ? 0 : this.delegate.hashCode();
    }

    final void setRealObservable(T realObservable) {
        this.realObservable = realObservable;
    }

    final T getRealObservable() {
        return this.realObservable;
    }

    protected final void fireChange() {
        this.fireEvent((ObservableEvent)new ChangeEvent(this.getRealObservable()));
    }

    protected final void fireStale() {
        this.fireEvent((ObservableEvent)new StaleEvent(this.getRealObservable()));
    }

    @Override
    public void dispose() {
        if (!this.isDisposed()) {
            if (this.delegate != null) {
                this.unhookDelegate(this.delegate);
                ReferenceCountedObservable.Util.autorelease(this.delegate);
                this.delegate = null;
            }
            super.dispose();
        }
    }

    protected void fireEvent(ObservableEvent event) {
        if (event instanceof DisposeEvent && event.getSource() != this.getRealObservable()) {
            event = new DisposeEvent(this.getRealObservable());
        }
        super.fireEvent(event);
    }

    private IChangeListener getForwardingChangeListener() {
        if (this.forwardingChangeListener == null) {
            this.forwardingChangeListener = new IChangeListener(){

                public void handleChange(ChangeEvent event) {
                    DelegatingObservable.this.fireChange();
                }
            };
        }
        return this.forwardingChangeListener;
    }

    private IStaleListener getForwardingStaleListener() {
        if (this.forwardingStaleListener == null) {
            this.forwardingStaleListener = new IStaleListener(){

                public void handleStale(StaleEvent staleEvent) {
                    DelegatingObservable.this.fireStale();
                }
            };
        }
        return this.forwardingStaleListener;
    }

    private IDisposeListener getDelegateDisposeListener() {
        if (this.delegateDisposeListener == null) {
            this.delegateDisposeListener = new IDisposeListener(){

                public void handleDispose(DisposeEvent event) {
                    if (event.getObservable() == DelegatingObservable.this.getDelegate()) {
                        DelegatingObservable.this.clearDelegate();
                    }
                }
            };
        }
        return this.delegateDisposeListener;
    }
}

