/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.nebula.richtext;

import java.io.StringReader;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import org.eclipse.nebula.widgets.nattable.extension.nebula.richtext.MarkupProcessor;

public class RegexMarkupValue
implements MarkupProcessor {
    private static final String GROUP_INDEX_PLACEHOLDER = "$1";
    private String originalRegexValue;
    private String markupPrefix;
    private String markupSuffix;
    private String markupValue;
    private String markupRegexValue;
    private XMLInputFactory factory = XMLInputFactory.newInstance();

    public RegexMarkupValue(String value, String markupPrefix, String markupSuffix) {
        this.originalRegexValue = value;
        this.markupPrefix = markupPrefix;
        this.markupSuffix = markupSuffix;
        this.markupValue = String.valueOf(markupPrefix) + GROUP_INDEX_PLACEHOLDER + markupSuffix;
        this.markupRegexValue = String.valueOf(markupPrefix) + value + markupSuffix;
    }

    @Override
    public String applyMarkup(String input) {
        String result = "";
        if (this.getOriginalRegexValue() != null && !this.getOriginalRegexValue().isEmpty()) {
            block22: {
                XMLEventReader parser = null;
                try {
                    try {
                        parser = this.factory.createXMLEventReader(new StringReader("<root>" + input + "</root>"));
                        while (parser.hasNext()) {
                            XMLEvent event = parser.nextEvent();
                            switch (event.getEventType()) {
                                case 7: {
                                    break;
                                }
                                case 8: {
                                    parser.close();
                                    break;
                                }
                                case 4: {
                                    Characters characters = event.asCharacters();
                                    String text = characters.getData();
                                    result = String.valueOf(result) + Pattern.compile(this.getOriginalRegexValue(), 2).matcher(text).replaceAll(this.markupValue);
                                    break;
                                }
                                default: {
                                    result = String.valueOf(result) + event.toString();
                                }
                            }
                        }
                    }
                    catch (XMLStreamException e) {
                        e.printStackTrace();
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (XMLStreamException e2) {
                                e2.printStackTrace();
                            }
                        }
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (XMLStreamException e) {
                            e.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                if (parser != null) {
                    try {
                        parser.close();
                    }
                    catch (XMLStreamException e) {
                        e.printStackTrace();
                    }
                }
            }
            result = result.replace("<root>", "").replace("</root>", "");
        } else {
            result = input;
        }
        return result;
    }

    @Override
    public String removeMarkup(String input) {
        if (this.getOriginalRegexValue() != null && !this.getOriginalRegexValue().isEmpty()) {
            return input.replaceAll(this.getMarkupRegexValue(), GROUP_INDEX_PLACEHOLDER);
        }
        return input;
    }

    public void setRegexValue(String value) {
        this.originalRegexValue = value;
        this.markupRegexValue = String.valueOf(this.markupPrefix) + value + this.markupSuffix;
    }

    protected String getOriginalRegexValue() {
        return this.originalRegexValue;
    }

    protected String getMarkupRegexValue() {
        return this.markupRegexValue;
    }
}

