/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.launching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.dialog.FileTreeContentProvider;
import org.eclipse.acceleo.internal.ide.ui.dialog.ResourceSelectionDialog;
import org.eclipse.acceleo.internal.ide.ui.launching.AcceleoJavaArgumentsTab;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaMainTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoMainTab
extends JavaMainTab {
    private static final String DLG_IMG_HELP = "dialog_help_image";
    private static final String PROFILE_MODE = "profile";
    private static final String PROFILE_EXTENSION = "mtlp";
    private static final String BROWSE_MESSAGE = "AcceleoMainTab.Browse";
    AcceleoJavaArgumentsTab javaArgumentsTab;
    private Text modelText;
    private Text profileModelText;
    private Button modelButton;
    private Button profileModelButton;
    private Text targetText;
    private Button targetButton;
    private Button computeTraceability;
    private Button computeProfiling;
    private Text argumentsText;
    private Combo launchingStrategyCombo;
    private List<String> launchingStrategies;
    private Shell mainTypeShell;

    public AcceleoMainTab(AcceleoJavaArgumentsTab javaArgumentsTab) {
        this.javaArgumentsTab = javaArgumentsTab;
    }

    public void dispose() {
        super.dispose();
        if (this.mainTypeShell != null && !this.mainTypeShell.isDisposed()) {
            this.mainTypeShell.dispose();
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite mainComposite = (Composite)this.getControl();
        this.createAcceleoModelEditor(mainComposite);
        this.createAcceleoTargetEditor(mainComposite);
        if (PROFILE_MODE.equals(this.getLaunchConfigurationDialog().getMode())) {
            this.createAcceleoProfileModelEditor(mainComposite, true);
        } else {
            this.createAcceleoProfileModelEditor(mainComposite, false);
        }
        this.createAcceleoArgumentsEditor(mainComposite);
        new Label(mainComposite, 0);
        Composite endCompositeLeft = this.createComposite(mainComposite, parent.getFont(), 3, 1, 768, 0, 0);
        this.createAcceleoLaunchingStrategyEditor(endCompositeLeft);
        this.createAcceleoTraceabilityEditor(endCompositeLeft);
        if (PROFILE_MODE.equals(this.getLaunchConfigurationDialog().getMode())) {
            this.createAcceleoProfilingEditor(endCompositeLeft, true);
        } else {
            this.createAcceleoProfilingEditor(endCompositeLeft, false);
        }
        Composite mainClassParent = this.fMainText.getParent();
        this.createHelpButton(mainClassParent, AcceleoUIMessages.getString("AcceleoMainTab.Help.JavaClass"));
        Composite projectParent = this.fProjText.getParent();
        this.createHelpButton(projectParent, AcceleoUIMessages.getString("AcceleoMainTab.Help.Project"));
    }

    protected void createMainTypeExtensions(Composite parent) {
        if (this.mainTypeShell == null) {
            this.mainTypeShell = new Shell();
        }
        Composite notVisibleComposite = new Composite((Composite)this.mainTypeShell, 0);
        super.createMainTypeExtensions(notVisibleComposite);
        notVisibleComposite.setVisible(false);
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
        this.updateSettingsVisibility();
    }

    private void updateSettingsVisibility() {
        if (this.computeTraceability != null && this.launchingStrategyCombo != null) {
            if ("Java Application".equals(this.launchingStrategyCombo.getText())) {
                this.computeTraceability.setSelection(false);
                this.computeTraceability.setVisible(false);
            } else {
                this.computeTraceability.setVisible(true);
            }
            this.profileModelButton.setEnabled(this.computeProfiling.getSelection());
            this.profileModelText.setEnabled(this.computeProfiling.getSelection());
        }
    }

    private ToolBar createHelpButton(Composite parent, String helpMessage) {
        Image image = JFaceResources.getImage((String)DLG_IMG_HELP);
        ToolBar result = new ToolBar(parent, 0x880000);
        ++((GridLayout)parent.getLayout()).numColumns;
        result.setLayoutData((Object)new GridData(64));
        ToolItem item = new ToolItem(result, 0);
        item.setImage(image);
        if (helpMessage != null && !"".equals(helpMessage)) {
            item.setToolTipText(helpMessage);
        }
        return result;
    }

    protected void createAcceleoModelEditor(Composite parent) {
        Font font = parent.getFont();
        Group mainGroup = this.createGroup(parent, AcceleoUIMessages.getString("AcceleoMainTab.ModelPath"), 2, 1, 768);
        Composite comp = this.createComposite((Composite)mainGroup, font, 2, 2, 1808, 0, 0);
        this.modelText = this.createSingleText(comp, 1);
        this.modelText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.modelButton = this.createPushButton(comp, AcceleoUIMessages.getString(BROWSE_MESSAGE), null);
        this.modelButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AcceleoMainTab.this.handleBrowseModelButton();
            }
        });
        this.createHelpButton(comp, AcceleoUIMessages.getString("AcceleoMainTab.Help.Model"));
    }

    protected void createAcceleoProfileModelEditor(Composite parent, boolean activatedByDefault) {
        Font font = parent.getFont();
        Group mainGroup = this.createGroup(parent, AcceleoUIMessages.getString("AcceleoMainTab.ProfileModelPath"), 2, 1, 768);
        Composite comp = this.createComposite((Composite)mainGroup, font, 2, 2, 1808, 0, 0);
        this.profileModelText = this.createSingleText(comp, 1);
        this.profileModelText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.profileModelButton = this.createPushButton(comp, AcceleoUIMessages.getString(BROWSE_MESSAGE), null);
        this.profileModelButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                AcceleoMainTab.this.handleBrowseProfileModelButton();
            }
        });
        this.createHelpButton(comp, AcceleoUIMessages.getString("AcceleoMainTab.Help.Profile"));
        this.profileModelText.setEnabled(activatedByDefault);
        this.profileModelButton.setEnabled(activatedByDefault);
    }

    private void handleBrowseModelButton() {
        FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(this.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
        dialog.setTitle(AcceleoUIMessages.getString("AcceleoMainTab.SelectModel"));
        String path = this.modelText.getText();
        if (path != null && path.length() > 0 && new Path(path).lastSegment().length() > 0) {
            dialog.setInitialPattern(new Path(path).lastSegment());
        } else {
            String projectName;
            try {
                projectName = this.getCurrentLaunchConfiguration().getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            }
            catch (CoreException e) {
                projectName = "";
                AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
            }
            String initial = projectName.toLowerCase().contains(".uml") ? "*.uml" : (projectName.toLowerCase().contains(".ecore") ? "*.ecore" : "*.xmi");
            dialog.setInitialPattern(initial);
        }
        dialog.open();
        if (dialog.getResult() != null && dialog.getResult().length > 0 && dialog.getResult()[0] instanceof IFile) {
            this.modelText.setText(((IFile)dialog.getResult()[0]).getFullPath().toString());
        }
    }

    private void handleBrowseProfileModelButton() {
        Object initialResource = new Path(this.profileModelText.getText()).segmentCount() >= 2 && ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.profileModelText.getText())).exists() ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.profileModelText.getText())) : ResourcesPlugin.getWorkspace().getRoot();
        ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.getShell(), (IResource)initialResource, AcceleoUIMessages.getString("AcceleoMainTab.SelectProfileModel"));
        dialog.setContentProvider(new FileTreeContentProvider(true, PROFILE_EXTENSION));
        dialog.open();
        if (dialog.getResult().length > 0 && dialog.getResult()[0] instanceof IPath && ((IPath)dialog.getResult()[0]).segmentCount() > 0) {
            String path = dialog.getResult()[0].toString();
            if (path.endsWith(PROFILE_EXTENSION)) {
                this.profileModelText.setText(path);
            } else if (path.endsWith("/")) {
                this.profileModelText.setText(String.valueOf(path) + "profiling.mtlp");
            } else {
                this.profileModelText.setText(String.valueOf(path) + "/profiling.mtlp");
            }
        }
    }

    protected void createAcceleoTargetEditor(Composite parent) {
        Font font = parent.getFont();
        Group mainGroup = this.createGroup(parent, AcceleoUIMessages.getString("AcceleoMainTab.TargetPath"), 2, 1, 768);
        Composite comp = this.createComposite((Composite)mainGroup, font, 2, 2, 1808, 0, 0);
        this.targetText = this.createSingleText(comp, 1);
        this.targetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.targetButton = this.createPushButton(comp, AcceleoUIMessages.getString(BROWSE_MESSAGE), null);
        this.targetButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AcceleoMainTab.this.handleBrowseTargetButton();
            }
        });
        this.createHelpButton(comp, AcceleoUIMessages.getString("AcceleoMainTab.Help.Target"));
    }

    private void handleBrowseTargetButton() {
        Object[] result;
        IResource initial;
        if (this.targetText.getText() != null && this.targetText.getText().length() > 0) {
            initial = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.targetText.getText()));
            if (initial instanceof IFile) {
                initial = initial.getParent();
            }
        } else {
            initial = null;
        }
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.ContainerSelection"));
        if (initial != null) {
            dialog.setInitialSelections(new Object[]{initial});
        }
        dialog.showClosedProjects(false);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.targetText.setText(((Path)result[0]).toString());
        }
    }

    protected void createAcceleoArgumentsEditor(Composite parent) {
        Font font = parent.getFont();
        Group mainGroup = this.createGroup(parent, AcceleoUIMessages.getString("AcceleoMainTab.Arguments"), 2, 1, 768);
        Composite comp = this.createComposite((Composite)mainGroup, font, 2, 2, 1808, 0, 0);
        this.argumentsText = new Text(comp, 2626);
        GridData gd = new GridData(1808);
        int heightHint = 30;
        gd.heightHint = 30;
        gd.widthHint = 100;
        gd.horizontalSpan = 2;
        this.argumentsText.setLayoutData((Object)gd);
        this.argumentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createHelpButton(comp, AcceleoUIMessages.getString("AcceleoMainTab.Help.Properties"));
    }

    protected void createAcceleoTraceabilityEditor(Composite parent) {
        Font font = parent.getFont();
        Group traceabilityGroup = this.createGroup(parent, AcceleoUIMessages.getString("AcceleoMainTab.Traceability"), 2, 1, 1040);
        Composite comp = this.createComposite((Composite)traceabilityGroup, font, 2, 2, 1808, 0, 0);
        this.computeTraceability = new Button(comp, 32);
        this.computeTraceability.setFont(font);
        GridData gd = new GridData(64);
        gd.horizontalSpan = 1;
        this.computeTraceability.setLayoutData((Object)gd);
        this.computeTraceability.setText(AcceleoUIMessages.getString("AcceleoMainTab.ComputeTraceability"));
        this.computeTraceability.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AcceleoMainTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createHelpButton(comp, AcceleoUIMessages.getString("AcceleoMainTab.Help.Traceability"));
    }

    protected void createAcceleoProfilingEditor(Composite parent, boolean checkedByDefault) {
        Font font = parent.getFont();
        Group profilingGroup = this.createGroup(parent, AcceleoUIMessages.getString("AcceleoMainTab.Profiling"), 2, 1, 1040);
        Composite comp = this.createComposite((Composite)profilingGroup, font, 2, 2, 1808, 0, 0);
        this.computeProfiling = new Button(comp, 32);
        this.computeProfiling.setFont(font);
        GridData gd = new GridData(128);
        gd.horizontalSpan = 1;
        this.computeProfiling.setLayoutData((Object)gd);
        this.computeProfiling.setText(AcceleoUIMessages.getString("AcceleoMainTab.ComputeProfiling"));
        this.computeProfiling.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Widget widget = e.widget;
                if (widget instanceof Button) {
                    Button button = (Button)widget;
                    AcceleoMainTab.this.profileModelText.setEnabled(button.getSelection());
                    AcceleoMainTab.this.profileModelButton.setEnabled(button.getSelection());
                    AcceleoPreferences.switchProfiler((boolean)button.getSelection());
                    AcceleoMainTab.this.updateLaunchConfigurationDialog();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.computeProfiling.setSelection(checkedByDefault);
        this.createHelpButton(comp, AcceleoUIMessages.getString("AcceleoMainTab.Help.Profiling"));
    }

    protected void createAcceleoLaunchingStrategyEditor(Composite parent) {
        Font font = parent.getFont();
        Group launchingGroup = this.createGroup(parent, AcceleoUIMessages.getString("AcceleoMainTab.LaunchingStrategy"), 2, 1, 1040);
        Composite comp = this.createComposite((Composite)launchingGroup, font, 2, 2, 32, 0, 0);
        this.launchingStrategyCombo = new Combo(comp, 8);
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        this.launchingStrategyCombo.setLayoutData((Object)gridData);
        this.launchingStrategyCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AcceleoMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.updateStrategies();
        if (this.launchingStrategyCombo.getItemCount() > 0) {
            this.launchingStrategyCombo.select(0);
        }
        this.createHelpButton(comp, AcceleoUIMessages.getString("AcceleoMainTab.Help.Strategy"));
    }

    private void updateStrategies() {
        if (this.launchingStrategyCombo != null) {
            ArrayList<String> descriptions = new ArrayList<String>();
            Iterator<String> strategies = this.getLaunchingStrategies().iterator();
            while (strategies.hasNext()) {
                descriptions.add(strategies.next());
            }
            this.launchingStrategyCombo.setItems(descriptions.toArray(new String[descriptions.size()]));
            int visibleItemCount = 15;
            if (descriptions.size() < 15) {
                this.launchingStrategyCombo.setVisibleItemCount(descriptions.size());
            } else {
                this.launchingStrategyCombo.setVisibleItemCount(15);
            }
        }
    }

    private Group createGroup(Composite parent, String text, int columns, int hspan, int fill) {
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setText(text);
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    private Composite createComposite(Composite parent, Font font, int columns, int hspan, int fill, int marginwidth, int marginheight) {
        Composite g = new Composite(parent, 0);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = marginwidth;
        layout.marginHeight = marginheight;
        g.setLayout((Layout)layout);
        g.setFont(font);
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    private Text createSingleText(Composite parent, int hspan) {
        Text t = new Text(parent, 2052);
        t.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        t.setLayoutData((Object)gd);
        return t;
    }

    public String getName() {
        return "Acceleo";
    }

    public String getId() {
        return "org.eclipse.acceleo.ide.ui.launching.acceleoMainTab";
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        this.updateAcceleoModelFromConfig(config);
        this.updateAcceleoProfileModelFromConfig(config);
        this.updateAcceleoTargetFromConfig(config);
        this.updateAcceleoTraceabilityFromConfig(config);
        this.updateAcceleoArgumentsFromConfig(config);
        this.updateAcceleoLaunchingStrategyFromConfig(config);
        this.updateSettingsVisibility();
    }

    protected void updateAcceleoModelFromConfig(ILaunchConfiguration config) {
        String model = "";
        try {
            model = config.getAttribute("org.eclipse.acceleo.ide.ui.MODEL_PATH", "");
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        this.modelText.setText(model);
    }

    protected void updateAcceleoProfileModelFromConfig(ILaunchConfiguration config) {
        String model = "";
        try {
            model = config.getAttribute("org.eclipse.acceleo.ide.ui.PROFILE_MODEL_PATH", "");
            boolean profiling = config.getAttribute("org.eclipse.acceleo.ide.ui.COMPUTE_PROFILING", false);
            if (profiling) {
                this.computeProfiling.setSelection(true);
            } else {
                this.computeProfiling.setSelection(false);
            }
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        this.profileModelText.setText(model);
    }

    protected void updateAcceleoTargetFromConfig(ILaunchConfiguration config) {
        String target = "";
        try {
            target = config.getAttribute("org.eclipse.acceleo.ide.ui.TARGET_PATH", "");
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        this.targetText.setText(target);
    }

    protected void updateAcceleoTraceabilityFromConfig(ILaunchConfiguration config) {
        boolean traceability = false;
        try {
            traceability = config.getAttribute("org.eclipse.acceleo.ide.ui.COMPUTE_TRACEABILITY", false);
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        this.computeTraceability.setSelection(traceability);
    }

    protected void updateAcceleoArgumentsFromConfig(ILaunchConfiguration config) {
        String args = "";
        try {
            args = config.getAttribute("org.eclipse.acceleo.ide.ui.ARGUMENTS", "");
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        this.argumentsText.setText(args);
    }

    protected void updateAcceleoLaunchingStrategyFromConfig(ILaunchConfiguration config) {
        String id = "";
        try {
            id = config.getAttribute("org.eclipse.acceleo.ide.ui.LAUNCHING_STRATEGY_DESCRIPTION", "");
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        int item = this.getLaunchingStrategies().indexOf(id);
        if (item == -1) {
            item = 0;
        }
        if (this.launchingStrategyCombo.getItemCount() > item) {
            this.launchingStrategyCombo.select(item);
        } else if (this.launchingStrategyCombo.getItemCount() > 0) {
            this.launchingStrategyCombo.select(0);
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        String target;
        IStatus status;
        boolean result = super.isValid(config);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (result) {
            String model = this.modelText.getText().trim();
            status = workspace.validatePath(model, 1);
            if (status.isOK()) {
                IFile file = workspace.getRoot().getFile((IPath)new Path(model));
                if (!file.exists()) {
                    this.setErrorMessage(AcceleoUIMessages.getString("AcceleoMainTab.Error.MissingModel", model));
                    result = false;
                }
            } else {
                this.setErrorMessage(AcceleoUIMessages.getString("AcceleoMainTab.Error.InvalidModel", model));
                result = false;
            }
        }
        if (result && !(status = workspace.validatePath(target = this.targetText.getText().trim(), 6)).isOK()) {
            this.setErrorMessage(AcceleoUIMessages.getString("AcceleoMainTab.Error.InvalidTarget", target));
            result = false;
        }
        if (result && this.computeProfiling.getSelection()) {
            if ("".equals(this.profileModelText.getText().trim())) {
                this.setErrorMessage(AcceleoUIMessages.getString("AcceleoMainTab.Error.MissingProfileModel"));
                result = false;
            } else if (!this.profileModelText.getText().trim().endsWith(PROFILE_EXTENSION)) {
                this.setErrorMessage(AcceleoUIMessages.getString("AcceleoMainTab.Error.MissingProfileModelExtension"));
                result = false;
            }
        }
        return result;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.javaArgumentsTab != null) {
            this.javaArgumentsTab.updateArguments(config, this.modelText.getText().trim(), this.targetText.getText().trim(), this.argumentsText.getText());
        }
        super.performApply(config);
        config.setAttribute("org.eclipse.acceleo.ide.ui.MODEL_PATH", this.modelText.getText().trim());
        config.setAttribute("org.eclipse.acceleo.ide.ui.COMPUTE_PROFILING", this.computeProfiling.getSelection());
        if (this.computeProfiling.getSelection()) {
            config.setAttribute("org.eclipse.acceleo.ide.ui.PROFILE_MODEL_PATH", this.profileModelText.getText().trim());
        }
        config.setAttribute("org.eclipse.acceleo.ide.ui.TARGET_PATH", this.targetText.getText().trim());
        config.setAttribute("org.eclipse.acceleo.ide.ui.COMPUTE_TRACEABILITY", this.computeTraceability.getSelection());
        config.setAttribute("org.eclipse.acceleo.ide.ui.ARGUMENTS", this.argumentsText.getText());
        config.setAttribute("org.eclipse.acceleo.ide.ui.LAUNCHING_STRATEGY_DESCRIPTION", this.launchingStrategyCombo.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        config.setAttribute("org.eclipse.acceleo.ide.ui.MODEL_PATH", "");
        if (this.computeProfiling != null && this.computeProfiling.getSelection()) {
            config.setAttribute("org.eclipse.acceleo.ide.ui.PROFILE_MODEL_PATH", "");
        }
        config.setAttribute("org.eclipse.acceleo.ide.ui.TARGET_PATH", "");
        config.setAttribute("org.eclipse.acceleo.ide.ui.COMPUTE_TRACEABILITY", false);
        config.setAttribute("org.eclipse.acceleo.ide.ui.ARGUMENTS", "");
        config.setAttribute("org.eclipse.acceleo.ide.ui.LAUNCHING_STRATEGY_DESCRIPTION", "");
    }

    public Image getImage() {
        return AcceleoUIActivator.getDefault().getImage("icons/template-editor/Template_main.gif");
    }

    private List<String> getLaunchingStrategies() {
        ArrayList<String> acceleoStrategies = new ArrayList<String>();
        if (this.launchingStrategies == null) {
            this.launchingStrategies = new ArrayList<String>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.acceleo.ide.ui.launching");
            if (extensionPoint != null && extensionPoint.getExtensions().length > 0) {
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    IConfigurationElement[] members = extension.getConfigurationElements();
                    int j = 0;
                    while (j < members.length) {
                        IConfigurationElement member = members[j];
                        String name = member.getContributor().getName();
                        String description = member.getAttribute("description");
                        if (description != null && description.length() > 0 && "org.eclipse.acceleo.ide.ui".equals(name)) {
                            acceleoStrategies.add(description);
                        } else if (description != null && description.length() > 0) {
                            this.launchingStrategies.add(description);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            Collections.sort(this.launchingStrategies);
        }
        Collections.sort(acceleoStrategies);
        this.launchingStrategies.addAll(0, acceleoStrategies);
        return this.launchingStrategies;
    }
}

