/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.debug.model;

import java.io.File;
import org.eclipse.acceleo.engine.internal.debug.ASTFragment;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AcceleoLineBreakpoint;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AcceleoStackFrame;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AcceleoValue;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AcceleoVariable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class AcceleoModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    public static final String ID_ACCELEO_DEBUG_MODEL = "org.eclipse.acceleo.ide.ui.debug.model.AcceleoModelPresentation";

    public void setAttribute(String attribute, Object value) {
    }

    public Image getImage(Object element) {
        Object result;
        if (element instanceof AcceleoVariable) {
            try {
                result = ((AcceleoValue)((AcceleoVariable)element).getValue()).getImage();
            }
            catch (DebugException e) {
                result = null;
                AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
            }
        } else if (element instanceof AcceleoLineBreakpoint) {
            boolean isEnabled;
            try {
                isEnabled = ((AcceleoLineBreakpoint)((Object)element)).isEnabled();
            }
            catch (CoreException e) {
                isEnabled = true;
            }
            ASTFragment astFragment = ((AcceleoLineBreakpoint)((Object)element)).getASTFragment();
            result = isEnabled && astFragment != null && astFragment.getEObjectNameFilter() != null && astFragment.getEObjectNameFilter().length() > 0 ? AcceleoUIActivator.getDefault().getImage("icons/debug/filteredBrkp.gif") : null;
        } else {
            result = null;
        }
        return result;
    }

    public String getText(Object element) {
        String vRet = AcceleoUIMessages.getString("AcceleoModelPresentation.ElementText");
        if (element instanceof AcceleoLineBreakpoint) {
            AcceleoLineBreakpoint breakPoint = (AcceleoLineBreakpoint)((Object)element);
            try {
                String filePath = breakPoint.getFile() == null ? "" : breakPoint.getFile().getAbsolutePath();
                if (filePath.lastIndexOf(File.separatorChar) != -1) {
                    filePath = filePath.substring(filePath.lastIndexOf(File.separatorChar) + 1);
                }
                vRet = AcceleoUIMessages.getString("AcceleoModelPresentation.BreakpointText", filePath, Integer.toString(breakPoint.getLineNumber()));
            }
            catch (CoreException e) {
                AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
            }
        } else if (element instanceof IProcess) {
            vRet = AcceleoUIMessages.getString("AcceleoModelPresentation.ProcessText");
        } else if (element instanceof IThread) {
            vRet = AcceleoUIMessages.getString("AcceleoModelPresentation.ThreadText");
        } else if (element instanceof IDebugTarget) {
            vRet = AcceleoUIMessages.getString("AcceleoModelPresentation.TargetText");
        } else if (element instanceof AcceleoStackFrame) {
            AcceleoStackFrame stackFrame = (AcceleoStackFrame)((Object)element);
            try {
                vRet = String.valueOf(stackFrame.getASTNodeDisplayString()) + " line : " + stackFrame.getLineNumber();
            }
            catch (DebugException e) {
                AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
            }
        }
        return vRet;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        String detail = "";
        try {
            detail = value.getValueString();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        listener.detailComputed(value, detail);
    }

    public IEditorInput getEditorInput(Object element) {
        IFile workspaceFile;
        Object result = element instanceof File ? ((workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(((File)element).getAbsolutePath()))) != null && workspaceFile.isAccessible() ? new FileEditorInput(workspaceFile) : null) : (element instanceof IFile ? new FileEditorInput((IFile)element) : (element instanceof ILineBreakpoint ? new FileEditorInput((IFile)((ILineBreakpoint)element).getMarker().getResource()) : null));
        return result;
    }

    public String getEditorId(IEditorInput input, Object element) {
        String name = element instanceof File ? ((File)element).getName() : (element instanceof IFile ? ((IFile)element).getName() : (element instanceof ILineBreakpoint ? ((IFile)((ILineBreakpoint)element).getMarker().getResource()).getName() : ""));
        if (name.endsWith(".mtl")) {
            return "org.eclipse.acceleo.ide.ui.editors.template.AcceleoEditor";
        }
        return null;
    }
}

