/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.gc2ac.core;

import graph.Node;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import morphisms.Pair;
import nestedcondition.NestedCondition;
import nestedcondition.NestedConstraint;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.ocl2ac.gc2ac.core.NestedConditionPreparer;
import org.eclipse.emf.henshin.ocl2ac.gc2ac.util.RuleClassifier;
import org.eclipse.emf.henshin.ocl2ac.ocl2gc.util.JointPairs;

public class OverlapOptimizer {
    private Rule rule;
    private NestedConstraint constraint;
    private NestedCondition condition;
    private Set<Pair> overlapPairs;

    public OverlapOptimizer(Rule rule, NestedConstraint constraint, Set<Pair> pairs) {
        this.rule = rule;
        this.constraint = constraint;
        this.overlapPairs = pairs;
    }

    public void optimizeOverlap() {
        NestedConditionPreparer preparer = new NestedConditionPreparer(this.constraint);
        preparer.eliminateForAllANotExistsC();
        this.condition = preparer.getCondition();
        if (preparer.isOfFormNotExistsC(this.condition)) {
            System.out.println("-- The size of the overlap pairs is: " + this.overlapPairs.size());
            if (this.overlapPairs.size() > 0) {
                this.removeThePushoutGraph();
            }
            System.out.println("-- After removing the pushout graph: The size of the overlap pairs is: " + this.overlapPairs.size());
            if (this.overlapPairs.size() > 0) {
                this.removeGraphbeingOnlyOverlappedWithPreservedElements();
            }
            System.out.println("-- After removing the graph overlapped with only preserved elements: The size of the overlap pairs is: " + this.overlapPairs.size());
        }
    }

    private void removeThePushoutGraph() {
        Pair pushoutPair = JointPairs.getPushout();
        System.out.println("The pushout graph is removed.");
        System.out.println("PushoutNodes: " + pushoutPair.getA().getCodomain().getNodes());
        this.overlapPairs.remove(pushoutPair);
    }

    private void removeGraphbeingOnlyOverlappedWithPreservedElements() {
        RuleClassifier rc = new RuleClassifier(this.rule);
        if (rc.preserveActionNodes.size() > 0) {
            BasicEList crtDelnodes = new BasicEList();
            crtDelnodes.addAll(rc.createActionNodes);
            crtDelnodes.addAll(rc.deleteActionNodes);
            EList<Edge> createActionEdges = rc.createActionEdges;
            ArrayList<String> nodeNames = new ArrayList<String>();
            if (crtDelnodes.size() > 0) {
                int i = 0;
                while (i < crtDelnodes.size()) {
                    org.eclipse.emf.henshin.model.Node node = (org.eclipse.emf.henshin.model.Node)crtDelnodes.get(i);
                    if (node.getName() != null) {
                        nodeNames.add(node.getName());
                    }
                    ++i;
                }
            }
            boolean pairToremoved = false;
            Iterator<Pair> ite = this.overlapPairs.iterator();
            while (ite.hasNext()) {
                Pair p = ite.next();
                pairToremoved = true;
                if (crtDelnodes.size() > 0) {
                    for (Node node : p.getA().getCodomain().getNodes()) {
                        if (node.getName().contains("=")) {
                            for (String name : nodeNames) {
                                if (!node.getName().contains(name)) continue;
                                pairToremoved = false;
                                break;
                            }
                        }
                        if (!pairToremoved) break;
                    }
                }
                if (!pairToremoved) continue;
                for (graph.Edge e : p.getA().getCodomain().getEdges()) {
                    if (!e.getSource().getName().contains("=") || !e.getTarget().getName().contains("=")) continue;
                    System.out.println("The src and tgt nodes of the edge of type " + e.getType().getName() + " are merged.");
                    if (!this.containsEdgesWithTheSameName(createActionEdges, e)) continue;
                    System.out.println("There is an overlap with a created edge of type " + e.getType().getName() + ".");
                    pairToremoved = false;
                    break;
                }
                if (!pairToremoved) continue;
                System.out.println("Removed: " + p.getA().getCodomain().getNodes());
                ite.remove();
            }
        }
    }

    private boolean containsEdgesWithTheSameName(EList<Edge> hesnhinEdges, graph.Edge edge) {
        if (hesnhinEdges == null || hesnhinEdges.size() == 0) {
            return false;
        }
        for (Edge henEdge : hesnhinEdges) {
            if (henEdge.getType().getName() != edge.getType().getName()) continue;
            return true;
        }
        return false;
    }
}

