/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.mining.core;

import de.parsemis.graph.Edge;
import de.parsemis.graph.Node;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinEdge;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinNode;

public class HenshinGraphToParsemisGraphElementsMap {
    private Map<HenshinNode, Integer> nodeToIndexMap = new HashMap<HenshinNode, Integer>();
    private Map<Integer, HenshinNode> indexToNodeMap = new HashMap<Integer, HenshinNode>();
    private Map<HenshinEdge, Integer> edgeToIndexMap = new HashMap<HenshinEdge, Integer>();
    private Map<Integer, HenshinEdge> indexToEdgeMap = new HashMap<Integer, HenshinEdge>();

    public void put(HenshinEdge relation, int index) {
        this.edgeToIndexMap.put(relation, index);
        this.indexToEdgeMap.put(index, relation);
    }

    public void put(HenshinNode node, int index) {
        this.nodeToIndexMap.put(node, index);
        this.indexToNodeMap.put(index, node);
    }

    public HenshinEdge get(Edge edge) {
        return this.indexToEdgeMap.get(edge.getIndex());
    }

    public HenshinNode get(Node node) {
        return this.indexToNodeMap.get(node.getIndex());
    }

    public boolean contains(HenshinNode node) {
        return this.nodeToIndexMap.containsKey(node);
    }

    public int get(HenshinNode node) {
        return this.nodeToIndexMap.get(node);
    }
}

