/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.mining;

import de.parsemis.algorithms.gSpan.Algorithm;
import de.parsemis.graph.Edge;
import de.parsemis.graph.Graph;
import de.parsemis.graph.HPGraph;
import de.parsemis.graph.HPListGraph;
import de.parsemis.graph.Node;
import de.parsemis.miner.environment.Settings;
import de.parsemis.miner.general.Embedding;
import de.parsemis.miner.general.Fragment;
import de.parsemis.miner.general.HPEmbedding;
import de.parsemis.miner.general.IntFrequency;
import de.parsemis.parsers.LabelParser;
import de.parsemis.strategy.ThreadedDFSStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.henshin.variability.mergein.mining.core.HenshinGraphToParsemisGraphElementsMap;
import org.eclipse.emf.henshin.variability.mergein.mining.core.HenshinGraphToParsemisGraphMap;
import org.eclipse.emf.henshin.variability.mergein.mining.core.ParsemisParserSerializer;
import org.eclipse.emf.henshin.variability.mergein.mining.core.TransformationSystemMiner;
import org.eclipse.emf.henshin.variability.mergein.mining.labels.IEdgeLabel;
import org.eclipse.emf.henshin.variability.mergein.mining.labels.INodeLabel;
import org.eclipse.emf.henshin.variability.mergein.normalize.AttributeEReference;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinEdge;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinGraph;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinGraphElement;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinNode;

public class MiningManager {
    private TransformationSystemMiner miner = new TransformationSystemMiner(this);
    private Settings<INodeLabel, IEdgeLabel> settings = new Settings();
    private ParsemisParserSerializer serializer = new ParsemisParserSerializer();
    private List<HenshinGraph> ruleGraphs;
    private HenshinGraphToParsemisGraphMap henshinToParsemisGraphMap = new HenshinGraphToParsemisGraphMap();
    private Map<Graph, HenshinGraphToParsemisGraphElementsMap> henshinToMinableGraphElementMap = new HashMap<Graph, HenshinGraphToParsemisGraphElementsMap>();
    private List<Fragment<INodeLabel, IEdgeLabel>> minedFragments;

    public MiningManager(List<HenshinGraph> ruleGraphs) {
        this.ruleGraphs = ruleGraphs;
        this.settings.algorithm = new Algorithm();
        this.settings.strategy = new ThreadedDFSStrategy(1, null);
        this.settings.connectedFragments = true;
        this.settings.embeddingBased = true;
        this.settings.storeEmbeddings = true;
        this.settings.closeGraph = true;
        this.settings.singleRooted = false;
        this.settings.minFreq = new IntFrequency(2);
        this.settings.minNodes = 3;
        this.settings.minEdges = 2;
        this.settings.factory = new HPListGraph.Factory((LabelParser)new ParsemisParserSerializer(), (LabelParser)new ParsemisParserSerializer());
    }

    public List<Fragment<INodeLabel, IEdgeLabel>> getMinedFragments() {
        return this.minedFragments;
    }

    public List<HenshinNode> getNodesCorrespondingToFragmentNode(Node<INodeLabel, IEdgeLabel> node, Fragment<INodeLabel, IEdgeLabel> fragment) {
        ArrayList<HenshinNode> nodeList = new ArrayList<HenshinNode>();
        int nodeIndex = node.getIndex();
        for (Embedding embedding : fragment.getMaximalNonOverlappingSubSet()) {
            HPEmbedding highPerformantEmbedding = embedding.toHPEmbedding();
            HPGraph highPerformantSuperGraph = highPerformantEmbedding.getSuperGraph();
            Node superGraphNode = highPerformantSuperGraph.toGraph().getNode(highPerformantEmbedding.getSuperGraphNode(nodeIndex));
            HenshinNode correspondingNode = this.henshinToMinableGraphElementMap.get(superGraphNode.getGraph()).get(superGraphNode);
            nodeList.add(correspondingNode);
        }
        return nodeList;
    }

    public List<HenshinEdge> getEdgesCorrespondingToFragmentEdge(Edge<INodeLabel, IEdgeLabel> edge, Fragment<INodeLabel, IEdgeLabel> fragment) {
        ArrayList<HenshinEdge> result = new ArrayList<HenshinEdge>();
        HashSet<HenshinGraph> considered = new HashSet<HenshinGraph>();
        int edgeIndex = edge.getIndex();
        for (Embedding embedding : fragment.getMaximalNonOverlappingSubSet()) {
            HPEmbedding highPerformantEmbedding = embedding.toHPEmbedding();
            HPGraph highPerformantSupergraph = highPerformantEmbedding.getSuperGraph();
            Edge superGraphEdge = highPerformantSupergraph.toGraph().getEdge(highPerformantEmbedding.getSuperGraphEdge(edgeIndex));
            HenshinEdge correspondingEdge = this.getHenshinEdge((Edge<INodeLabel, IEdgeLabel>)superGraphEdge);
            if (considered.contains((Object)correspondingEdge.getHenshinGraph())) continue;
            result.add(correspondingEdge);
            considered.add(correspondingEdge.getHenshinGraph());
        }
        return result;
    }

    public String printFragment(Fragment f) {
        return this.serializer.serialize((Graph<INodeLabel, IEdgeLabel>)f.toGraph());
    }

    public List<Set<HenshinGraphElement>> getGraphElementsOfEmbeddings(Fragment<INodeLabel, IEdgeLabel> fragment) {
        ArrayList<Set<HenshinGraphElement>> embeddings = new ArrayList<Set<HenshinGraphElement>>();
        for (Embedding emb : fragment.getMaximalNonOverlappingSubSet()) {
            HashSet<HenshinGraphElement> embeddedElements = new HashSet<HenshinGraphElement>();
            HPEmbedding highPerformantEmbedding = emb.toHPEmbedding();
            HPGraph highPerformantSupergraph = highPerformantEmbedding.getSuperGraph();
            int nodeCount = fragment.toGraph().getNodeCount();
            int i = 0;
            while (i < nodeCount) {
                Node superGraphNode = highPerformantSupergraph.toGraph().getNode(highPerformantEmbedding.getSuperGraphNode(i));
                HenshinGraphToParsemisGraphElementsMap map = this.henshinToMinableGraphElementMap.get(superGraphNode.getGraph());
                HenshinNode node = map.get(superGraphNode);
                embeddedElements.add(node);
                ++i;
            }
            int edgeCount = fragment.toGraph().getEdgeCount();
            int i2 = 0;
            while (i2 < edgeCount) {
                Edge superGraphEdge = highPerformantSupergraph.toGraph().getEdge(highPerformantEmbedding.getSuperGraphEdge(i2));
                HenshinGraphToParsemisGraphElementsMap map = this.henshinToMinableGraphElementMap.get(superGraphEdge.getGraph());
                HenshinEdge edge = map.get(superGraphEdge);
                embeddedElements.add(edge);
                ++i2;
            }
            embeddings.add(embeddedElements);
        }
        return embeddings;
    }

    public List<HenshinGraph> getRuleGraphs() {
        return this.ruleGraphs;
    }

    public String getFrequency(Fragment<INodeLabel, IEdgeLabel> frag) {
        return frag.frequency().toString();
    }

    public void doMining() {
        this.miner.doGraphMining();
    }

    public TransformationSystemMiner getTransformationSystemMiner() {
        return this.miner;
    }

    public Settings<INodeLabel, IEdgeLabel> getSettings() {
        return this.settings;
    }

    public void setMinedFragments(List<Fragment<INodeLabel, IEdgeLabel>> minedFragments) {
        this.minedFragments = minedFragments;
    }

    public void setMaxNodeCount(int maxNodeCount) {
        this.settings.maxNodes = maxNodeCount;
    }

    public void setMaxFreq(int maxFreq) {
        this.settings.maxFreq = new IntFrequency(maxFreq);
    }

    public List<Graph<INodeLabel, IEdgeLabel>> getParsemisGraphs() {
        return this.henshinToParsemisGraphMap.getMinableGraphs();
    }

    public void addParsemisGraph(HenshinGraph henshinGraph, Graph<INodeLabel, IEdgeLabel> graph) {
        this.henshinToParsemisGraphMap.put(henshinGraph, graph);
    }

    public Map<Graph, HenshinGraphToParsemisGraphElementsMap> getHenshinToMinableGraphElementsMap() {
        return this.henshinToMinableGraphElementMap;
    }

    public Set<HenshinEdge> getSuperGraphEdges(Embedding<INodeLabel, IEdgeLabel> e1) {
        HashSet<HenshinEdge> result = new HashSet<HenshinEdge>();
        Iterator it = e1.getSuperGraph().edgeIterator();
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            result.add(this.getHenshinEdge((Edge<INodeLabel, IEdgeLabel>)e));
        }
        return result;
    }

    private HenshinEdge getHenshinEdge(Edge<INodeLabel, IEdgeLabel> edge) {
        return this.henshinToMinableGraphElementMap.get(edge.getGraph()).get(edge);
    }

    public Map<HenshinEdge, Map<HenshinGraph, HenshinEdge>> createHenshinEdgeMappings(Fragment<INodeLabel, IEdgeLabel> fragment) {
        HashMap<HenshinEdge, Map<HenshinGraph, HenshinEdge>> outerMap = new HashMap<HenshinEdge, Map<HenshinGraph, HenshinEdge>>();
        for (Embedding e1 : fragment.getEmbeddings()) {
            Iterator it = e1.getSubGraph().edgeIterator();
            while (it.hasNext()) {
                HashSet<HenshinGraph> considered = new HashSet<HenshinGraph>();
                Edge subGraphEdge = (Edge)it.next();
                List<HenshinEdge> correspondingEdges = this.getEdgesCorrespondingToFragmentEdge((Edge<INodeLabel, IEdgeLabel>)subGraphEdge, fragment);
                HashMap<HenshinGraph, HenshinEdge> innerMap = new HashMap<HenshinGraph, HenshinEdge>();
                HenshinGraph graph = correspondingEdges.iterator().next().getHenshinGraph();
                if (considered.contains((Object)graph)) continue;
                for (HenshinEdge edge : correspondingEdges) {
                    innerMap.put(edge.getHenshinGraph(), edge);
                    outerMap.put(edge, innerMap);
                }
                considered.add(graph);
            }
        }
        return outerMap;
    }

    public Map<HenshinEdge, Map<HenshinGraph, HenshinEdge>> createHenshinAttributeMappings(Fragment<INodeLabel, IEdgeLabel> fragment) {
        HashMap<HenshinEdge, Map<HenshinGraph, HenshinEdge>> outerMap = new HashMap<HenshinEdge, Map<HenshinGraph, HenshinEdge>>();
        for (Embedding e1 : fragment.getEmbeddings()) {
            Iterator it = e1.getSubGraph().edgeIterator();
            while (it.hasNext()) {
                Edge subGraphEdge = (Edge)it.next();
                List<HenshinEdge> correspondingEdges = this.getEdgesCorrespondingToFragmentEdge((Edge<INodeLabel, IEdgeLabel>)subGraphEdge, fragment);
                if (correspondingEdges.get(0).getType() != AttributeEReference.instance) continue;
                HashMap<HenshinGraph, HenshinEdge> innerMap = new HashMap<HenshinGraph, HenshinEdge>();
                for (HenshinEdge attributeEdge : correspondingEdges) {
                    innerMap.put(attributeEdge.getHenshinGraph(), attributeEdge);
                    outerMap.put(attributeEdge, innerMap);
                }
            }
        }
        return outerMap;
    }
}

