/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.configuration.ui.providers;

import configuration.Configuration;
import configuration.ConfigurationFactory;
import configuration.Favorite;
import configuration.Feature;
import configuration.impl.ConfigurationFactoryImpl;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityFactory;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityRule;

public class ConfigurationProvider {
    private static final String REGEX = "def\\((.*?)\\)";
    private Map<Rule, Configuration> currentConfigurations = new HashMap<Rule, Configuration>();
    private Map<Rule, Set<Favorite>> favoriteConfigurations = new HashMap<Rule, Set<Favorite>>();
    private static ConfigurationProvider vpProvider = new ConfigurationProvider();
    ConfigurationFactory fac = ConfigurationFactory.eINSTANCE;

    public static ConfigurationProvider getInstance() {
        return vpProvider;
    }

    public Configuration getConfiguration(Rule rule) {
        Configuration result = null;
        result = this.currentConfigurations.containsKey(rule) ? this.currentConfigurations.get(rule) : this.createConfiguration(rule);
        return result;
    }

    public Configuration getConfiguration(Favorite favorite) {
        Configuration result = null;
        result = this.fac.createConfiguration((Configuration)favorite);
        result.setRule((Rule)favorite.getRule());
        this.currentConfigurations.put((Rule)result.getRule(), result);
        return result;
    }

    public Favorite addConfigurationToFavorites(Rule rule, String name, Configuration configuration) {
        if (this.favoriteConfigurations.get(rule) == null) {
            this.favoriteConfigurations.put(rule, new LinkedHashSet());
        }
        Favorite favorite = this.fac.createFavorite(configuration);
        favorite.setRule(rule);
        favorite.setName(name);
        this.favoriteConfigurations.get(rule).add(favorite);
        return favorite;
    }

    private Favorite findMatchingFavorite(Configuration configuration) {
        Favorite result = null;
        Set<Favorite> ruleFavorites = this.favoriteConfigurations.get(configuration.getRule());
        if (ruleFavorites != null) {
            for (Favorite favorite : ruleFavorites) {
                if (favorite.getFeatures().size() != configuration.getFeatures().size()) continue;
                int matches = 0;
                int i = favorite.getFeatures().size() - 1;
                while (i >= 0) {
                    Feature favVP = (Feature)favorite.getFeatures().get(i);
                    Feature conVP = (Feature)configuration.getFeatures().get(i);
                    if (conVP.getName().equals(favVP.getName()) && conVP.getBinding() == favVP.getBinding()) {
                        ++matches;
                    }
                    --i;
                }
                if (matches != configuration.getFeatures().size()) continue;
                result = favorite;
                break;
            }
        }
        return result;
    }

    public void clearFavorites(Configuration configuration) {
        Set<Favorite> favorites = this.favoriteConfigurations.get(configuration.getRule());
        if (favorites != null) {
            favorites.clear();
        }
    }

    public void removeConfigurationFromFavorites(Configuration configuration) {
        Favorite favorite = this.findMatchingFavorite(configuration);
        if (favorite != null) {
            this.favoriteConfigurations.get(configuration.getRule()).remove(favorite);
        }
    }

    public boolean isFavorite(Configuration configuration) {
        return this.findMatchingFavorite(configuration) != null;
    }

    public Favorite findFavorite(Configuration configuration) {
        return this.findMatchingFavorite(configuration);
    }

    public void addFavorites(Rule rule, Set<Favorite> favoritesSet) {
        this.favoriteConfigurations.put(rule, favoritesSet);
    }

    public Set<Favorite> getFavorites(Rule rule) {
        return this.favoriteConfigurations.get(rule);
    }

    private Configuration createConfiguration(Rule rule) {
        Configuration result = null;
        if (rule != null) {
            VariabilityRule varRule = VariabilityFactory.createVariabilityRule((Rule)rule);
            ConfigurationFactory fac = ConfigurationFactoryImpl.init();
            result = fac.createConfiguration();
            result.setRule(rule);
            String featureModel = varRule.getFeatureModel();
            EList variabilityPoints = result.getFeatures();
            if (varRule.getFeatures() != null) {
                for (String variabilityPointName : varRule.getFeatures()) {
                    Feature vp = fac.createFeature();
                    vp.setName(variabilityPointName);
                    variabilityPoints.add((Object)vp);
                }
            } else if (featureModel != null && !featureModel.isEmpty()) {
                Matcher match = Pattern.compile(REGEX).matcher(featureModel);
                while (match.find()) {
                    int i = 1;
                    while (i <= match.groupCount()) {
                        Feature vp = fac.createFeature();
                        vp.setName(match.group(i));
                        variabilityPoints.add((Object)vp);
                        ++i;
                    }
                }
            }
            this.currentConfigurations.put(rule, result);
        }
        return result;
    }
}

