/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.configuration.ui.dialogs;

import java.util.List;
import java.util.PropertyResourceBundle;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.henshin.variability.ui.Activator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NameDialog
extends Dialog {
    private String name = "";
    private String title;
    private String description;
    private String error;
    private Text txtName;
    private Label lblError;
    private List<String> takenNames;

    public NameDialog(Shell parentShell, String dialogContext, List<String> takenNames) {
        super(parentShell);
        PropertyResourceBundle properties = Activator.getProperties();
        this.title = properties.getString("_Dialog_Name_Title_" + dialogContext);
        this.description = properties.getString("_Dialog_Name_Description_" + dialogContext);
        this.error = properties.getString("_Dialog_Name_Error_" + dialogContext);
        this.takenNames = takenNames;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = 5;
        layout.marginRight = 5;
        layout.marginLeft = 5;
        container.setLayout((Layout)layout);
        Label lblDescription = new Label(container, 0);
        lblDescription.setText(this.description);
        lblDescription.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lblSeparator = new Label(container, 258);
        lblSeparator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lblName = new Label(container, 0);
        lblName.setText("Name");
        this.txtName = new Text(container, 2048);
        this.txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text textWidget = (Text)e.getSource();
                String nameText = textWidget.getText();
                NameDialog.this.name = nameText;
                NameDialog.this.validate();
            }
        });
        new Label(container, 0);
        this.lblError = new Label(container, 0);
        this.lblError.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblError.setForeground(ColorConstants.red);
        this.lblError.setAlignment(0x1000000);
        return super.createDialogArea(parent);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private void validate() {
        if (this.name.isEmpty()) {
            this.getButton(0).setEnabled(false);
            this.lblError.setText("");
        } else if (this.takenNames.contains(this.name)) {
            this.getButton(0).setEnabled(false);
            this.lblError.setText(this.error);
        } else {
            this.getButton(0).setEnabled(true);
            this.lblError.setText("");
        }
    }
}

