/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.text.ui.handler;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.henshin.interpreter.ui.wizard.HenshinWizard;
import org.eclipse.emf.henshin.interpreter.ui.wizard.HenshinWizardDialog;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.text.henshin_text.Model;
import org.eclipse.emf.henshin.text.henshin_text.ModelElement;
import org.eclipse.emf.henshin.text.ui.util.Transformation;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class ApplyTransformationHandler
extends AbstractHandler
implements IHandler {
    @Inject
    EObjectAtOffsetHelper eObjectAtOffsetHelper;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Resource henshin_textResource = null;
        String modelElementName = "";
        if (HandlerUtil.getActiveMenuSelection((ExecutionEvent)event) instanceof TreeSelection) {
            IFile file;
            Object first;
            IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
            if (selection.size() == 1 && (first = selection.getFirstElement()) instanceof IFile && "henshin_text".equals((file = (IFile)first).getFileExtension())) {
                URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toOSString(), (boolean)true);
                ResourceSetImpl henshin_textResourceSet = new ResourceSetImpl();
                henshin_textResource = henshin_textResourceSet.getResource(uri, true);
            }
        } else if (HandlerUtil.getActiveMenuSelection((ExecutionEvent)event) instanceof TextSelection) {
            if (((XtextEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event)).isDirty()) {
                ((XtextEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event)).doSave(null);
            }
            URI uri = URI.createPlatformResourceURI((String)((XtextEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event)).getResource().getFullPath().toString(), (boolean)true);
            ResourceSetImpl henshin_textResourceSet = new ResourceSetImpl();
            henshin_textResource = henshin_textResourceSet.getResource(uri, true);
            modelElementName = this.getCalledElementName(event).replace(" ", "");
        }
        if (henshin_textResource != null) {
            Status errorStatus;
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate((EObject)henshin_textResource.getContents().get(0));
            if (henshin_textResource.getErrors().isEmpty() && (diagnostic.getSeverity() == 0 || diagnostic.getSeverity() == 2)) {
                if (((Model)henshin_textResource.getContents().get(0)).getTransformationsystem().size() > 0) {
                    ResourceSetImpl resourceSetTransform = new ResourceSetImpl();
                    String uriMy = String.valueOf(henshin_textResource.getURI().toString().replace(".", "_")) + ".henshin";
                    Resource resourceResult = resourceSetTransform.createResource(URI.createURI((String)uriMy));
                    Transformation transformation = new Transformation();
                    resourceResult = transformation.transformHenshin_textToHenshin(henshin_textResource, "platform:/plugin/org.eclipse.emf.henshin.text.transformation/transforms/Henshin_text2HenshinTransformation/Henshin_text2HenshinTransformation.qvto", "");
                    if (resourceResult != null) {
                        List<Unit> help = this.orderUnits((EList<Unit>)((Module)resourceResult.getContents().get(0)).getUnits());
                        ((Module)resourceResult.getContents().get(0)).getUnits().clear();
                        ((Module)resourceResult.getContents().get(0)).getUnits().addAll(help);
                        Unit unit = this.getUnitByName((List<Unit>)((Module)resourceResult.getContents().get(0)).getUnits(), modelElementName);
                        HenshinWizard tWiz = unit != null ? new HenshinWizard(unit) : new HenshinWizard((Module)resourceResult.getContents().get(0));
                        HenshinWizardDialog dialog = new HenshinWizardDialog(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell(), tWiz);
                        dialog.open();
                    } else {
                        Status errorStatus2 = new Status(4, "org.eclipse.emf.henshin.text.ui", "Can`t transform " + ((XtextEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event)).getResource().getName() + "!");
                        ErrorDialog.openError((Shell)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell(), (String)"Apply Henshin Transformation", null, (IStatus)errorStatus2);
                    }
                } else {
                    errorStatus = new Status(4, "org.eclipse.emf.henshin.text.ui", "Please define a rule or a unit!");
                    ErrorDialog.openError((Shell)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell(), (String)"Apply Henshin Transformation", null, (IStatus)errorStatus);
                }
            } else {
                errorStatus = new Status(4, "org.eclipse.emf.henshin.text.ui", "Please fix existing errors in " + ((XtextEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event)).getResource().getName() + "!");
                ErrorDialog.openError((Shell)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell(), (String)"Apply Henshin Transformation", null, (IStatus)errorStatus);
            }
        } else {
            Status errorStatus = new Status(4, "org.eclipse.emf.henshin.text.ui", "Handler needs to be executed on henshin_text file or inside the henshin text editor!");
            ErrorDialog.openError((Shell)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell(), (String)"Apply Henshin Transformation", null, (IStatus)errorStatus);
        }
        return null;
    }

    private String getCalledElementName(ExecutionEvent event) {
        EObject astObject = null;
        final int eventIndex = ((TextSelection)HandlerUtil.getShowInSelection((ExecutionEvent)event)).getOffset();
        XtextEditor editor = EditorUtils.getActiveXtextEditor((ExecutionEvent)event);
        if (editor != null) {
            astObject = (EObject)editor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<EObject, XtextResource>(){

                public EObject exec(XtextResource localResource) throws Exception {
                    return ApplyTransformationHandler.this.eObjectAtOffsetHelper.resolveContainedElementAt(localResource, eventIndex);
                }
            });
        }
        while (!(astObject == null || astObject instanceof ModelElement && (astObject.eContainer() instanceof Module || astObject.eContainer() instanceof Model))) {
            astObject = astObject.eContainer();
        }
        if (astObject instanceof ModelElement) {
            return ((ModelElement)astObject).getName();
        }
        return "";
    }

    private List<Unit> orderUnits(EList<Unit> units) {
        ArrayList<Unit> outerUnits = new ArrayList<Unit>();
        ArrayList<Unit> innerUnits = new ArrayList<Unit>();
        for (Unit u : units) {
            boolean isOuterUnit = true;
            for (Unit outerUnit : units) {
                if (!outerUnit.getSubUnits(true).contains((Object)u)) continue;
                isOuterUnit = false;
                break;
            }
            if (isOuterUnit) {
                innerUnits.add(u);
                continue;
            }
            outerUnits.add(u);
        }
        innerUnits.addAll(outerUnits);
        return innerUnits;
    }

    private Unit getUnitByName(List<Unit> units, String name) {
        for (Unit unit : units) {
            if (!unit.getName().equals(name)) continue;
            return unit;
        }
        return null;
    }
}

