/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.wrap.mme;

import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.henshin.interpreter.ApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.LoggingApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;
import org.eclipse.emf.henshin.wrap.WObject;
import org.eclipse.emf.henshin.wrap.WrapFactory;

public class PetriNetMME {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/wrap/mme";

    public static void run(String path, boolean saveResult) {
        HenshinResourceSet resourceSet = new HenshinResourceSet(path);
        Module module = resourceSet.getModule("mme.henshin", false);
        EPackage petriMetamodel = (EPackage)resourceSet.registerDynamicEPackages("petri.ecore").get(0);
        EObject petriModel = resourceSet.getEObject("net.xmi");
        Map wrappedPetriNet = WrapFactory.eINSTANCE.createWModelTree(Collections.singleton(petriModel), true);
        WObject petriNetWrapper = (WObject)wrappedPetriNet.get(petriModel);
        EGraphImpl graph = new EGraphImpl();
        graph.addGraph((EObject)petriMetamodel);
        for (WObject wrapper : wrappedPetriNet.values()) {
            graph.addGraph((EObject)wrapper);
        }
        EngineImpl engine = new EngineImpl(new String[0]);
        Unit main = module.getUnit("main");
        UnitApplicationImpl app = new UnitApplicationImpl((Engine)engine, (EGraph)graph, main, null);
        if (!app.execute((ApplicationMonitor)new LoggingApplicationMonitor())) {
            throw new RuntimeException("Cannot apply transformation");
        }
        System.out.println("Petri net meta-model evolution finished.");
        if (saveResult) {
            resourceSet.saveEObject((EObject)petriMetamodel, "petri1.ecore");
            resourceSet.saveEObject(petriNetWrapper.getEObject(), "net1.xmi");
            System.out.println("Results saved to petri1.ecore and net1.xmi.");
        }
    }

    public static void main(String[] args) {
        PetriNetMME.run(PATH, true);
    }
}

