/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.commands;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Node;

public class PropagateImportsCommand
extends AbstractCommand
implements Command {
    protected CommandParameter commandParameter;
    protected EditingDomain domain;
    protected Module module;
    protected Set<EPackage> missingPackages = new TreeSet<EPackage>(new Comparator<EPackage>(){

        @Override
        public int compare(EPackage o1, EPackage o2) {
            return o1.getNsURI().compareTo(o2.getNsURI());
        }
    });
    protected Set<EPackage> requiredPackages = new TreeSet<EPackage>(new Comparator<EPackage>(){

        @Override
        public int compare(EPackage o1, EPackage o2) {
            return o1.getNsURI().compareTo(o2.getNsURI());
        }
    });

    public PropagateImportsCommand(EditingDomain domain, CommandParameter commandParameter) {
        this.domain = domain;
        this.commandParameter = commandParameter;
    }

    protected boolean prepare() {
        for (Object clipboardObject : this.domain.getClipboard()) {
            if (!(clipboardObject instanceof EObject)) continue;
            this.checkElement((EObject)clipboardObject);
            TreeIterator iter = ((EObject)clipboardObject).eAllContents();
            while (iter.hasNext()) {
                this.checkElement((EObject)iter.next());
            }
        }
        this.module = this.getTransformationSystem(this.commandParameter.getOwner());
        if (this.module != null) {
            block2: for (EPackage reqPack : this.requiredPackages) {
                for (EPackage existingPack : this.module.getImports()) {
                    if (reqPack.getNsURI().equals(existingPack.getNsURI())) continue block2;
                }
                this.missingPackages.add(reqPack);
            }
        }
        return true;
    }

    private Module getTransformationSystem(Object owner) {
        if (owner instanceof EObject) {
            EObject eo = (EObject)owner;
            while (!(eo instanceof Module) && eo.eContainer() != null) {
                eo = eo.eContainer();
            }
            if (eo instanceof Module) {
                return (Module)eo;
            }
        }
        return null;
    }

    protected void checkElement(EObject containedEObject) {
        EAttribute type;
        if (containedEObject instanceof Node) {
            EClass type2 = ((Node)containedEObject).getType();
            if (type2 != null) {
                this.addRootIfPackage((EObject)type2);
            }
        } else if (containedEObject instanceof Edge) {
            EReference type3 = ((Edge)containedEObject).getType();
            if (type3 != null) {
                this.addRootIfPackage((EObject)type3);
            }
        } else if (containedEObject instanceof Attribute && (type = ((Attribute)containedEObject).getType()) != null) {
            this.addRootIfPackage((EObject)type);
        }
    }

    protected void addRootIfPackage(EObject eo) {
        EObject pack = this.getRootObject(eo);
        if (pack instanceof EPackage) {
            this.requiredPackages.add((EPackage)pack);
        }
    }

    protected EObject getRootObject(EObject pack) {
        EObject p = pack;
        while (p.eContainer() != null) {
            p = p.eContainer();
        }
        return p;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        if (this.module != null) {
            for (EPackage pack : this.missingPackages) {
                this.module.getImports().add((Object)pack);
            }
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        if (this.module != null) {
            for (EPackage pack : this.missingPackages) {
                this.module.getImports().remove((Object)pack);
            }
        }
    }
}

