/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis.colim;

import agg.xt_basis.colim.COLIM_DEFS;
import agg.xt_basis.colim.COLIM_VECTOR;
import agg.xt_basis.colim.INT_VECTOR;
import agg.xt_basis.colim.SET_DIAGRAM;
import java.util.Enumeration;

public class SIG_DIAGRAM
implements COLIM_DEFS {
    private SET_DIAGRAM f_sort_diagram = new SET_DIAGRAM();
    private SET_DIAGRAM f_op_diagram = new SET_DIAGRAM();
    private COLIM_VECTOR f_coprod_arity = new COLIM_VECTOR();
    private COLIM_VECTOR f_colimit_arity;
    private boolean f_colimit_valid;

    public SIG_DIAGRAM() {
        this.f_coprod_arity.push_back(null);
        this.f_colimit_valid = false;
    }

    public int insert_object(COLIM_VECTOR sorts, COLIM_VECTOR ops, COLIM_VECTOR arity, String name) {
        int lower = this.f_sort_diagram.coproduct_size();
        int sort_node = this.f_sort_diagram.insert_object(sorts, name);
        int op_node = this.f_op_diagram.insert_object(ops, name);
        int i = 0;
        while (i < arity.size()) {
            INT_VECTOR arity_sorts = (INT_VECTOR)arity.item(i);
            INT_VECTOR cop_sorts = new INT_VECTOR(arity_sorts.size());
            int arity_sort = 0;
            while (arity_sort < arity_sorts.size()) {
                cop_sorts.push_back(arity_sorts.item(arity_sort) + lower);
                ++arity_sort;
            }
            this.f_coprod_arity.push_back(cop_sorts);
            ++i;
        }
        this.f_colimit_valid = false;
        return sort_node;
    }

    public int insert_morphism(INT_VECTOR sort_morphism, INT_VECTOR op_morphism, int v, int w) {
        int sort_edge = this.f_sort_diagram.insert_morphism(sort_morphism, v, w);
        int op_edge = this.f_op_diagram.insert_morphism(op_morphism, v, w);
        this.f_colimit_valid = false;
        return sort_edge;
    }

    public COLIM_VECTOR get_colimit_sorts() {
        return this.f_sort_diagram.get_colimit_set();
    }

    public COLIM_VECTOR get_colimit_ops() {
        return this.f_op_diagram.get_colimit_set();
    }

    public COLIM_VECTOR get_colimit_arity() {
        if (!this.f_colimit_valid) {
            this.compute_colimit();
        }
        return this.f_colimit_arity;
    }

    INT_VECTOR get_arity(int operation) {
        return (INT_VECTOR)this.f_coprod_arity.item(operation);
    }

    SET_DIAGRAM get_sort_diagram() {
        return this.f_sort_diagram;
    }

    SET_DIAGRAM get_op_diagram() {
        return this.f_op_diagram;
    }

    public String toString() {
        StringBuffer Result2 = new StringBuffer("\nsort diagram:\n");
        Result2.append(this.f_sort_diagram.toString());
        Result2.append("\nop_diagram:\n");
        Result2.append(this.f_op_diagram.toString());
        Result2.append("\ncoproduct:\n");
        Result2.append(this.out_object(this.f_sort_diagram.get_coproduct_set(), this.f_op_diagram.get_coproduct_set(), this.f_coprod_arity));
        Result2.append("\n");
        return new String(Result2);
    }

    public String out_object(COLIM_VECTOR sorts, COLIM_VECTOR ops, COLIM_VECTOR arity) {
        StringBuffer Result2 = new StringBuffer("\nsorts: ");
        Enumeration en = sorts.elements();
        while (en.hasMoreElements()) {
            Object sort = en.nextElement();
            if (sort == null) continue;
            Result2.append(sort.toString());
            if (!en.hasMoreElements()) continue;
            Result2.append(",");
        }
        Result2.append("\noperations: ");
        Enumeration arity_en = arity.elements();
        Enumeration en2 = ops.elements();
        while (en2.hasMoreElements()) {
            Object op = en2.nextElement();
            INT_VECTOR arity_sorts = (INT_VECTOR)arity_en.nextElement();
            if (op == null) continue;
            Result2.append(this.out_operation(op, arity_sorts, sorts));
            if (!en2.hasMoreElements()) continue;
            Result2.append("; ");
        }
        return new String(Result2);
    }

    public String out_operation(Object op, INT_VECTOR arity_sorts, COLIM_VECTOR sorts) {
        StringBuffer Result2 = new StringBuffer("");
        Result2.append(op.toString());
        Result2.append(": ");
        if (arity_sorts.size() > 0) {
            int last = arity_sorts.item(0);
            int arity_sort = 1;
            while (arity_sort < arity_sorts.size()) {
                Result2.append(sorts.item(last).toString());
                last = arity_sorts.item(arity_sort);
                if (++arity_sort >= arity_sorts.size()) continue;
                Result2.append(",");
            }
            Result2.append("->");
            Result2.append(sorts.item(last).toString());
        }
        return new String(Result2);
    }

    private void compute_colimit() {
        INT_VECTOR colimit_sorts = this.f_sort_diagram.get_colimit_indices();
        INT_VECTOR colimit_ops = this.f_op_diagram.get_colimit_indices();
        this.f_colimit_arity = new COLIM_VECTOR(colimit_ops.size());
        int op = 0;
        while (op < colimit_ops.size()) {
            INT_VECTOR arity_sorts = (INT_VECTOR)this.f_coprod_arity.item(colimit_ops.item(op));
            INT_VECTOR colim_arity = new INT_VECTOR(arity_sorts.size());
            int sort = 0;
            while (sort < arity_sorts.size()) {
                colim_arity.push_back(this.f_sort_diagram.get_colimit_pos(arity_sorts.item(sort)));
                ++sort;
            }
            this.f_colimit_arity.push_back(colim_arity);
            ++op;
        }
        this.f_colimit_valid = true;
    }
}

