/*
 * Decompiled with CFR 0.152.
 */
package agg.util;

import agg.util.csp.BinaryPredicate;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Vector;

public class OrderedSet<E>
extends Vector<E>
implements SortedSet<E> {
    Comparator comp;
    BinaryPredicate predicate;
    Iterator<E> iter;
    E obj;

    public OrderedSet() {
    }

    public OrderedSet(Comparator comparator) {
        this();
        this.comp = comparator;
    }

    public OrderedSet(BinaryPredicate bp) {
        this();
        this.predicate = bp;
    }

    public OrderedSet(Collection<E> col) {
        this();
        Iterator<E> iter = col.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
    }

    public OrderedSet(Collection<E> col, Comparator comparator) {
        this(comparator);
        Iterator<E> iter = col.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
    }

    public OrderedSet(SortedSet<E> ss) {
        this.comp = ss.comparator();
        Iterator iter = ss.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
    }

    @Override
    public synchronized boolean add(E e) {
        boolean res = false;
        if (this.isEmpty()) {
            res = super.add(e);
        } else if (this.comp != null) {
            res = this.addByComparator(e);
        } else if (this.predicate != null) {
            res = this.addByPredicate(e);
        } else if (!super.contains(e)) {
            res = super.add(e);
        }
        return res;
    }

    @Override
    public boolean remove(Object o) {
        boolean res;
        block2: {
            int i1;
            int i;
            block5: {
                block4: {
                    block3: {
                        i = this.iter != null && this.obj != null ? this.indexOf(this.obj) : -1;
                        i1 = this.indexOf(o);
                        res = super.remove(o);
                        if (!res) break block2;
                        if (i != -1 || this.iter == null) break block3;
                        this.start();
                        break block2;
                    }
                    if (i != 0 || i1 != 0) break block4;
                    this.start();
                    break block2;
                }
                if (i <= 0) break block2;
                if (i < i1) break block5;
                this.start();
                int j = 0;
                while (j <= i - 1) {
                    this.get();
                    ++j;
                }
                break block2;
            }
            if (i >= i1) break block2;
            this.start();
            int j = 0;
            while (j <= i) {
                this.get();
                ++j;
            }
        }
        return res;
    }

    private boolean addByPredicate(E e) {
        int i = this.size() - 1;
        while (i >= 0) {
            if (this.predicate.execute(e, this.get(i))) {
                if (i == this.size() - 1) {
                    return super.add(e);
                }
                super.add(i + 1, e);
                return true;
            }
            if (i > 0 && this.predicate.execute(e, this.get(i - 1))) {
                super.add(i, e);
                return true;
            }
            if (i == 0) {
                super.add(i, e);
                return true;
            }
            --i;
        }
        return false;
    }

    private boolean addByComparator(E e) {
        int i = this.size() - 1;
        while (i >= 0) {
            int c = this.comp.compare(e, this.get(i));
            if (c == 0) {
                return false;
            }
            if (c > 0) {
                if (i == this.size() - 1) {
                    return super.add(e);
                }
                super.add(i + 1, e);
                return true;
            }
            if (i > 0 && this.comp.compare(e, this.get(i - 1)) > 0) {
                super.add(i, e);
                return true;
            }
            if (i == 0) {
                super.add(i, e);
                return true;
            }
            --i;
        }
        return false;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comp;
    }

    public BinaryPredicate binaryPredicate() {
        return this.predicate;
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        OrderedSet set = new OrderedSet();
        int start = this.indexOf(fromElement);
        int end = this.indexOf(toElement);
        int i = start;
        while (i <= end) {
            set.add(this.get(i));
            ++i;
        }
        set.comp = this.comp;
        set.predicate = this.predicate;
        return set;
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        OrderedSet set = new OrderedSet(this.comp);
        int end = this.indexOf(toElement);
        int i = 0;
        while (i <= end) {
            set.add(this.get(i));
            ++i;
        }
        set.comp = this.comp;
        set.predicate = this.predicate;
        return set;
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        int start;
        OrderedSet set = new OrderedSet();
        int i = start = this.indexOf(fromElement);
        while (i < this.size()) {
            set.add(this.get(i));
            ++i;
        }
        set.comp = this.comp;
        set.predicate = this.predicate;
        return set;
    }

    @Override
    public E first() {
        return !this.isEmpty() ? (E)this.firstElement() : null;
    }

    @Override
    public E last() {
        return !this.isEmpty() ? (E)this.lastElement() : null;
    }

    public void start() {
        this.iter = this.iterator();
        this.obj = null;
    }

    public E get() {
        this.obj = this.iter.hasNext() ? this.iter.next() : null;
        return this.obj;
    }

    public boolean hasNext() {
        if (this.iter == null) {
            this.start();
        }
        return this.iter.hasNext();
    }

    public OrderedSet<E> union(OrderedSet<E> os) {
        OrderedSet set = new OrderedSet();
        int i = 0;
        while (i < this.size()) {
            set.add(this.get(i));
            ++i;
        }
        i = 0;
        while (i < os.size()) {
            set.add(os.get(i));
            ++i;
        }
        set.comp = this.comp;
        set.predicate = this.predicate;
        return set;
    }
}

