/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.GraGra;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class LayerFunction
implements XMLObject {
    protected GraGra grammar;
    protected Hashtable<Rule, Integer> ruleLayer;
    protected Hashtable<Type, Integer> creationLayer;
    protected Hashtable<Type, Integer> deletionLayer;
    protected String errMsg;
    protected boolean valid;
    protected String option;

    public LayerFunction(GraGra gragra) {
        this.grammar = gragra;
        this.initRuleLayer(this.grammar);
        this.initCreationLayer(this.grammar);
        this.initDeletionLayer(this.grammar);
        this.valid = true;
        this.errMsg = "";
    }

    private void initRuleLayer(GraGra gragra) {
        this.ruleLayer = new Hashtable();
        int i = 0;
        while (i < gragra.getListOfRules().size()) {
            Rule rule = gragra.getListOfRules().get(i);
            this.ruleLayer.put(rule, new Integer(rule.getLayer()));
            ++i;
        }
    }

    private void initCreationLayer(GraGra gragra) {
        this.creationLayer = new Hashtable();
        Enumeration<Type> types = gragra.getTypes();
        while (types.hasMoreElements()) {
            Type type = types.nextElement();
            this.creationLayer.put(type, new Integer(0));
        }
    }

    private void initDeletionLayer(GraGra gragra) {
        this.deletionLayer = new Hashtable();
        Enumeration<Type> types = gragra.getTypes();
        while (types.hasMoreElements()) {
            Type type = types.nextElement();
            this.deletionLayer.put(type, new Integer(0));
        }
    }

    public boolean checkLayer() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    public String getErrorMessage() {
        return this.errMsg;
    }

    public Hashtable<Rule, Integer> getRuleLayer() {
        int size = 0;
        Iterator<Rule> en = this.grammar.getListOfRules().iterator();
        while (en.hasNext()) {
            en.next();
            ++size;
        }
        if (size != this.ruleLayer.size()) {
            this.initRuleLayer(this.grammar);
            return this.ruleLayer;
        }
        for (Rule key : this.grammar.getListOfRules()) {
            if (this.ruleLayer.containsKey(key)) continue;
            this.initRuleLayer(this.grammar);
            return this.ruleLayer;
        }
        return this.ruleLayer;
    }

    public Hashtable<Type, Integer> getCreationLayer() {
        int size = 0;
        Enumeration<Type> en = this.grammar.getTypes();
        while (en.hasMoreElements()) {
            en.nextElement();
            ++size;
        }
        if (size != this.creationLayer.size()) {
            this.initCreationLayer(this.grammar);
            return this.creationLayer;
        }
        en = this.grammar.getTypes();
        while (en.hasMoreElements()) {
            Type key = en.nextElement();
            if (this.creationLayer.containsKey(key)) continue;
            this.initCreationLayer(this.grammar);
            return this.creationLayer;
        }
        return this.creationLayer;
    }

    public Hashtable<Type, Integer> getDeletionLayer() {
        int size = 0;
        Enumeration<Type> en = this.grammar.getTypes();
        while (en.hasMoreElements()) {
            en.nextElement();
            ++size;
        }
        if (size != this.deletionLayer.size()) {
            this.initDeletionLayer(this.grammar);
            return this.deletionLayer;
        }
        en = this.grammar.getTypes();
        while (en.hasMoreElements()) {
            Type key = en.nextElement();
            if (this.deletionLayer.containsKey(key)) continue;
            this.initDeletionLayer(this.grammar);
            return this.deletionLayer;
        }
        return this.deletionLayer;
    }

    public Integer getStartLayer() {
        int startLayer = Integer.MAX_VALUE;
        Integer result = null;
        Enumeration<Rule> keys = this.getRuleLayer().keys();
        while (keys.hasMoreElements()) {
            Rule key = keys.nextElement();
            Integer layer = this.getRuleLayer().get(key);
            if (layer >= startLayer) continue;
            startLayer = layer;
            result = layer;
        }
        return result;
    }

    public Hashtable<Integer, HashSet> invertLayer(Hashtable<?, ?> layer) {
        Hashtable<Integer, HashSet> inverted = new Hashtable<Integer, HashSet>();
        Enumeration<?> keys = layer.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Integer value = (Integer)layer.get(key);
            HashSet invertedValue = inverted.get(value);
            if (invertedValue == null) {
                invertedValue = new HashSet();
                invertedValue.add(key);
                inverted.put(value, invertedValue);
                continue;
            }
            invertedValue.add(key);
        }
        return inverted;
    }

    public String getOption() {
        return this.option;
    }

    protected void writeHashtableToXML(Hashtable<?, ?> xmlObjects, XMLHelper h) {
        Enumeration<?> keys = xmlObjects.keys();
        while (keys.hasMoreElements()) {
            XMLObject r1 = (XMLObject)keys.nextElement();
            h.openSubTag("Datum");
            h.addObject("key", r1, false);
            h.addAttr("value", "" + xmlObjects.get(r1));
            h.close();
        }
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        h.openNewElem("LayerFunction", this);
        h.addObject("GraGra", this.grammar, false);
        h.close();
    }

    @Override
    public void XreadObject(XMLHelper h) {
        if (h.isTag("LayerFunction", this)) {
            this.grammar = (GraGra)h.getObject("GraGra", null, false);
            this.valid = true;
            this.option = "";
            this.initRuleLayer(this.grammar);
            this.initCreationLayer(this.grammar);
            this.initDeletionLayer(this.grammar);
            h.close();
        } else {
            this.option = "";
        }
    }

    public String toString() {
        String resultString = String.valueOf(super.toString()) + " LayerFunction:\n";
        resultString = String.valueOf(resultString) + "\tRuleLayer:\n";
        resultString = String.valueOf(resultString) + this.getRuleLayer().toString() + "\n";
        resultString = String.valueOf(resultString) + "\tCreationLayer:\n";
        resultString = String.valueOf(resultString) + this.getCreationLayer().toString() + "\n";
        resultString = String.valueOf(resultString) + "\tDeletionLayer:\n";
        resultString = String.valueOf(resultString) + this.getDeletionLayer().toString() + "\n";
        return resultString;
    }
}

