/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.editor.impl.EdGraph;
import agg.editor.impl.EdType;
import agg.parser.DependencyPairContainer;
import agg.parser.ExcludePairContainer;
import agg.parser.LayeredDependencyPairContainer;
import agg.parser.LayeredExcludePairContainer;
import agg.parser.PairContainer;
import agg.parser.ParserFactory;
import agg.parser.PriorityDependencyPairContainer;
import agg.parser.PriorityExcludePairContainer;
import agg.util.Pair;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;

public class ConflictsDependenciesContainer
implements XMLObject {
    protected ExcludePairContainer epc;
    protected DependencyPairContainer dpc;
    protected LayeredExcludePairContainer lepc;
    protected LayeredDependencyPairContainer ldpc;
    protected boolean layered;
    protected PriorityExcludePairContainer pepc;
    protected PriorityDependencyPairContainer pdpc;
    protected boolean priority;
    protected GraGra pairsGrammar;
    protected Graph cpaBasisGraph;
    protected EdGraph cpaGraph;
    protected int count;
    protected final List<Pair<String, String>> cpaOptions = new Vector<Pair<String, String>>();

    public ConflictsDependenciesContainer() {
        this.cpaBasisGraph = null;
        this.cpaGraph = null;
    }

    public ConflictsDependenciesContainer(PairContainer conflict, PairContainer dependency) {
        this.layered = false;
        this.priority = false;
        this.count = 0;
        if (dependency instanceof LayeredDependencyPairContainer) {
            this.ldpc = (LayeredDependencyPairContainer)dependency;
            ++this.count;
            this.layered = true;
            this.pairsGrammar = this.ldpc.getGrammar();
        } else if (dependency instanceof PriorityDependencyPairContainer) {
            this.pdpc = (PriorityDependencyPairContainer)dependency;
            ++this.count;
            this.priority = true;
            this.pairsGrammar = this.pdpc.getGrammar();
        } else if (dependency instanceof DependencyPairContainer) {
            this.dpc = (DependencyPairContainer)dependency;
            ++this.count;
            this.pairsGrammar = this.dpc.getGrammar();
        }
        this.layered = false;
        this.priority = false;
        if (conflict instanceof LayeredExcludePairContainer) {
            this.lepc = (LayeredExcludePairContainer)conflict;
            ++this.count;
            this.layered = true;
            this.pairsGrammar = this.lepc.getGrammar();
        } else if (conflict instanceof PriorityExcludePairContainer) {
            this.pepc = (PriorityExcludePairContainer)conflict;
            ++this.count;
            this.priority = true;
            this.pairsGrammar = this.pepc.getGrammar();
        } else if (conflict instanceof ExcludePairContainer) {
            this.epc = (ExcludePairContainer)conflict;
            ++this.count;
            this.pairsGrammar = this.epc.getGrammar();
        }
    }

    public ConflictsDependenciesContainer(PairContainer conflict, PairContainer dependency, Graph conflictDependencyGraph) {
        this(conflict, dependency);
        this.cpaBasisGraph = conflictDependencyGraph;
    }

    public ConflictsDependenciesContainer(PairContainer conflict, PairContainer dependency, EdGraph conflictDependencyGraph) {
        this(conflict, dependency);
        this.cpaGraph = conflictDependencyGraph;
        if (this.cpaGraph != null) {
            this.cpaBasisGraph = conflictDependencyGraph.getBasisGraph();
        }
    }

    public ExcludePairContainer getExcludePairContainer() {
        return this.epc;
    }

    public DependencyPairContainer getDependencyPairContainer() {
        return this.dpc;
    }

    public LayeredExcludePairContainer getLayeredExcludePairContainer() {
        return this.lepc;
    }

    public LayeredDependencyPairContainer getLayeredDependencyPairContainer() {
        return this.ldpc;
    }

    public PriorityExcludePairContainer getPriorityExcludePairContainer() {
        return this.pepc;
    }

    public PriorityDependencyPairContainer getPriorityDependencyPairContainer() {
        return this.pdpc;
    }

    public EdGraph getCPAGraph() {
        return this.cpaGraph;
    }

    public Graph getCPABasisGraph() {
        return this.cpaBasisGraph;
    }

    public boolean isPriority() {
        return this.priority;
    }

    public boolean isLayered() {
        return this.layered;
    }

    public GraGra getGrammar() {
        return this.pairsGrammar;
    }

    public int getContainerCount() {
        return this.count;
    }

    public List<Pair<String, String>> getLoadedCPAOptions() {
        return this.cpaOptions;
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        if (this.epc != null || this.dpc != null) {
            this.writeCriticalPairs(h, this.epc, this.dpc, false);
        } else if (this.lepc != null || this.ldpc != null) {
            this.writeCriticalPairs(h, this.lepc, this.ldpc, true);
        } else if (this.pepc != null || this.pdpc != null) {
            this.writeCriticalPairs(h, this.pepc, this.pdpc, true);
        } else {
            System.out.println("ConflictsDependenciesContainer.XwriteObject  FAILED");
        }
    }

    protected void writeCPAoptions(XMLHelper h, ExcludePairContainer pc) {
        h.openSubTag("cpaOptions");
        boolean val = pc.complete;
        h.addAttr("complete", Boolean.valueOf(val).toString());
        val = pc.consistent;
        h.addAttr("consistent", Boolean.valueOf(val).toString());
        val = pc.strongAttrCheck;
        h.addAttr("strongAttrCheck", Boolean.valueOf(val).toString());
        val = pc.reduceSameMatch;
        h.addAttr("ignoreSameMatch", Boolean.valueOf(val).toString());
        val = pc.ignoreIdenticalRules;
        h.addAttr("ignoreSameRule", Boolean.valueOf(val).toString());
        val = pc.reduce;
        h.addAttr("essential", Boolean.valueOf(val).toString());
        val = pc.directStrctCnfl;
        h.addAttr("directlyStrictConfluent", Boolean.valueOf(val).toString());
        val = pc.directStrctCnflUpToIso;
        h.addAttr("directlyStrictConfluentUpToIso", Boolean.valueOf(val).toString());
        val = pc.namedObjectOnly;
        h.addAttr("namedObject", Boolean.valueOf(val).toString());
        h.addAttr("maxBoundOfCriticCause", Integer.valueOf(pc.maxBoundOfCriticKind).toString());
        h.close();
    }

    protected List<Pair<String, String>> readCPAoptions(XMLHelper h) {
        Vector<Pair<String, String>> list = new Vector<Pair<String, String>>();
        if (h.readSubTag("cpaOptions")) {
            Pair<String, String> p = new Pair<String, String>("complete", h.readAttr("complete"));
            list.add(p);
            p = new Pair<String, String>("consistent", h.readAttr("consistent"));
            list.add(p);
            p = new Pair<String, String>("essential", h.readAttr("essential"));
            list.add(p);
            p = new Pair<String, String>("ignoreSameMatch", h.readAttr("ignoreSameMatch"));
            list.add(p);
            p = new Pair<String, String>("ignoreSameRule", h.readAttr("ignoreSameRule"));
            list.add(p);
            p = new Pair<String, String>("strongAttrCheck", h.readAttr("strongAttrCheck"));
            list.add(p);
            p = new Pair<String, String>("directlyStrictConfluent", h.readAttr("directlyStrictConfluent"));
            list.add(p);
            p = new Pair<String, String>("directlyStrictConfluentUpToIso", h.readAttr("directlyStrictConfluentUpToIso"));
            list.add(p);
            p = new Pair<String, String>("namedObject", h.readAttr("namedObject"));
            list.add(p);
            p = new Pair<String, String>("maxBoundOfCriticCause", h.readAttr("maxBoundOfCriticCause"));
            list.add(p);
            h.close();
        }
        return list;
    }

    protected boolean writeLayoutGrammar(XMLHelper h) {
        return true;
    }

    protected void readLayoutGrammar(XMLHelper h) {
    }

    protected boolean writeGrammar(XMLHelper h) {
        if (this.pairsGrammar != null) {
            h.addObject("GraGra", this.pairsGrammar, true);
            return true;
        }
        return false;
    }

    protected void readGrammar(XMLHelper h) {
        this.pairsGrammar = BaseFactory.theFactory().createGraGra();
        h.getObject("", this.pairsGrammar, true);
        this.pairsGrammar.prepareRuleInfo();
        if (this.pairsGrammar.isLayered()) {
            this.layered = true;
        } else if (this.pairsGrammar.trafoByPriority()) {
            this.priority = true;
        }
    }

    protected void writeRuleSet(XMLHelper h, String tagname, List<Rule> ruleSet) {
        h.openSubTag(tagname);
        h.addAttr("size", String.valueOf(ruleSet.size()));
        int i = 0;
        while (i < ruleSet.size()) {
            String ruleIDstr = h.getO2I(ruleSet.get(i));
            if (!ruleIDstr.equals("")) {
                h.addAttr("i".concat(String.valueOf(i)), ruleIDstr);
            }
            ++i;
        }
        h.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean readRuleSet(XMLHelper h, String tagname, List<Rule> ruleSet) {
        if (h.readSubTag(tagname)) {
            String sizeStr = h.readAttr("size");
            try {
                int size = Integer.valueOf(sizeStr);
                int i = 0;
                while (true) {
                    if (i >= size) {
                        h.close();
                        return true;
                    }
                    String ruleID = h.readAttr("i".concat(String.valueOf(i)));
                    Object obj = h.getI2O(ruleID);
                    if (!(obj instanceof Rule)) {
                        h.close();
                        return false;
                    }
                    ruleSet.add((Rule)obj);
                    ++i;
                }
            }
            catch (IllegalFormatException illegalFormatException) {
                h.close();
            }
        }
        return false;
    }

    protected void writeCriticalPairs(XMLHelper h, PairContainer pc1, PairContainer pc2, boolean layer) {
        Boolean b;
        h.openNewElem("CriticalPairs", this);
        if (!this.writeGrammar(h)) {
            System.out.println("ConflictsDependenciesContainer.XwriteObject(XMLHelper h) :: Cannot write critical pairs! Grammar is null.");
            return;
        }
        Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> excludeContainer = null;
        Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> conflictFreeContainer = null;
        ExcludePairContainer.Entry entry = null;
        boolean optionsWritten = false;
        if (pc1 != null) {
            Rule r2;
            Enumeration<Rule> k2;
            Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> secondPart;
            Rule r1;
            this.writeCPAoptions(h, (ExcludePairContainer)pc1);
            optionsWritten = true;
            excludeContainer = ((ExcludePairContainer)pc1).getExcludeContainer();
            h.openSubTag("conflictContainer");
            h.addAttr("kind", "exclude");
            this.writeRuleSet(h, "RuleSet", pc1.getRules());
            this.writeRuleSet(h, "RuleSet2", pc1.getRules2());
            Enumeration<Rule> keys = excludeContainer.keys();
            while (keys.hasMoreElements()) {
                r1 = keys.nextElement();
                h.openSubTag("Rule");
                h.addObject("R1", r1, false);
                secondPart = excludeContainer.get(r1);
                k2 = secondPart.keys();
                while (k2.hasMoreElements()) {
                    r2 = k2.nextElement();
                    entry = ((ExcludePairContainer)pc1).getEntry(r1, r2);
                    h.openSubTag("Rule");
                    h.addObject("R2", r2, false);
                    Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>> p = secondPart.get(r2);
                    b = (Boolean)p.first;
                    h.addAttr("bool", b.toString());
                    h.addAttr("duIndx", entry.duIndxStr);
                    h.addAttr("pfIndx", entry.pfIndxStr);
                    h.addAttr("caIndx", entry.caIndxStr);
                    if (b.booleanValue()) {
                        Vector v = (Vector)p.second;
                        int i = 0;
                        while (i < v.size()) {
                            Pair p2i = (Pair)v.elementAt(i);
                            Pair p2 = (Pair)p2i.first;
                            h.openSubTag("Overlapping_Pair");
                            OrdinaryMorphism first = (OrdinaryMorphism)p2.first;
                            Graph overlapping = first.getImage();
                            h.addObject("", overlapping, true);
                            for (GraphObject graphObject : overlapping.getNodesSet()) {
                                if (!graphObject.isCritical()) continue;
                                h.openSubTag("Critical");
                                h.addObject("object", graphObject, false);
                                h.close();
                            }
                            for (GraphObject graphObject : overlapping.getArcsSet()) {
                                if (!graphObject.isCritical()) continue;
                                h.openSubTag("Critical");
                                h.addObject("object", graphObject, false);
                                h.close();
                            }
                            this.writeOverlapMorphisms(h, r1, r2, p2i);
                            h.close();
                            ++i;
                        }
                    }
                    h.close();
                }
                h.close();
            }
            h.close();
            conflictFreeContainer = ((ExcludePairContainer)pc1).getConflictFreeContainer();
            if (conflictFreeContainer != null) {
                h.openSubTag("conflictFreeContainer");
                keys = excludeContainer.keys();
                while (keys.hasMoreElements()) {
                    r1 = keys.nextElement();
                    h.openSubTag("Rule");
                    h.addObject("R1", r1, false);
                    secondPart = conflictFreeContainer.get(r1);
                    k2 = secondPart.keys();
                    while (k2.hasMoreElements()) {
                        r2 = k2.nextElement();
                        entry = ((ExcludePairContainer)pc1).getEntry(r1, r2);
                        h.openSubTag("Rule");
                        h.addObject("R2", r2, false);
                        Boolean b2 = (Boolean)secondPart.get((Object)r2).first;
                        h.addAttr("bool", b2.toString());
                        if (entry.getStatus() == 7) {
                            h.addAttr("status", "not_computable");
                        }
                        h.close();
                    }
                    h.close();
                }
                h.close();
            }
        }
        excludeContainer = null;
        String kind = "trigger_dependency";
        if (pc2 != null) {
            Rule r2;
            Enumeration<Rule> k2;
            Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> secondPart;
            Rule r1;
            if (!optionsWritten) {
                this.writeCPAoptions(h, (ExcludePairContainer)pc2);
                optionsWritten = true;
            }
            excludeContainer = ((ExcludePairContainer)pc2).getExcludeContainer();
            if (((DependencyPairContainer)pc2).switchDependency) {
                kind = "trigger_switch_dependency";
            }
            h.openSubTag("dependencyContainer");
            h.addAttr("kind", kind);
            this.writeRuleSet(h, "RuleSet", pc2.getRules());
            this.writeRuleSet(h, "RuleSet2", pc2.getRules2());
            Enumeration<Rule> keys = excludeContainer.keys();
            while (keys.hasMoreElements()) {
                r1 = keys.nextElement();
                h.openSubTag("Rule");
                h.addObject("R1", r1, false);
                secondPart = excludeContainer.get(r1);
                k2 = secondPart.keys();
                while (k2.hasMoreElements()) {
                    r2 = k2.nextElement();
                    entry = ((ExcludePairContainer)pc2).getEntry(r1, r2);
                    h.openSubTag("Rule");
                    h.addObject("R2", r2, false);
                    Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>> p = secondPart.get(r2);
                    Boolean b3 = (Boolean)p.first;
                    h.addAttr("bool", b3.toString());
                    h.addAttr("duIndx", entry.duIndxStr);
                    h.addAttr("pfIndx", entry.pfIndxStr);
                    h.addAttr("caIndx", entry.caIndxStr);
                    if (b3.booleanValue()) {
                        Vector v = (Vector)p.second;
                        int i = 0;
                        while (i < v.size()) {
                            Pair p2i = (Pair)v.elementAt(i);
                            Pair p2 = (Pair)p2i.first;
                            h.openSubTag("Overlapping_Pair");
                            OrdinaryMorphism first = (OrdinaryMorphism)p2.first;
                            Graph overlapping = first.getImage();
                            h.addObject("", overlapping, true);
                            for (GraphObject graphObject : overlapping.getNodesSet()) {
                                if (!graphObject.isCritical()) continue;
                                h.openSubTag("Critical");
                                h.addObject("object", graphObject, false);
                                h.close();
                            }
                            for (GraphObject graphObject : overlapping.getArcsSet()) {
                                if (!graphObject.isCritical()) continue;
                                h.openSubTag("Critical");
                                h.addObject("object", graphObject, false);
                                h.close();
                            }
                            this.writeOverlapMorphisms(h, r1, r2, p2i);
                            h.close();
                            ++i;
                        }
                    }
                    h.close();
                }
                h.close();
            }
            h.close();
            conflictFreeContainer = ((ExcludePairContainer)pc2).getConflictFreeContainer();
            if (conflictFreeContainer != null) {
                h.openSubTag("dependencyFreeContainer");
                keys = excludeContainer.keys();
                while (keys.hasMoreElements()) {
                    r1 = keys.nextElement();
                    h.openSubTag("Rule");
                    h.addObject("R1", r1, false);
                    secondPart = conflictFreeContainer.get(r1);
                    k2 = secondPart.keys();
                    while (k2.hasMoreElements()) {
                        r2 = k2.nextElement();
                        entry = ((ExcludePairContainer)pc2).getEntry(r1, r2);
                        h.openSubTag("Rule");
                        h.addObject("R2", r2, false);
                        b = (Boolean)secondPart.get((Object)r2).first;
                        h.addAttr("bool", b.toString());
                        if (entry.getStatus() == 7) {
                            h.addAttr("status", "not_computable");
                        }
                        h.close();
                    }
                    h.close();
                }
                h.close();
            }
        }
        this.writeCPAGraph(h);
        h.close();
        this.writeLayoutGrammar(h);
    }

    protected void writeCPAGraph(XMLHelper h) {
        if (this.cpaBasisGraph != null) {
            h.openSubTag("ConflictDependencyGraph");
            h.openSubTag("Types");
            h.addEnumeration("", this.cpaBasisGraph.getTypeSet().getTypes(), true);
            h.close();
            h.addObject("", this.cpaBasisGraph, true);
            h.close();
        }
        if (this.cpaGraph != null) {
            h.addObject("Graph", this.cpaGraph, false);
        }
    }

    @Override
    public void XreadObject(XMLHelper h) {
        this.count = 0;
        this.cpaOptions.clear();
        if (h.isTag("CriticalPairs", this)) {
            ExcludePairContainer.Entry entry;
            String status;
            String bool;
            Enumeration<Element> r2s;
            Enumeration<Element> r1s;
            Rule r1 = null;
            Rule r2 = null;
            int conflictKind = 0;
            this.layered = false;
            this.priority = false;
            boolean b = false;
            boolean depsRead = false;
            Vector<String> tagnames = new Vector<String>(1);
            Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> allOverlappings = null;
            this.readGrammar(h);
            this.cpaOptions.addAll(this.readCPAoptions(h));
            Vector<Rule> tmpList = null;
            Vector<Rule> tmpList2 = null;
            tagnames.add("conflictContainer");
            tagnames.add("conflictsContainer");
            tagnames.add("excludeContainer");
            if (h.readSubTag(tagnames)) {
                String kind = h.readAttr("kind");
                conflictKind = 0;
                if (this.layered) {
                    this.lepc = (LayeredExcludePairContainer)ParserFactory.createEmptyCriticalPairs(this.pairsGrammar, 0, true);
                } else if (this.priority) {
                    this.pepc = (PriorityExcludePairContainer)ParserFactory.createEmptyCriticalPairs(this.pairsGrammar, 0, false);
                } else {
                    this.epc = (ExcludePairContainer)ParserFactory.createEmptyCriticalPairs(this.pairsGrammar, 0, false);
                }
                ++this.count;
            } else {
                tagnames.clear();
                tagnames.add("dependenciesContainer");
                tagnames.add("dependencyContainer");
                if (h.readSubTag(tagnames)) {
                    conflictKind = 1;
                    boolean switchDependency = false;
                    if (h.readAttr("kind").equals("trigger_switch_dependency")) {
                        switchDependency = true;
                        conflictKind = 2;
                    }
                    if (this.layered) {
                        this.ldpc = (LayeredDependencyPairContainer)ParserFactory.createEmptyCriticalPairs(this.pairsGrammar, conflictKind, true);
                        this.ldpc.switchDependency = switchDependency;
                    } else if (this.priority) {
                        this.pdpc = (PriorityDependencyPairContainer)ParserFactory.createEmptyCriticalPairs(this.pairsGrammar, conflictKind, false);
                        this.pdpc.switchDependency = switchDependency;
                    } else {
                        this.dpc = (DependencyPairContainer)ParserFactory.createEmptyCriticalPairs(this.pairsGrammar, conflictKind, false);
                        this.dpc.enableSwitchDependency(switchDependency);
                    }
                    ++this.count;
                }
            }
            if (conflictKind == 0 || conflictKind == 1 || conflictKind == 2) {
                tmpList = new Vector<Rule>();
                tmpList2 = new Vector<Rule>();
                if (!this.readRuleSet(h, "RuleSet", tmpList)) {
                    tmpList = null;
                }
                if (!this.readRuleSet(h, "RuleSet2", tmpList2)) {
                    tmpList2 = null;
                }
                if (!(r1s = h.getEnumeration("", null, true, "Rule")).hasMoreElements()) {
                    r1s = h.getEnumeration("", null, true, "Regel");
                }
                while (r1s.hasMoreElements()) {
                    h.peekElement(r1s.nextElement());
                    r1 = (Rule)h.getObject("R1", null, false);
                    if (r1 == null) continue;
                    r2s = h.getEnumeration("", null, true, "Rule");
                    if (!r2s.hasMoreElements()) {
                        r2s = h.getEnumeration("", null, true, "Regel");
                    }
                    while (r2s.hasMoreElements()) {
                        ExcludePairContainer.Entry entry2;
                        h.peekElement(r2s.nextElement());
                        r2 = (Rule)h.getObject("R2", null, false);
                        bool = h.readAttr("bool");
                        String duIndxStr = h.readAttr("duIndx");
                        String pfIndxStr = h.readAttr("pfIndx");
                        String caIndxStr = h.readAttr("caIndx");
                        b = false;
                        allOverlappings = null;
                        if (bool.equals("true")) {
                            b = true;
                            allOverlappings = new Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>();
                            Enumeration<Element> overlappings = h.getEnumeration("", null, true, "Overlapping_Pair");
                            while (overlappings.hasMoreElements()) {
                                Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> p;
                                h.peekElement(overlappings.nextElement());
                                Graph g = (Graph)h.getObject("", BaseFactory.theFactory().createGraph(this.pairsGrammar.getTypeSet()), true);
                                while (h.readSubTag("Critical")) {
                                    GraphObject o = (GraphObject)h.getObject("object", null, false);
                                    if (o != null) {
                                        o.setCritical(true);
                                    }
                                    h.close();
                                }
                                if (conflictKind == 0) {
                                    p = this.readOverlappingMorphisms(h, r1, r2, g, conflictKind);
                                    allOverlappings.addElement(p);
                                } else if (conflictKind == 1 || conflictKind == 2) {
                                    p = this.readOverlappingMorphisms(h, r1, r2, g, conflictKind);
                                    allOverlappings.addElement(p);
                                }
                                h.close();
                            }
                        }
                        if (conflictKind == 0) {
                            entry2 = null;
                            if (this.layered) {
                                this.lepc.addQuadruple(this.lepc.getExcludeContainer(), r1, r2, b, allOverlappings);
                                entry2 = this.lepc.getEntry(r1, r2, true);
                            } else if (this.priority) {
                                this.pepc.addQuadruple(this.pepc.getExcludeContainer(), r1, r2, b, allOverlappings);
                                entry2 = this.pepc.getEntry(r1, r2, true);
                            } else {
                                this.epc.addQuadruple(this.epc.getExcludeContainer(), r1, r2, b, allOverlappings);
                                entry2 = this.epc.getEntry(r1, r2, true);
                            }
                            if (entry2 != null) {
                                if (duIndxStr.indexOf(58) >= 0) {
                                    entry2.setIndexOfDelUseProgress(duIndxStr);
                                } else {
                                    entry2.setIndexOfDelUseProgress(duIndxStr.concat(":"));
                                }
                                if (pfIndxStr.indexOf(58) >= 0) {
                                    entry2.setIndexOfProdForbidProgress(pfIndxStr);
                                } else {
                                    entry2.setIndexOfProdForbidProgress(pfIndxStr.concat(":"));
                                }
                                if (caIndxStr.indexOf(58) >= 0) {
                                    entry2.setIndexOfChangeAttrProgress(caIndxStr);
                                } else {
                                    entry2.setIndexOfChangeAttrProgress(caIndxStr.concat(":"));
                                }
                            }
                        } else if (conflictKind == 1 || conflictKind == 2) {
                            entry2 = null;
                            if (this.layered) {
                                this.ldpc.addQuadruple(this.ldpc.getExcludeContainer(), r1, r2, b, allOverlappings);
                                entry2 = this.ldpc.getEntry(r1, r2, true);
                            } else if (this.priority) {
                                this.pdpc.addQuadruple(this.pdpc.getExcludeContainer(), r1, r2, b, allOverlappings);
                                entry2 = this.pdpc.getEntry(r1, r2, true);
                            } else {
                                this.dpc.addQuadruple(this.dpc.getExcludeContainer(), r1, r2, b, allOverlappings);
                                entry2 = this.dpc.getEntry(r1, r2, true);
                            }
                            if (entry2 != null) {
                                if (duIndxStr.indexOf(58) >= 0) {
                                    entry2.setIndexOfDelUseProgress(duIndxStr);
                                } else {
                                    entry2.setIndexOfDelUseProgress(duIndxStr.concat(":"));
                                }
                                if (pfIndxStr.indexOf(58) >= 0) {
                                    entry2.setIndexOfProdForbidProgress(pfIndxStr);
                                } else {
                                    entry2.setIndexOfProdForbidProgress(pfIndxStr.concat(":"));
                                }
                                if (caIndxStr.indexOf(58) >= 0) {
                                    entry2.setIndexOfChangeAttrProgress(caIndxStr);
                                } else {
                                    entry2.setIndexOfChangeAttrProgress(caIndxStr.concat(":"));
                                }
                            }
                        }
                        h.close();
                    }
                    h.close();
                }
                h.close();
            }
            tagnames.clear();
            tagnames.add("conflictFreeContainer");
            tagnames.add("dependencyFreeContainer");
            if (h.readSubTag(tagnames)) {
                r1s = h.getEnumeration("", null, true, "Rule");
                if (!r1s.hasMoreElements()) {
                    r1s = h.getEnumeration("", null, true, "Regel");
                }
                while (r1s.hasMoreElements()) {
                    h.peekElement(r1s.nextElement());
                    r1 = (Rule)h.getObject("R1", null, false);
                    r2s = h.getEnumeration("", null, true, "Rule");
                    if (!r2s.hasMoreElements()) {
                        r2s = h.getEnumeration("", null, true, "Regel");
                    }
                    while (r2s.hasMoreElements()) {
                        h.peekElement(r2s.nextElement());
                        r2 = (Rule)h.getObject("R2", null, false);
                        bool = h.readAttr("bool");
                        status = h.readAttr("status");
                        b = false;
                        if (bool.equals("true")) {
                            b = true;
                        }
                        if (conflictKind == 0) {
                            if (this.layered) {
                                this.lepc.addQuadruple(this.lepc.getConflictFreeContainer(), r1, r2, b, null);
                            } else if (this.priority) {
                                this.pepc.addQuadruple(this.pepc.getConflictFreeContainer(), r1, r2, b, null);
                            } else {
                                this.epc.addQuadruple(this.epc.getConflictFreeContainer(), r1, r2, b, null);
                            }
                        } else if (conflictKind == 1 || conflictKind == 2) {
                            entry = null;
                            if (this.layered) {
                                this.ldpc.addQuadruple(this.ldpc.getConflictFreeContainer(), r1, r2, b, null);
                                entry = this.ldpc.getEntry(r1, r2, true);
                            } else if (this.priority) {
                                this.pdpc.addQuadruple(this.pdpc.getConflictFreeContainer(), r1, r2, b, null);
                                entry = this.pdpc.getEntry(r1, r2, true);
                            } else {
                                this.dpc.addQuadruple(this.dpc.getConflictFreeContainer(), r1, r2, b, null);
                                entry = this.dpc.getEntry(r1, r2, true);
                            }
                            if (entry != null && status.equals(String.valueOf("not_computable"))) {
                                entry.setStatus(7);
                            }
                        }
                        if (!r1.isEnabled() || !r2.isEnabled()) {
                            if (conflictKind == 0) {
                                if (this.layered) {
                                    this.lepc.getEntry((Rule)r1, (Rule)r2).state = 5;
                                } else if (this.priority) {
                                    this.pepc.getEntry((Rule)r1, (Rule)r2).state = 5;
                                } else {
                                    this.epc.getEntry((Rule)r1, (Rule)r2).state = 5;
                                }
                            } else if (conflictKind == 1 || conflictKind == 2) {
                                if (this.layered) {
                                    this.ldpc.getEntry((Rule)r1, (Rule)r2).state = 5;
                                } else if (this.priority) {
                                    this.pdpc.getEntry((Rule)r1, (Rule)r2).state = 5;
                                } else {
                                    this.dpc.getEntry((Rule)r1, (Rule)r2).state = 5;
                                }
                            }
                        } else {
                            if (r1.getLayer() != r2.getLayer() && this.layered) {
                                if (conflictKind == 0) {
                                    this.lepc.getEntry((Rule)r1, (Rule)r2).state = 4;
                                } else if (conflictKind == 1 || conflictKind == 2) {
                                    this.ldpc.getEntry((Rule)r1, (Rule)r2).state = 4;
                                }
                            }
                            if (r1.getPriority() != r2.getPriority() && this.priority) {
                                if (conflictKind == 0) {
                                    this.pepc.getEntry((Rule)r1, (Rule)r2).state = 4;
                                } else if (conflictKind == 1 || conflictKind == 2) {
                                    this.pdpc.getEntry((Rule)r1, (Rule)r2).state = 4;
                                }
                            }
                        }
                        h.close();
                    }
                    h.close();
                }
                h.close();
            }
            tagnames.clear();
            tagnames.add("dependencyContainer");
            tagnames.add("dependenciesContainer");
            if (h.readSubTag(tagnames)) {
                if (!depsRead) {
                    Enumeration<Element> r1s2;
                    conflictKind = 1;
                    boolean switchDependency = false;
                    if (h.readAttr("kind").equals("trigger_switch_dependency")) {
                        switchDependency = true;
                        conflictKind = 2;
                    }
                    if (this.layered) {
                        this.ldpc = (LayeredDependencyPairContainer)ParserFactory.createEmptyCriticalPairs(this.pairsGrammar, conflictKind, true);
                    } else if (this.priority) {
                        this.pdpc = (PriorityDependencyPairContainer)ParserFactory.createEmptyCriticalPairs(this.pairsGrammar, conflictKind, false);
                    } else {
                        this.dpc = (DependencyPairContainer)ParserFactory.createEmptyCriticalPairs(this.pairsGrammar, conflictKind, false);
                    }
                    ++this.count;
                    tmpList = new Vector();
                    tmpList2 = new Vector();
                    if (!this.readRuleSet(h, "RuleSet", tmpList)) {
                        tmpList = null;
                    }
                    if (!this.readRuleSet(h, "RuleSet2", tmpList2)) {
                        tmpList2 = null;
                    }
                    if (!(r1s2 = h.getEnumeration("", null, true, "Rule")).hasMoreElements()) {
                        r1s2 = h.getEnumeration("", null, true, "Regel");
                    }
                    while (r1s2.hasMoreElements()) {
                        h.peekElement(r1s2.nextElement());
                        r1 = (Rule)h.getObject("R1", null, false);
                        Enumeration<Element> r2s2 = h.getEnumeration("", null, true, "Rule");
                        if (!r2s2.hasMoreElements()) {
                            r2s2 = h.getEnumeration("", null, true, "Regel");
                        }
                        while (r2s2.hasMoreElements()) {
                            h.peekElement(r2s2.nextElement());
                            r2 = (Rule)h.getObject("R2", null, false);
                            String bool2 = h.readAttr("bool");
                            b = false;
                            allOverlappings = null;
                            if (bool2.equals("true")) {
                                b = true;
                                allOverlappings = new Vector();
                                Enumeration<Element> overlappings = h.getEnumeration("", null, true, "Overlapping_Pair");
                                while (overlappings.hasMoreElements()) {
                                    h.peekElement(overlappings.nextElement());
                                    Graph g = (Graph)h.getObject("", new Graph(this.pairsGrammar.getTypeSet()), true);
                                    while (h.readSubTag("Critical")) {
                                        GraphObject o = (GraphObject)h.getObject("object", null, false);
                                        if (o != null) {
                                            o.setCritical(true);
                                        }
                                        h.close();
                                    }
                                    Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> p = this.readOverlappingMorphisms(h, r1, r2, g, conflictKind);
                                    allOverlappings.addElement(p);
                                    h.close();
                                }
                            }
                            if (this.layered) {
                                this.ldpc.addQuadruple(this.ldpc.getExcludeContainer(), r1, r2, b, allOverlappings);
                            } else if (this.priority) {
                                this.pdpc.addQuadruple(this.pdpc.getExcludeContainer(), r1, r2, b, allOverlappings);
                            } else {
                                this.dpc.addQuadruple(this.dpc.getExcludeContainer(), r1, r2, b, allOverlappings);
                            }
                            h.close();
                        }
                        h.close();
                    }
                }
                h.close();
                tagnames.clear();
                tagnames.add("conflictFreeContainer");
                tagnames.add("dependencyFreeContainer");
                if (h.readSubTag(tagnames)) {
                    if (!depsRead) {
                        Enumeration<Element> r1s1 = h.getEnumeration("", null, true, "Rule");
                        if (!r1s1.hasMoreElements()) {
                            r1s1 = h.getEnumeration("", null, true, "Regel");
                        }
                        while (r1s1.hasMoreElements()) {
                            h.peekElement(r1s1.nextElement());
                            r1 = (Rule)h.getObject("R1", null, false);
                            r2s = h.getEnumeration("", null, true, "Rule");
                            if (!r2s.hasMoreElements()) {
                                r2s = h.getEnumeration("", null, true, "Regel");
                            }
                            while (r2s.hasMoreElements()) {
                                h.peekElement(r2s.nextElement());
                                r2 = (Rule)h.getObject("R2", null, false);
                                bool = h.readAttr("bool");
                                status = h.readAttr("status");
                                b = false;
                                if (bool.equals("true")) {
                                    b = true;
                                }
                                entry = null;
                                if (this.layered) {
                                    this.ldpc.addQuadruple(this.ldpc.getConflictFreeContainer(), r1, r2, b, null);
                                    entry = this.ldpc.getEntry(r1, r2, true);
                                } else if (this.priority) {
                                    this.pdpc.addQuadruple(this.pdpc.getConflictFreeContainer(), r1, r2, b, null);
                                    entry = this.pdpc.getEntry(r1, r2, true);
                                } else {
                                    this.dpc.addQuadruple(this.dpc.getConflictFreeContainer(), r1, r2, b, null);
                                    entry = this.dpc.getEntry(r1, r2, true);
                                }
                                if (entry != null && status.equals("not_computable")) {
                                    entry.setStatus(7);
                                }
                                if (!r1.isEnabled() || !r2.isEnabled()) {
                                    if (this.layered) {
                                        this.ldpc.getEntry((Rule)r1, (Rule)r2).state = 5;
                                    } else if (this.priority) {
                                        this.pdpc.getEntry((Rule)r1, (Rule)r2).state = 5;
                                    } else {
                                        this.dpc.getEntry((Rule)r1, (Rule)r2).state = 5;
                                    }
                                } else {
                                    if (r1.getLayer() != r2.getLayer() && this.layered) {
                                        this.ldpc.getEntry((Rule)r1, (Rule)r2).state = 4;
                                    }
                                    if (r1.getPriority() != r2.getPriority() && this.priority) {
                                        this.pdpc.getEntry((Rule)r1, (Rule)r2).state = 4;
                                    }
                                }
                                h.close();
                            }
                            h.close();
                        }
                    }
                    h.close();
                }
            }
            this.readCPAGraph(h);
            if (this.layered) {
                if (this.lepc != null) {
                    this.lepc.resetRules(tmpList, tmpList2);
                }
                if (this.ldpc != null) {
                    this.ldpc.resetRules(tmpList, tmpList2);
                }
            } else if (this.priority) {
                if (this.pepc != null) {
                    this.pepc.resetRules(tmpList, tmpList2);
                }
                if (this.pdpc != null) {
                    this.pdpc.resetRules(tmpList, tmpList2);
                }
            } else {
                if (this.epc != null) {
                    this.epc.resetRules(tmpList, tmpList2);
                }
                if (this.dpc != null) {
                    this.dpc.resetRules(tmpList, tmpList2);
                }
            }
            this.pairsGrammar.isReadyToTransform(true);
            this.readLayoutGrammar(h);
        }
    }

    protected void readCPAGraph(XMLHelper h) {
        this.cpaBasisGraph = new Graph();
        if (h.readSubTag("ConflictDependencyGraph")) {
            if (h.readSubTag("Types")) {
                Type t;
                Enumeration<Element> en = h.getEnumeration("", null, true, "NodeType");
                while (en.hasMoreElements()) {
                    h.peekElement(en.nextElement());
                    t = this.cpaBasisGraph.getTypeSet().createNodeType(false);
                    h.loadObject(t);
                    h.close();
                    if (!t.getAdditionalRepr().equals("")) continue;
                    t.setAdditionalRepr("[NODE]");
                }
                en = h.getEnumeration("", null, true, "EdgeType");
                while (en.hasMoreElements()) {
                    h.peekElement(en.nextElement());
                    t = this.cpaBasisGraph.getTypeSet().createArcType(false);
                    h.loadObject(t);
                    h.close();
                    if (!t.getAdditionalRepr().equals("")) continue;
                    t.setAdditionalRepr("[EDGE]");
                }
                h.close();
            }
            h.getObject("", this.cpaBasisGraph, true);
            String gn = this.cpaBasisGraph.getName();
            if (gn.contains("ofRules")) {
                this.cpaBasisGraph.setName("CPA_RuleGraph:Conflicts_(red)-Dependencies_(blue)");
            }
            this.cpaGraph = new EdGraph(this.cpaBasisGraph);
            this.cpaGraph.setCPAgraph(true);
            h.enrichObject(this.cpaGraph);
            h.close();
            Vector<EdType> cpaEdgeTypes = this.cpaGraph.getTypeSet().getArcTypes();
            int i = 0;
            while (i < cpaEdgeTypes.size()) {
                EdType t = cpaEdgeTypes.get(i);
                if (t.getBasisType().getName().equals("c")) {
                    t.setColor(Color.RED);
                } else if (t.getBasisType().getName().equals("d")) {
                    t.setColor(Color.BLUE);
                }
                t.setAdditionalReprOfBasisType();
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void writeOverlapMorphisms(XMLHelper h, Rule r1, Rule r2, Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> overlapping) {
        Pair p1 = (Pair)overlapping.first;
        OrdinaryMorphism first = (OrdinaryMorphism)p1.first;
        h.openSubTag("Morphism");
        h.addAttr("name", first.getName());
        if (first.getTarget().getName().indexOf("deliver-delete-dependency") >= 0 && first.getSource() == r2.getLeft()) {
            h.addAttr("source", "LHS_R2");
        } else if (first.getTarget().getName().indexOf("forbid-produce-dependency") >= 0 && first.getSource() == r2.getRight()) {
            h.addAttr("source", "RHS_R2");
        } else if ((first.getTarget().getName().indexOf("change-change-dependency") >= 0 || first.getTarget().getName().indexOf("deliver-change-dependency") >= 0) && first.getSource() == r2.getLeft()) {
            h.addAttr("source", "LHS_R2");
        } else if (first.getTarget().getName().indexOf("-switch-") >= 0) {
            if (first.getSource() == r2.getLeft()) {
                h.addAttr("source", "LHS_R2");
            } else if (first.getSource() == r2.getRight()) {
                h.addAttr("source", "RHS_R2");
            }
        } else if (first.getTarget().getName().indexOf("produceEdge-deleteNode-") >= 0) {
            if (first.getSource() == r2.getLeft()) {
                h.addAttr("source", "LHS_R2_1");
            }
        } else if (first.getSource() == r1.getLeft()) {
            h.addAttr("source", "LHS");
        } else if (first.getSource() == r1.getRight()) {
            h.addAttr("source", "RHS");
        }
        Enumeration<GraphObject> e = first.getDomain();
        while (e.hasMoreElements()) {
            GraphObject s = e.nextElement();
            h.openSubTag("Mapping");
            h.addObject("orig", s, false);
            h.addObject("image", first.getImage(s), false);
            h.close();
        }
        h.close();
        OrdinaryMorphism second = (OrdinaryMorphism)p1.second;
        Pair p2 = (Pair)overlapping.second;
        if (p2 == null) {
            h.openSubTag("Morphism");
            h.addAttr("name", second.getName());
            if (second.getSource() == r2.getLeft()) {
                h.addAttr("source", "LHS");
            } else if (second.getSource() == r1.getRight()) {
                h.addAttr("source", "RHS_R1");
            } else if (second.getSource() == r1.getLeft()) {
                h.addAttr("source", "LHS_R1_2");
            }
            e = second.getDomain();
            while (e.hasMoreElements()) {
                GraphObject s = e.nextElement();
                h.openSubTag("Mapping");
                h.addObject("orig", s, false);
                h.addObject("image", second.getImage(s), false);
                h.close();
            }
            h.close();
        } else if (p2.second != null && ((OrdinaryMorphism)p2.first).getTarget() == ((OrdinaryMorphism)p2.second).getSource()) {
            OrdinaryMorphism embedPAC2 = ((OrdinaryMorphism)p2.first).compose((OrdinaryMorphism)p2.second);
            h.openSubTag("Morphism");
            h.addAttr("name", second.getName());
            if (second.getSource() == r2.getLeft()) {
                h.addAttr("source", "PAC+LHS");
            } else if (second.getSource() == r1.getRight()) {
                h.addAttr("source", "PAC+RHS_R1");
            }
            OrdinaryMorphism pac = this.getPAC(r2, embedPAC2.getSource());
            ArrayList<GraphObject> pacgos = new ArrayList<GraphObject>();
            for (GraphObject graphObject : second.getTarget().getNodesSet()) {
                if (!second.getInverseImage(graphObject).hasMoreElements()) {
                    if (!embedPAC2.getInverseImage(graphObject).hasMoreElements()) continue;
                    GraphObject graphObject2 = embedPAC2.getInverseImage(graphObject).nextElement();
                    pacgos.add(graphObject2);
                    continue;
                }
                GraphObject graphObject3 = second.getInverseImage(graphObject).nextElement();
                h.openSubTag("Mapping");
                h.addObject("orig", graphObject3, false);
                h.addObject("image", graphObject, false);
                h.close();
            }
            for (GraphObject graphObject : second.getTarget().getArcsSet()) {
                if (!second.getInverseImage(graphObject).hasMoreElements()) {
                    if (!embedPAC2.getInverseImage(graphObject).hasMoreElements()) continue;
                    GraphObject o = embedPAC2.getInverseImage(graphObject).nextElement();
                    pacgos.add(o);
                    continue;
                }
                GraphObject s = second.getInverseImage(graphObject).nextElement();
                h.openSubTag("Mapping");
                h.addObject("orig", s, false);
                h.addObject("image", graphObject, false);
                h.close();
            }
            for (GraphObject graphObject : pacgos) {
                GraphObject t = embedPAC2.getImage(graphObject);
                if (t == null) continue;
                h.openSubTag("Mapping");
                h.addAttr("pacname", pac.getName());
                h.addObject("orig", graphObject, false);
                h.addObject("image", t, false);
                h.close();
            }
            h.close();
        } else {
            OrdinaryMorphism morphL2iso = (OrdinaryMorphism)p2.first;
            OrdinaryMorphism morphNACiso = (OrdinaryMorphism)p2.second;
            h.openSubTag("Morphism");
            h.addAttr("name", second.getName());
            if (morphL2iso.getSource() == r1.getRight() || morphL2iso.getSource() == r2.getRight()) {
                h.addAttr("source", "NAC+RHS");
            } else {
                h.addAttr("source", "NAC+LHS");
            }
            e = second.getDomain();
            while (e.hasMoreElements()) {
                void var14_21;
                GraphObject src = e.nextElement();
                GraphObject t = second.getImage(src);
                Object var14_22 = null;
                if (morphL2iso.getInverseImage(src).hasMoreElements()) {
                    GraphObject graphObject = morphL2iso.getInverseImage(src).nextElement();
                } else if (morphNACiso.getInverseImage(src).hasMoreElements()) {
                    GraphObject graphObject = morphNACiso.getInverseImage(src).nextElement();
                }
                if (var14_21 == null) continue;
                h.openSubTag("Mapping");
                h.addObject("orig", (XMLObject)var14_21, false);
                h.addObject("image", t, false);
                h.close();
            }
            h.close();
        }
    }

    private OrdinaryMorphism getPAC(Rule r, Graph pacGraph) {
        List<OrdinaryMorphism> pacs = r.getPACsList();
        int l = 0;
        while (l < pacs.size()) {
            OrdinaryMorphism pac = pacs.get(l);
            if (pac.getTarget() == pacGraph) {
                return pac;
            }
            ++l;
        }
        return null;
    }

    protected Pair<OrdinaryMorphism, OrdinaryMorphism> readOldOverlappingMorphisms(XMLHelper h, Rule r1, Rule r2, String firstName, Graph overlapGraph, int kind) {
        OrdinaryMorphism first = null;
        OrdinaryMorphism second = null;
        if (kind == 0) {
            first = BaseFactory.theFactory().createMorphism(r1.getLeft(), overlapGraph);
            second = BaseFactory.theFactory().createMorphism(r2.getLeft(), overlapGraph);
        } else if (kind == 1 || kind == 2) {
            if (overlapGraph.getName().indexOf("-switch-") >= 0) {
                first = BaseFactory.theFactory().createMorphism(r2.getLeft(), overlapGraph);
                second = BaseFactory.theFactory().createMorphism(r1.getRight(), overlapGraph);
            } else {
                first = BaseFactory.theFactory().createMorphism(r1.getRight(), overlapGraph);
                second = BaseFactory.theFactory().createMorphism(r2.getLeft(), overlapGraph);
            }
        }
        if (first != null) {
            first.setName(firstName.replaceAll(" ", ""));
            while (h.readSubTag("Mapping")) {
                GraphObject o = (GraphObject)h.getObject("orig", null, false);
                GraphObject i = (GraphObject)h.getObject("image", null, false);
                if (o != null && i != null) {
                    try {
                        first.addMapping(o, i);
                    }
                    catch (BadMappingException badMappingException) {
                        // empty catch block
                    }
                }
                h.close();
            }
        }
        h.close();
        if (h.readSubTag("Morphism")) {
            if (second != null) {
                String name = h.readAttr("name");
                second.setName(name.replaceAll(" ", ""));
                while (h.readSubTag("Mapping")) {
                    GraphObject o = (GraphObject)h.getObject("orig", null, false);
                    GraphObject i = (GraphObject)h.getObject("image", null, false);
                    if (o != null && i != null) {
                        try {
                            second.addMapping(o, i);
                        }
                        catch (BadMappingException badMappingException) {
                            // empty catch block
                        }
                    }
                    h.close();
                }
            }
            h.close();
        }
        return new Pair<OrdinaryMorphism, OrdinaryMorphism>(first, second);
    }

    protected Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> readOverlappingMorphisms(XMLHelper h, Rule r1, Rule r2, Graph overlapGraph, int kind) {
        OrdinaryMorphism first = null;
        OrdinaryMorphism second = null;
        Pair<Pair<Object, Object>, Object> result = null;
        Pair<OrdinaryMorphism, OrdinaryMorphism> p = null;
        Pair<Object, Object> p1 = null;
        Pair<OrdinaryMorphism, Object> p2 = null;
        if (h.readSubTag("Morphism")) {
            String name = h.readAttr("name");
            String source = h.readAttr("source");
            if (source.equals("")) {
                p = this.readOldOverlappingMorphisms(h, r1, r2, name, overlapGraph, kind);
                return new Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Object>(p, null);
            }
            if (source.equals("LHS")) {
                first = BaseFactory.theFactory().createMorphism(r1.getLeft(), overlapGraph);
            } else if (source.equals("RHS")) {
                first = BaseFactory.theFactory().createMorphism(r1.getRight(), overlapGraph);
            } else if (source.equals("LHS_R2")) {
                first = BaseFactory.theFactory().createMorphism(r2.getLeft(), overlapGraph);
            } else if (source.equals("RHS_R2")) {
                first = BaseFactory.theFactory().createMorphism(r2.getRight(), overlapGraph);
            } else if (source.equals("LHS_R2_1")) {
                first = BaseFactory.theFactory().createMorphism(r2.getLeft(), overlapGraph);
            }
            if (first != null) {
                first.setName(name.replaceAll(" ", ""));
                while (h.readSubTag("Mapping")) {
                    GraphObject o = (GraphObject)h.getObject("orig", null, false);
                    GraphObject i = (GraphObject)h.getObject("image", null, false);
                    if (o != null && i != null) {
                        try {
                            first.addMapping(o, i);
                        }
                        catch (BadMappingException ex) {
                            System.out.println("ConflictDependencyContainer.readOverlappingMorphisms:: (second) " + ex.getLocalizedMessage());
                        }
                    }
                    h.close();
                }
            }
            h.close();
        }
        if (h.readSubTag("Morphism")) {
            Object n;
            OrdinaryMorphism nac;
            OrdinaryMorphism morphL2iso = null;
            OrdinaryMorphism morphNACiso = null;
            OrdinaryMorphism morphL2PACiso = null;
            OrdinaryMorphism embedPac = null;
            OrdinaryMorphism pac = null;
            Hashtable<GraphObject, Object> orig2copy = new Hashtable<GraphObject, Object>();
            String name = h.readAttr("name");
            String source = h.readAttr("source");
            if (source.equals("LHS")) {
                second = BaseFactory.theFactory().createMorphism(r2.getLeft(), overlapGraph);
            } else if (source.equals("RHS_R1")) {
                second = BaseFactory.theFactory().createMorphism(r1.getRight(), overlapGraph);
            } else if (source.equals("LHS_R1_2")) {
                second = BaseFactory.theFactory().createMorphism(r1.getLeft(), overlapGraph);
            } else if (source.equals("NAC+LHS")) {
                List<OrdinaryMorphism> nacs;
                nac = null;
                if (overlapGraph.getName().indexOf("forbid-switch-") >= 0 || overlapGraph.getName().indexOf("forbid-produce-dependency") >= 0) {
                    nacs = r1.getNACsList();
                    int i = 0;
                    while (i < nacs.size()) {
                        n = nacs.get(i);
                        if (overlapGraph.getHelpInfoAboutNAC().indexOf(((OrdinaryMorphism)n).getName()) != -1) {
                            nac = n;
                            break;
                        }
                        ++i;
                    }
                    Pair<OrdinaryMorphism, OrdinaryMorphism> NAC_RHS = BaseFactory.theFactory().extendRightGraphByNAC(r1, nac);
                    if (NAC_RHS != null) {
                        morphL2iso = (OrdinaryMorphism)NAC_RHS.first;
                        morphNACiso = (OrdinaryMorphism)NAC_RHS.second;
                    }
                } else {
                    nacs = r2.getNACsList();
                    int i = 0;
                    while (i < nacs.size()) {
                        n = nacs.get(i);
                        if (overlapGraph.getHelpInfoAboutNAC().indexOf(((OrdinaryMorphism)n).getName()) != -1) {
                            nac = n;
                            break;
                        }
                        ++i;
                    }
                    Pair<OrdinaryMorphism, OrdinaryMorphism> NAC_LHS = BaseFactory.theFactory().extendLeftGraphByNAC(r2, nac);
                    if (NAC_LHS != null) {
                        morphL2iso = (OrdinaryMorphism)NAC_LHS.first;
                        morphNACiso = (OrdinaryMorphism)NAC_LHS.second;
                    }
                }
                if (morphL2iso != null) {
                    Graph N2 = morphL2iso.getTarget();
                    second = BaseFactory.theFactory().createMorphism(N2, overlapGraph);
                }
            } else if (source.equals("NAC+RHS")) {
                OrdinaryMorphism n2;
                Enumeration<OrdinaryMorphism> e;
                nac = null;
                if (overlapGraph.getName().indexOf("forbid-switch-") >= 0 || overlapGraph.getName().indexOf("forbid-produce-dependency") >= 0) {
                    e = r1.getNACs();
                    while (e.hasMoreElements()) {
                        n2 = e.nextElement();
                        if (overlapGraph.getHelpInfoAboutNAC().indexOf(n2.getName()) == -1) continue;
                        nac = n2;
                        break;
                    }
                    Pair<OrdinaryMorphism, OrdinaryMorphism> NAC_RHS = BaseFactory.theFactory().extendRightGraphByNAC(r1, nac);
                    if (NAC_RHS != null) {
                        morphL2iso = (OrdinaryMorphism)NAC_RHS.first;
                        morphNACiso = (OrdinaryMorphism)NAC_RHS.second;
                    }
                } else {
                    e = r2.getNACs();
                    while (e.hasMoreElements()) {
                        n2 = e.nextElement();
                        if (overlapGraph.getHelpInfoAboutNAC().indexOf(n2.getName()) == -1) continue;
                        nac = n2;
                        break;
                    }
                    Pair<OrdinaryMorphism, OrdinaryMorphism> NAC_LHS = BaseFactory.theFactory().extendLeftGraphByNAC(r2, nac);
                    if (NAC_LHS != null) {
                        morphL2iso = (OrdinaryMorphism)NAC_LHS.first;
                        morphNACiso = (OrdinaryMorphism)NAC_LHS.second;
                    }
                }
                if (morphL2iso != null) {
                    Graph N2 = morphL2iso.getTarget();
                    second = BaseFactory.theFactory().createMorphism(N2, overlapGraph);
                }
            } else if (source.equals("PAC+LHS")) {
                List<OrdinaryMorphism> pacs = r2.getPACsList();
                int i = 0;
                while (i < pacs.size()) {
                    OrdinaryMorphism pa = pacs.get(i);
                    if (overlapGraph.getHelpInfoAboutPAC().equals(pa.getName())) {
                        pac = pa;
                        break;
                    }
                    ++i;
                }
                if (pac != null) {
                    morphL2iso = r2.getLeft().isoCopy();
                    morphL2PACiso = BaseFactory.theFactory().createMorphism(morphL2iso.getTarget(), overlapGraph);
                    embedPac = BaseFactory.theFactory().createMorphism(pac.getTarget(), morphL2PACiso.getSource());
                }
                second = BaseFactory.theFactory().createMorphism(r2.getLeft(), overlapGraph);
            } else if (source.equals("PAC+RHS_R1")) {
                morphL2iso = r1.getRight().isomorphicCopy();
                if (morphL2iso != null) {
                    morphL2PACiso = BaseFactory.theFactory().createMorphism(morphL2iso.getTarget(), overlapGraph);
                }
                second = BaseFactory.theFactory().createMorphism(r1.getRight(), overlapGraph);
            }
            if (second != null) {
                second.setName(name.replaceAll(" ", ""));
                while (h.readSubTag("Mapping")) {
                    block97: {
                        String pacname = h.readAttr("pacname");
                        GraphObject o = (GraphObject)h.getObject("orig", null, false);
                        GraphObject i = (GraphObject)h.getObject("image", null, false);
                        if (o != null && i != null) {
                            GraphObject s;
                            if (source.equals("LHS") || source.equals("RHS_R1") || source.equals("LHS_R1_2")) {
                                second.addMapping(o, i);
                            } else if (source.equals("NAC+LHS")) {
                                s = null;
                                if (morphL2iso != null) {
                                    s = morphL2iso.getImage(o);
                                }
                                if (s == null && morphNACiso != null) {
                                    s = morphNACiso.getImage(o);
                                }
                                if (s != null) {
                                    try {
                                        second.addMapping(s, i);
                                    }
                                    catch (BadMappingException ex) {
                                        System.out.println("ConflictDependencyContainer.readOverlappingMorphisms:: (second) " + ex.getLocalizedMessage());
                                    }
                                }
                            } else if (source.equals("NAC+RHS")) {
                                s = null;
                                if (morphL2iso != null) {
                                    s = morphL2iso.getImage(o);
                                }
                                if (s == null && morphNACiso != null) {
                                    s = morphNACiso.getImage(o);
                                }
                                if (s != null) {
                                    try {
                                        second.addMapping(s, i);
                                    }
                                    catch (BadMappingException ex) {
                                        System.out.println("ConflictDependencyContainer.readOverlappingMorphisms:: (second) " + ex.getLocalizedMessage());
                                    }
                                }
                            } else if (source.equals("PAC+LHS")) {
                                if (pacname == null || pacname.length() == 0) {
                                    try {
                                        second.addMapping(o, i);
                                    }
                                    catch (BadMappingException ex) {
                                        System.out.println("ConflictDependencyContainer.readOverlappingMorphisms:: (second) " + ex.getLocalizedMessage());
                                    }
                                    if (o.isNode() && morphL2iso != null) {
                                        orig2copy.put(o, morphL2iso.getImage(o));
                                    }
                                } else if (o.isNode() && morphL2iso != null) {
                                    try {
                                        n = morphL2iso.getTarget().copyNode((Node)o);
                                        try {
                                            if (morphL2PACiso != null) {
                                                morphL2PACiso.addMapping((GraphObject)n, i);
                                                orig2copy.put(o, n);
                                                embedPac.addMapping(o, (GraphObject)n);
                                            }
                                        }
                                        catch (BadMappingException ex) {
                                        }
                                    }
                                    catch (TypeException n3) {}
                                } else {
                                    try {
                                        Node src = (Node)orig2copy.get(((Arc)o).getSource());
                                        Node tar = (Node)orig2copy.get(((Arc)o).getTarget());
                                        if (src == null || tar == null || morphL2iso == null) break block97;
                                        Arc a = morphL2iso.getTarget().copyArc((Arc)o, src, tar);
                                        try {
                                            if (morphL2PACiso != null) {
                                                morphL2PACiso.addMapping(a, i);
                                                embedPac.addMapping(o, a);
                                            }
                                        }
                                        catch (BadMappingException badMappingException) {
                                        }
                                    }
                                    catch (TypeException src) {}
                                }
                            } else if (source.equals("PAC+RHS_R1") && (pacname == null || pacname.length() == 0)) {
                                try {
                                    second.addMapping(o, i);
                                }
                                catch (BadMappingException ex) {
                                    System.out.println("ConflictDependencyContainer.readOverlappingMorphisms:: (second) " + ex.getLocalizedMessage());
                                }
                            }
                        }
                    }
                    h.close();
                }
                if (source.equals("NAC+LHS") || source.equals("NAC+RHS")) {
                    p2 = new Pair<OrdinaryMorphism, Object>(morphL2iso, morphNACiso);
                } else if (source.equals("PAC+LHS")) {
                    embedPac.completeDiagram2(pac, morphL2iso);
                    p2 = new Pair<OrdinaryMorphism, OrdinaryMorphism>(embedPac, morphL2PACiso);
                } else if (source.equals("PAC+RHS_R1")) {
                    p2 = new Pair<OrdinaryMorphism, OrdinaryMorphism>(morphL2iso, morphL2PACiso);
                }
            }
            h.close();
        }
        if (first != null && second != null) {
            p1 = new Pair<Object, Object>(first, second);
            result = new Pair<Pair<Object, Object>, Object>(p1, p2);
        }
        return result;
    }
}

