/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.options;

import agg.editor.impl.EdRule;
import agg.gui.event.TransformEvent;
import agg.gui.options.AbstractOptionGUI;
import agg.gui.trafo.GraGraTransform;
import agg.gui.treeview.dialog.RuleSequenceDialog;
import agg.util.Pair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class GraTraOptionGUI
extends AbstractOptionGUI
implements ActionListener {
    protected JFrame applFrame;
    protected GraGraTransform transform;
    protected JCheckBox writeLogFileCB;
    protected JCheckBox showLayerCB;
    protected JCheckBox layeredLoopCB;
    protected JCheckBox resetGraphCB;
    protected JCheckBox stopLayerAndWaitCB;
    protected JCheckBox eachRuleToApplyCB;
    protected JRadioButton nondeterministicallyRB;
    protected JRadioButton priorityRB;
    protected JRadioButton ruleSequenceRB;
    protected JRadioButton layeredRB;
    protected JRadioButton breakLayerRB;
    protected JRadioButton breakAllLayerRB;
    protected JComboBox layers;
    protected JComboBox priorities;
    protected RuleSequenceDialog rsgui;
    protected boolean writeLogFile;
    protected boolean nondeterministically;
    protected boolean layered;
    protected boolean layeredLoop;
    protected boolean resetGraph;
    protected boolean showLayer;
    protected boolean stopLayerAndWait;
    protected boolean breakLayer;
    protected boolean breakAllLayer;
    protected boolean rulePriority;
    protected boolean ruleSequence;
    protected boolean eachRuleToApply;
    protected int layerToStop;
    protected int transformThreadpriority;
    protected JLabel breakLayerLabel;
    private final String[] priorityList = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};

    public GraTraOptionGUI(JFrame frame, GraGraTransform trans) {
        this.applFrame = frame;
        this.transform = trans;
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        JPanel transformKindPanel = new JPanel();
        transformKindPanel.setLayout(new GridLayout(0, 1));
        transformKindPanel.setBorder(new TitledBorder("  Graph transformation  "));
        ButtonGroup groupTrans = new ButtonGroup();
        this.nondeterministicallyRB = new JRadioButton("non-deterministically  ( NT ) ( by default )");
        groupTrans.add(this.nondeterministicallyRB);
        transformKindPanel.add(this.nondeterministicallyRB);
        this.nondeterministicallyRB.setActionCommand("nondeterministically");
        this.nondeterministically = true;
        this.nondeterministicallyRB.setSelected(true);
        this.nondeterministicallyRB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (GraTraOptionGUI.this.nondeterministicallyRB.isSelected()) {
                    if (GraTraOptionGUI.this.rsgui.isVisible()) {
                        GraTraOptionGUI.this.rsgui.setVisible(false);
                    }
                    GraTraOptionGUI.this.nondeterministically = true;
                    GraTraOptionGUI.this.rulePriority = false;
                    GraTraOptionGUI.this.layered = false;
                    GraTraOptionGUI.this.ruleSequence = false;
                    GraTraOptionGUI.this.eachRuleToApplyCB.setEnabled(GraTraOptionGUI.this.ruleSequence);
                    GraTraOptionGUI.this.transform.updateGraTraOption("layered", GraTraOptionGUI.this.layered);
                    GraTraOptionGUI.this.transform.updateGraTraOption("priority", GraTraOptionGUI.this.rulePriority);
                    GraTraOptionGUI.this.transform.updateGraTraOption("ruleSequence", GraTraOptionGUI.this.ruleSequence);
                } else {
                    GraTraOptionGUI.this.nondeterministically = false;
                }
                GraTraOptionGUI.this.transform.updateGraTraOption("nondeterministically", GraTraOptionGUI.this.nondeterministically);
            }
        });
        this.layeredRB = new JRadioButton("by rule layers  ( layered )   ( LT )");
        groupTrans.add(this.layeredRB);
        transformKindPanel.add(this.layeredRB);
        this.layeredRB.setActionCommand("layered");
        this.layered = false;
        this.layeredRB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (GraTraOptionGUI.this.layeredRB.isSelected()) {
                    if (GraTraOptionGUI.this.rsgui.isVisible()) {
                        GraTraOptionGUI.this.rsgui.setVisible(false);
                    }
                    GraTraOptionGUI.this.layered = true;
                    GraTraOptionGUI.this.rulePriority = false;
                    GraTraOptionGUI.this.nondeterministically = false;
                    GraTraOptionGUI.this.ruleSequence = false;
                    GraTraOptionGUI.this.eachRuleToApplyCB.setEnabled(GraTraOptionGUI.this.ruleSequence);
                    GraTraOptionGUI.this.layers.setEnabled(true);
                    GraTraOptionGUI.this.transform.updateGraTraOption("priority", GraTraOptionGUI.this.rulePriority);
                    GraTraOptionGUI.this.transform.updateGraTraOption("ruleSequence", GraTraOptionGUI.this.ruleSequence);
                    GraTraOptionGUI.this.transform.updateGraTraOption("nondeterministically", GraTraOptionGUI.this.nondeterministically);
                } else {
                    GraTraOptionGUI.this.layered = false;
                    GraTraOptionGUI.this.layers.setEnabled(false);
                }
                GraTraOptionGUI.this.transform.updateGraTraOption("layered", GraTraOptionGUI.this.layered);
                GraTraOptionGUI.this.showLayerCB.setEnabled(GraTraOptionGUI.this.layered);
                GraTraOptionGUI.this.layeredLoopCB.setEnabled(GraTraOptionGUI.this.layered);
                GraTraOptionGUI.this.stopLayerAndWaitCB.setEnabled(GraTraOptionGUI.this.layered);
                GraTraOptionGUI.this.breakLayerLabel.setEnabled(GraTraOptionGUI.this.layered);
                GraTraOptionGUI.this.breakLayerRB.setEnabled(GraTraOptionGUI.this.layered);
                GraTraOptionGUI.this.breakAllLayerRB.setEnabled(GraTraOptionGUI.this.layered);
            }
        });
        this.priorityRB = new JRadioButton("by rule priorities     ( PT )");
        groupTrans.add(this.priorityRB);
        transformKindPanel.add(this.priorityRB);
        this.priorityRB.setActionCommand("priority");
        this.rulePriority = false;
        this.priorityRB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (GraTraOptionGUI.this.priorityRB.isSelected()) {
                    if (GraTraOptionGUI.this.rsgui.isVisible()) {
                        GraTraOptionGUI.this.rsgui.setVisible(false);
                    }
                    GraTraOptionGUI.this.rulePriority = true;
                    GraTraOptionGUI.this.nondeterministically = false;
                    GraTraOptionGUI.this.layered = false;
                    GraTraOptionGUI.this.ruleSequence = false;
                    GraTraOptionGUI.this.eachRuleToApplyCB.setEnabled(GraTraOptionGUI.this.ruleSequence);
                    GraTraOptionGUI.this.transform.updateGraTraOption("layered", GraTraOptionGUI.this.layered);
                    GraTraOptionGUI.this.transform.updateGraTraOption("ruleSequence", GraTraOptionGUI.this.ruleSequence);
                    GraTraOptionGUI.this.transform.updateGraTraOption("nondeterministically", GraTraOptionGUI.this.nondeterministically);
                } else {
                    GraTraOptionGUI.this.rulePriority = false;
                }
                GraTraOptionGUI.this.transform.updateGraTraOption("priority", GraTraOptionGUI.this.rulePriority);
            }
        });
        this.ruleSequenceRB = new JRadioButton("by rule sequences  ( ST )");
        groupTrans.add(this.ruleSequenceRB);
        transformKindPanel.add(this.ruleSequenceRB);
        this.ruleSequenceRB.setActionCommand("ruleSequence");
        this.ruleSequence = false;
        this.ruleSequenceRB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (GraTraOptionGUI.this.ruleSequenceRB.isSelected()) {
                    GraTraOptionGUI.this.ruleSequence = true;
                    GraTraOptionGUI.this.eachRuleToApplyCB.setEnabled(GraTraOptionGUI.this.ruleSequence);
                    GraTraOptionGUI.this.layered = false;
                    GraTraOptionGUI.this.rulePriority = false;
                    GraTraOptionGUI.this.nondeterministically = false;
                    GraTraOptionGUI.this.transform.updateGraTraOption("priority", GraTraOptionGUI.this.rulePriority);
                    GraTraOptionGUI.this.transform.updateGraTraOption("layered", GraTraOptionGUI.this.layered);
                    GraTraOptionGUI.this.transform.updateGraTraOption("nondeterministically", GraTraOptionGUI.this.nondeterministically);
                } else {
                    GraTraOptionGUI.this.ruleSequence = false;
                }
                GraTraOptionGUI.this.transform.updateGraTraOption("ruleSequence", GraTraOptionGUI.this.ruleSequence);
            }
        });
        transformKindPanel.add(new JLabel("   ----------------------------------"));
        JPanel priorityPanel = new JPanel();
        priorityPanel.add((Component)new JLabel("Priority of transformation engine    "), "West");
        this.priorities = new JComboBox<String>(this.priorityList);
        this.priorities.setSelectedIndex(6);
        this.priorities.setToolTipText("Lower priority can be usful to improve synchronization of transformation engine and graph visualization.");
        this.priorities.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraTraOptionGUI.this.priorities.getSelectedItem() != null) {
                    String l = GraTraOptionGUI.this.priorities.getSelectedItem().toString();
                    GraTraOptionGUI.this.transformThreadpriority = Integer.valueOf(l);
                    GraTraOptionGUI.this.transform.setTransformationThreadPriority(GraTraOptionGUI.this.transformThreadpriority);
                }
            }
        });
        priorityPanel.add((Component)this.priorities, "East");
        transformKindPanel.add(priorityPanel);
        JPanel layerPanel = new JPanel(new GridLayout(0, 1));
        layerPanel.setBorder(new TitledBorder("  Options for layered rule application  "));
        this.showLayerCB = new JCheckBox("show layer before transform", null, false);
        layerPanel.add(this.showLayerCB);
        this.showLayerCB.setEnabled(this.layered);
        this.showLayerCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GraTraOptionGUI.this.showLayer = GraTraOptionGUI.this.showLayerCB.isSelected();
            }
        });
        JPanel lp = new JPanel(new BorderLayout());
        this.layeredLoopCB = new JCheckBox("loop over layers        ", null, false);
        this.layeredLoopCB.setEnabled(this.layered);
        this.layeredLoopCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GraTraOptionGUI.this.layeredLoop = GraTraOptionGUI.this.layeredLoopCB.isSelected();
                GraTraOptionGUI.this.resetGraphCB.setEnabled(GraTraOptionGUI.this.layeredLoop);
                GraTraOptionGUI.this.transform.updateGraTraOption("layeredLoop", GraTraOptionGUI.this.layeredLoop);
            }
        });
        this.resetGraphCB = new JCheckBox("reset graph before loop", null, false);
        this.resetGraphCB.setEnabled(this.layeredLoop);
        this.resetGraphCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GraTraOptionGUI.this.resetGraph = GraTraOptionGUI.this.resetGraphCB.isSelected();
                GraTraOptionGUI.this.transform.updateGraTraOption("resetGraph", GraTraOptionGUI.this.resetGraph);
            }
        });
        lp.add((Component)this.layeredLoopCB, "West");
        lp.add((Component)this.resetGraphCB, "Center");
        layerPanel.add(lp);
        JPanel p = new JPanel(new BorderLayout());
        this.stopLayerAndWaitCB = new JCheckBox("stop layer and wait    ", null, false);
        this.stopLayerAndWaitCB.setEnabled(this.layered);
        this.stopLayerAndWaitCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GraTraOptionGUI.this.stopLayerAndWait = GraTraOptionGUI.this.stopLayerAndWaitCB.isSelected();
                GraTraOptionGUI.this.transform.updateGraTraOption("stopLayerAndWait", GraTraOptionGUI.this.stopLayerAndWait);
            }
        });
        this.layers = new JComboBox();
        this.layers.addItem("current");
        this.layers.setEnabled(this.layered);
        this.layers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraTraOptionGUI.this.layers.getSelectedItem() != null) {
                    String l = GraTraOptionGUI.this.layers.getSelectedItem().toString();
                    if (l.equals("current")) {
                        l = "-1";
                    }
                    GraTraOptionGUI.this.layerToStop = Integer.valueOf(l);
                }
            }
        });
        p.add((Component)this.stopLayerAndWaitCB, "West");
        p.add((Component)this.layers, "Center");
        layerPanel.add(p);
        JLabel label = new JLabel("   ----------------------------------");
        layerPanel.add(label);
        this.breakLayerLabel = new JLabel("   when Stop transformation button pressed");
        layerPanel.add(this.breakLayerLabel);
        this.breakLayerLabel.setEnabled(this.layered);
        ButtonGroup breakLayerGroup = new ButtonGroup();
        this.breakLayerRB = new JRadioButton("break transformation on current layer");
        breakLayerGroup.add(this.breakLayerRB);
        layerPanel.add(this.breakLayerRB);
        this.breakLayerRB.setEnabled(this.layered);
        this.breakLayerRB.setActionCommand("breakLayer");
        this.breakLayer = false;
        this.breakLayerRB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (GraTraOptionGUI.this.breakLayerRB.isSelected()) {
                    GraTraOptionGUI.this.breakLayer = true;
                    GraTraOptionGUI.this.transform.updateGraTraOption("breakLayer", GraTraOptionGUI.this.breakLayer);
                    GraTraOptionGUI.this.breakAllLayer = false;
                    GraTraOptionGUI.this.transform.updateGraTraOption("breakAllLayer", GraTraOptionGUI.this.breakAllLayer);
                }
            }
        });
        this.breakAllLayerRB = new JRadioButton("break layered transformation");
        breakLayerGroup.add(this.breakAllLayerRB);
        layerPanel.add(this.breakAllLayerRB);
        this.breakAllLayerRB.setEnabled(this.layered);
        this.breakAllLayerRB.setSelected(true);
        this.breakAllLayer = true;
        this.transform.updateGraTraOption("breakAllLayer", this.breakAllLayer);
        this.breakAllLayerRB.setActionCommand("breakAllLayer");
        this.breakAllLayerRB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (GraTraOptionGUI.this.breakAllLayerRB.isSelected()) {
                    GraTraOptionGUI.this.breakAllLayer = true;
                    GraTraOptionGUI.this.transform.updateGraTraOption("breakAllLayer", GraTraOptionGUI.this.breakAllLayer);
                    GraTraOptionGUI.this.breakLayer = false;
                    GraTraOptionGUI.this.transform.updateGraTraOption("breakLayer", GraTraOptionGUI.this.breakLayer);
                }
            }
        });
        this.rsgui = new RuleSequenceDialog(this.applFrame, new Point(200, 100));
        JPanel ruleSequencePanel = new JPanel(new GridLayout(0, 1));
        ruleSequencePanel.setBorder(new TitledBorder("  Options for rule sequences  "));
        this.eachRuleToApplyCB = new JCheckBox("each rule applied at least ones", null, false);
        ruleSequencePanel.add(this.eachRuleToApplyCB);
        this.eachRuleToApplyCB.setEnabled(this.ruleSequence);
        this.eachRuleToApplyCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GraTraOptionGUI.this.eachRuleToApply = GraTraOptionGUI.this.eachRuleToApplyCB.isSelected();
                GraTraOptionGUI.this.transform.setEachRuleToApplyOfRuleSequence(GraTraOptionGUI.this.eachRuleToApply);
                GraTraOptionGUI.this.transform.updateGraTraOption("eachRuleToApply", GraTraOptionGUI.this.eachRuleToApply);
            }
        });
        JPanel transformPanel = new JPanel(new GridBagLayout());
        this.constrainBuild(transformPanel, transformKindPanel, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 20, 5);
        this.constrainBuild(transformPanel, layerPanel, 0, 1, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 10, 5);
        this.constrainBuild(transformPanel, ruleSequencePanel, 0, 2, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 10, 5);
        this.constrainBuild(this, transformPanel, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 10, 5, 50, 5);
        this.validate();
    }

    public void updateLayerToStopIfNeeded() {
        if (this.transform.getEditor().getGraGra() != null) {
            if (this.transform.getEditor().getGraGra().getBasisGraGra().hasRuleChangedEvailability()) {
                if (this.layers.getItemCount() - 1 != this.transform.getEditor().getGraGra().getBasisGraGra().getEnabledLayers().size()) {
                    this.initLayers(this.transform.getEditor().getGraGra().getBasisGraGra().getEnabledLayers());
                }
            } else if (this.layers.getItemCount() == 1) {
                this.initLayers(this.transform.getEditor().getGraGra().getBasisGraGra().getEnabledLayers());
            }
        }
    }

    public void initLayers(Vector<String> v) {
        this.layers.removeAllItems();
        this.layers.addItem("current");
        int i = 0;
        while (i < v.size()) {
            this.layers.addItem(v.get(i));
            ++i;
        }
        this.layerToStop = -1;
    }

    public int getLayerToStop() {
        return this.layerToStop;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 490);
    }

    @Override
    public String getTabTitle() {
        return "Transformation";
    }

    @Override
    public String getTabTip() {
        return "Transformation Options";
    }

    public void addActionListener(ActionListener l) {
        this.nondeterministicallyRB.addActionListener(l);
        this.layeredRB.addActionListener(l);
        this.priorityRB.addActionListener(l);
        this.ruleSequenceRB.addActionListener(l);
    }

    public void addActionListener(String option, ActionListener l) {
        if (option.equals("nondeterministically")) {
            this.nondeterministicallyRB.addActionListener(l);
        } else if (option.equals("layered")) {
            this.layeredRB.addActionListener(l);
        } else if (option.equals("priority")) {
            this.priorityRB.addActionListener(l);
        } else if (option.equals("ruleSequence")) {
            this.ruleSequenceRB.addActionListener(l);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JCheckBox && ((JCheckBox)source).getText().equals("layered")) {
            if (((JCheckBox)source).isSelected()) {
                this.layeredRB.doClick();
            } else {
                this.nondeterministicallyRB.doClick();
            }
        }
    }

    @Override
    public void update() {
        this.update(this.transform.getGraTraOptionsList());
    }

    public void update(Vector<String> optionNames) {
        if (optionNames.isEmpty()) {
            return;
        }
        if (optionNames.contains("priority")) {
            if (!this.priorityRB.isSelected()) {
                this.priorityRB.doClick();
            }
            this.rulePriority = true;
        } else if (optionNames.contains("ruleSequence")) {
            if (!this.ruleSequenceRB.isSelected()) {
                this.ruleSequenceRB.doClick();
            }
            this.ruleSequence = true;
        } else if (optionNames.contains("layered")) {
            if (!this.layeredRB.isSelected()) {
                this.layeredRB.doClick();
            }
            this.layered = true;
            this.updateLayerToStopIfNeeded();
            if (optionNames.contains("stopLayerAndWait")) {
                this.stopLayerAndWaitCB.setSelected(true);
                this.stopLayerAndWait = true;
            } else {
                this.stopLayerAndWaitCB.setSelected(false);
                this.stopLayerAndWait = false;
            }
            if (optionNames.contains("layeredLoop")) {
                this.layeredLoopCB.setSelected(true);
                this.layeredLoop = true;
            } else {
                this.layeredLoopCB.setSelected(false);
                this.layeredLoop = false;
            }
        } else {
            if (!this.nondeterministicallyRB.isSelected()) {
                this.nondeterministicallyRB.doClick();
            }
            this.nondeterministically = true;
        }
        if (optionNames.contains("resetGraph")) {
            this.resetGraphCB.setSelected(true);
            this.resetGraph = true;
        } else {
            this.resetGraphCB.setSelected(false);
            this.resetGraph = false;
        }
        if (optionNames.contains("breakLayer")) {
            this.breakLayerRB.setSelected(true);
            this.breakLayer = true;
            this.breakAllLayerRB.setSelected(false);
            this.breakAllLayer = false;
        } else if (optionNames.contains("breakAllLayer")) {
            this.breakAllLayerRB.setSelected(true);
            this.breakAllLayer = true;
            this.breakLayerRB.setSelected(false);
            this.breakLayer = false;
        } else {
            this.breakAllLayerRB.setSelected(true);
            this.breakAllLayer = true;
        }
        if (optionNames.contains("eachRuleToApply")) {
            this.eachRuleToApplyCB.setSelected(true);
            this.eachRuleToApply = true;
        } else {
            this.eachRuleToApplyCB.setSelected(false);
            this.eachRuleToApply = false;
        }
    }

    public void doClick(String button) {
        if (button.equals("nondeterministically")) {
            this.nondeterministicallyRB.doClick();
        } else if (button.equals("layered")) {
            this.layeredRB.doClick();
        } else if (button.equals("priority")) {
            this.priorityRB.doClick();
        } else if (button.equals("ruleSequence")) {
            this.ruleSequenceRB.doClick();
        }
    }

    public boolean nondeterministicallyEnabled() {
        return this.nondeterministically;
    }

    public boolean priorityEnabled() {
        return this.rulePriority;
    }

    public boolean ruleSequenceEnabled() {
        return this.ruleSequence;
    }

    public boolean layeredEnabled() {
        return this.layered;
    }

    public boolean showLayerEnabled() {
        return this.showLayer;
    }

    public boolean layeredLoopEnabled() {
        return this.layeredLoop;
    }

    public boolean resetGraphEnabled() {
        return this.resetGraph;
    }

    public boolean stopLayerAndWaitEnabled() {
        return this.stopLayerAndWait;
    }

    public boolean breakLayerEnabled() {
        return this.breakLayer;
    }

    public boolean breakAllLayerEnabled() {
        return this.breakAllLayer;
    }

    public void setRulesOfRuleSequenceGUI(List<EdRule> rules) {
        this.rsgui.setGraGra(this.transform.getGraGra());
        this.rsgui.updateRules(rules);
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }

    public void enableRuleSequenceGUI(boolean b) {
        this.rsgui.enableGUI(b);
    }

    public void showRuleSequenceGUI(String ruleSequenceName) {
        if (!ruleSequenceName.equals("")) {
            this.rsgui.extendTitle(ruleSequenceName);
        }
        if (!this.rsgui.isVisible()) {
            this.rsgui.setVisible(true);
        }
        if (!this.rsgui.isGUIEnabled()) {
            this.rsgui.enableGUI(true);
        }
        this.rsgui.toFront();
        this.transform.fireTransform(new TransformEvent(this, 24));
    }

    public void closeRuleSequenceGUI() {
        if (this.rsgui.isVisible()) {
            this.rsgui.closeObjectFlow();
            this.rsgui.setVisible(false);
        }
    }

    public boolean eachRuleToApplyEnabled() {
        return this.eachRuleToApply;
    }

    public void setRuleSequences(List<Pair<List<Pair<String, String>>, String>> sequences) {
        this.rsgui.updateRuleSequences(sequences);
    }

    public List<Pair<List<Pair<String, String>>, String>> getRuleSequences() {
        if (this.ruleSequence) {
            return this.rsgui.getRuleSequences();
        }
        return null;
    }

    public String getRuleSequencesAsText() {
        if (this.ruleSequence) {
            return this.rsgui.getRuleSequencesText();
        }
        return null;
    }

    @Override
    public void executeOnClose() {
    }
}

