/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.cpa;

import agg.gui.parser.event.CPAEventData;
import agg.gui.parser.event.ParserGUIEvent;
import agg.gui.parser.event.ParserGUIListener;
import agg.parser.CriticalPairData;
import agg.parser.CriticalPairEvent;
import agg.parser.DependencyPairContainer;
import agg.parser.ExcludePairContainer;
import agg.parser.ParserEvent;
import agg.parser.ParserEventListener;
import agg.util.Pair;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class CriticalPairPanel
extends JPanel
implements ActionListener,
ParserEventListener,
ItemListener,
PopupMenuListener {
    static final Font bfont = new Font("Helvetica-Bold", 1, 14);
    static final Color NOT_SET = Color.white;
    static final Color SCHEDULED = Color.gray;
    static final Color COMPUTING = new Color(255, 255, 160);
    static final Color CRITIC = new Color(255, 204, 204);
    static final Color DEPEND = new Color(204, 204, 255);
    static final Color DEPEND2 = Color.cyan;
    static final Color NOT_CRITIC = new Color(201, 255, 204);
    static final Color DISABLED = Color.lightGray;
    static final Color NOT_RELATED = Color.lightGray;
    private ExcludePairContainer container;
    private Hashtable<JButton, CriticalPairData> b2cpData = new Hashtable();
    private Hashtable<Rule, Hashtable<Rule, JButton>> buttons = new Hashtable();
    private Hashtable<JButton, Rule> firstRules = new Hashtable();
    private Hashtable<JButton, Rule> secondRules = new Hashtable();
    private Vector<ParserGUIListener> listeners = new Vector();
    private Rule first;
    private Rule second;
    private int tableW;
    private int tableH;
    private final JPopupMenu menu = new JPopupMenu();
    private JMenuItem miClear;
    private JMenuItem miContinue;
    private JMenuItem miComputeAndCheck;
    private JMenuItem miVisibleRel;
    private JMenuItem miVisibleRule;
    private static final String clearRelation = "Clear";
    private static final String continueCompute = "Continue Compute";
    private static final String computeAndCheck = "Compute & Check Host Graph";
    private static final String hideRelation = "Hide Relation ( in CPA Graph )";
    private static final String showRelation = "Show Relation ( in CPA Graph )";
    private static final String hideRule = "Hide Rule ( in CPA Graph )";
    private static final String showRule = "Show Rule ( in CPA Graph )";
    private static final Border border = new JButton().getBorder();
    int borderWidth = 7;
    private final JScrollPane main = new JScrollPane();
    MouseInputAdapter ml;
    boolean active;

    public CriticalPairPanel(List<Rule> rules, ExcludePairContainer container) {
        super(new BorderLayout(), true);
        this.makePanel(rules, rules, container);
    }

    public CriticalPairPanel(List<Rule> rules1, List<Rule> rules2, ExcludePairContainer container) {
        super(new BorderLayout(), true);
        this.makePanel(rules1, rules2, container);
    }

    private void makePanel(List<Rule> somerules1, List<Rule> somerules2, ExcludePairContainer cpContainer) {
        if (somerules1 == null || somerules1.size() == 0 || somerules2 == null || somerules2.size() == 0) {
            return;
        }
        this.container = cpContainer;
        this.container.addPairEventListener(this);
        List<Rule> rules = this.getEnabledRules(somerules1);
        List<Rule> rules2 = somerules1 == somerules2 ? rules : this.getEnabledRules(somerules2);
        int tablesize2 = rules2.size();
        JPanel rowHead = new JPanel();
        rowHead.setLayout(new GridLayout(tablesize2, 1));
        int nn = 0;
        int i = 0;
        while (i < rules2.size()) {
            Rule r = rules2.get(i);
            if (r.isEnabled()) {
                String rName = r.getQualifiedName();
                String text = String.valueOf(String.valueOf(++nn)) + " " + rName;
                JLabel act = new JLabel(text);
                act.setToolTipText("first rule " + text);
                rowHead.add(act);
            }
            ++i;
        }
        int tablesize = rules.size();
        JPanel colHead = new JPanel();
        colHead.setLayout(new GridLayout(1, tablesize));
        nn = 0;
        boolean sameRules = rules.equals(rules2);
        int i2 = 0;
        while (i2 < rules.size()) {
            Rule r = rules.get(i2);
            if (r.isEnabled()) {
                String text = "  " + String.valueOf(++nn);
                if (!sameRules) {
                    String rName = r.getQualifiedName();
                    text = String.valueOf(String.valueOf(nn)) + " " + rName;
                }
                JLabel act = new JLabel(text);
                act.setToolTipText("second rule " + text);
                colHead.add(act);
            }
            ++i2;
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(tablesize2, tablesize));
        int i3 = 0;
        this.menu.addPopupMenuListener(this);
        this.miClear = new JMenuItem(clearRelation);
        this.menu.add(this.miClear);
        this.miClear.addActionListener(this);
        this.miContinue = new JMenuItem(continueCompute);
        this.menu.add(this.miContinue);
        this.miContinue.addActionListener(this);
        this.miComputeAndCheck = this.menu.add(new JMenuItem(computeAndCheck));
        this.miComputeAndCheck.addActionListener(this);
        if (this.container instanceof DependencyPairContainer) {
            this.miComputeAndCheck.setEnabled(false);
        } else {
            this.miComputeAndCheck.setEnabled(true);
        }
        this.menu.addSeparator();
        this.miVisibleRel = this.menu.add(new JMenuItem(hideRelation));
        this.miVisibleRel.addActionListener(this);
        this.miVisibleRule = new JMenuItem(hideRule);
        this.miVisibleRule.addActionListener(this);
        this.menu.add(this.miVisibleRule);
        this.ml = new MouseInputAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                JButton b;
                if (e.getSource() instanceof JButton && (b = (JButton)e.getSource()).getBorder() instanceof MatteBorder && ((MatteBorder)b.getBorder()).getMatteColor() == DEPEND2) {
                    b.setBackground(DEPEND2);
                    b.setBorder(BorderFactory.createMatteBorder(CriticalPairPanel.this.borderWidth, CriticalPairPanel.this.borderWidth, CriticalPairPanel.this.borderWidth, CriticalPairPanel.this.borderWidth, DEPEND));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JButton b;
                if (e.getSource() instanceof JButton && (b = (JButton)e.getSource()).getBorder() instanceof MatteBorder && (((MatteBorder)b.getBorder()).getMatteColor() == DEPEND || ((MatteBorder)b.getBorder()).getMatteColor() == DEPEND2)) {
                    b.setBackground(DEPEND);
                    b.setBorder(BorderFactory.createMatteBorder(CriticalPairPanel.this.borderWidth, CriticalPairPanel.this.borderWidth, CriticalPairPanel.this.borderWidth, CriticalPairPanel.this.borderWidth, DEPEND2));
                }
            }
        };
        this.addMouseListener(this.ml);
        while (i3 < tablesize2) {
            Rule r1 = rules2.get(i3);
            int ii = 0;
            while (ii < tablesize) {
                Rule r2 = rules.get(ii);
                JButton act = new JButton("?");
                act.setFont(bfont);
                act.setForeground(Color.black);
                act.addMouseListener(this.ml);
                act.addActionListener(this);
                String r1Name = r1.getQualifiedName();
                String r2Name = r2.getQualifiedName();
                act.setToolTipText("[" + r1Name + ", " + r2Name + "]");
                act.setMinimumSize(new Dimension(act.getHeight(), act.getHeight()));
                act.setComponentPopupMenu(this.menu);
                this.addButton(r1, r2, act);
                mainPanel.add(act);
                this.refreshView(r1, r2, act, -1);
                ++ii;
            }
            ++i3;
        }
        Dimension dim = mainPanel.getPreferredSize();
        Dimension dim2 = new Dimension();
        dim2.setSize(dim.getWidth(), colHead.getPreferredSize().getHeight());
        colHead.setMinimumSize(dim2);
        colHead.setPreferredSize(dim2);
        this.tableW = (int)dim2.getWidth();
        dim2 = new Dimension();
        dim2.setSize(rowHead.getPreferredSize().getWidth(), dim.getHeight());
        rowHead.setPreferredSize(dim2);
        rowHead.setMinimumSize(dim2);
        this.tableH = (int)dim2.getHeight();
        mainPanel.setPreferredSize(dim);
        mainPanel.setMinimumSize(dim);
        this.main.setRowHeaderView(rowHead);
        this.main.setColumnHeaderView(colHead);
        this.main.setViewportView(mainPanel);
        this.main.setCorner("UPPER_LEFT_CORNER", new JLabel(" first \\ second"));
        this.add((Component)this.main, "Center");
    }

    private List<Rule> getEnabledRules(List<Rule> rules) {
        Vector<Rule> result = new Vector<Rule>();
        int i = 0;
        while (i < rules.size()) {
            if (rules.get(i).isEnabled()) {
                result.add(rules.get(i));
            }
            ++i;
        }
        return result;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        JButton b = (JButton)((JPopupMenu)e.getSource()).getInvoker();
        if (!b.isEnabled() || b.getActionCommand().equals("VIEW")) {
            this.menu.removeAll();
            return;
        }
        this.first = this.firstRules.get(b);
        this.second = this.secondRules.get(b);
        ExcludePairContainer.Entry entry = this.container.getEntry(this.first, this.second);
        if (entry.getStatus() == 7) {
            this.menu.removeAll();
            return;
        }
        ExcludePairContainer.Entry entry1 = this.container.getEntry(this.first, this.first);
        ExcludePairContainer.Entry entry2 = this.container.getEntry(this.second, this.second);
        if (entry.getState() == 5) {
            this.menu.removeAll();
            this.menu.add(new JMenuItem(String.valueOf(this.first.getName()) + " - disabled"));
            this.menu.getComponent(0).setEnabled(false);
            return;
        }
        if (entry.getState() == 4) {
            this.menu.removeAll();
            this.menu.add(new JMenuItem(String.valueOf(this.first.getName()) + " - not related"));
            this.menu.getComponent(0).setEnabled(false);
            return;
        }
        if (this.menu.getComponents().length <= 1) {
            this.menu.removeAll();
            this.menu.add(this.miClear);
            this.menu.add(this.miContinue);
            this.menu.add(this.miVisibleRel);
            this.menu.add(this.miVisibleRule);
        }
        if (entry.getState() != 3 && entry.getState() != 31 && entry.getState() != 32) {
            this.miClear.setEnabled(false);
            this.miContinue.setEnabled(false);
            this.miVisibleRel.setEnabled(false);
            this.miVisibleRule.setEnabled(false);
        } else {
            this.miClear.setEnabled(true);
            this.miContinue.setEnabled(entry.isProgressIndexSet());
            this.miVisibleRel.setEnabled(true);
            this.miVisibleRule.setEnabled(true);
        }
        if (entry.isRelationVisible()) {
            this.miVisibleRel.setText(hideRelation);
        } else {
            this.miVisibleRel.setText(showRelation);
        }
        if (entry.isRuleVisible()) {
            this.miVisibleRule.setText(hideRule);
        } else {
            this.miVisibleRule.setText(showRule);
        }
        if (this.first != this.second) {
            this.miVisibleRule.setEnabled(false);
            if (!entry.isCritical()) {
                this.miVisibleRel.setEnabled(false);
            } else if (!entry1.isRuleVisible() || !entry2.isRuleVisible()) {
                this.miVisibleRel.setEnabled(false);
            } else {
                this.miVisibleRel.setEnabled(true);
            }
        } else {
            this.miVisibleRule.setEnabled(true);
            if (!entry.isCritical()) {
                this.miVisibleRel.setEnabled(false);
            } else {
                this.miVisibleRel.setEnabled(true);
            }
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public Container getMainContainer() {
        return this.main;
    }

    public ExcludePairContainer getPairContainer() {
        return this.container;
    }

    public void setPairContainer(ExcludePairContainer container) {
        this.container = container;
        this.refreshView();
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isEmpty() {
        return this.container.isEmpty();
    }

    public int getKindOfPairContainer() {
        return this.container.getKindOfConflict();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    public int getTableWidth() {
        return this.tableW;
    }

    public int getTableHeight() {
        return this.tableH;
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (e.getSource() instanceof JMenuItem) {
            if (this.first != null && this.second != null) {
                ExcludePairContainer.Entry entry = this.container.getEntry(this.first, this.second);
                if (entry.getState() == 3 || entry.getState() == 31 || entry.getState() == 32) {
                    if (((JMenuItem)e.getSource()).getText().equals(clearRelation)) {
                        this.container.clearEntry(this.first, this.second);
                        this.container.enableUseHostGraph(false, null);
                        JButton b = this.buttons.get(this.first).get(this.second);
                        b.setBackground(NOT_SET);
                        if (b.getBorder() instanceof MatteBorder) {
                            b.setBorder(BorderFactory.createMatteBorder(this.borderWidth, this.borderWidth, this.borderWidth, this.borderWidth, NOT_SET));
                        }
                        b.setText("?");
                        this.clearRulePair(this.first, this.second);
                        this.fireParserGUIEvent(null);
                    } else if (((JMenuItem)e.getSource()).getText().equals(continueCompute)) {
                        if (entry.isProgressIndexSet()) {
                            if (this.b2cpData.get(e.getSource()) == null) {
                                Pair<Rule, Rule> pair = new Pair<Rule, Rule>(this.first, this.second);
                                this.fireParserGUIEvent(pair, 10);
                            } else {
                                CriticalPairData data = this.b2cpData.get(e.getSource());
                                this.fireParserGUIEvent(data, 10);
                            }
                        }
                    } else if (((JMenuItem)e.getSource()).getText().equals(computeAndCheck)) {
                        this.container.enableUseHostGraph(true, this.container.getGrammar().getGraph());
                        Pair<Rule, Rule> pair = new Pair<Rule, Rule>(this.first, this.second);
                        this.fireParserGUIEvent(pair);
                    } else if (((JMenuItem)e.getSource()).getText().equals(hideRelation)) {
                        if (entry.isCritical()) {
                            this.setRelationVisible(this.first, this.second, false);
                            this.refreshView();
                        }
                    } else if (((JMenuItem)e.getSource()).getText().equals(showRelation)) {
                        if (entry.isCritical() && this.container.getEntry(this.first, this.first).isRuleVisible() && this.container.getEntry(this.second, this.second).isRuleVisible()) {
                            this.setRelationVisible(this.first, this.second, true);
                            this.refreshView();
                        }
                    } else if (((JMenuItem)e.getSource()).getText().equals(hideRule)) {
                        this.setRuleContextVisible(this.first, this.second, false);
                        this.setRuleVisible(this.first, this.second, false);
                        this.refreshView();
                    } else if (((JMenuItem)e.getSource()).getText().equals(showRule)) {
                        this.setRuleContextVisible(this.first, this.second, true);
                        this.setRuleVisible(this.first, this.second, true);
                        this.refreshView();
                    }
                } else if (((JMenuItem)e.getSource()).getText().equals(computeAndCheck)) {
                    this.container.enableUseHostGraph(true, this.container.getGrammar().getGraph());
                    Pair<Rule, Rule> pair = new Pair<Rule, Rule>(this.first, this.second);
                    this.fireParserGUIEvent(pair);
                } else if (((JMenuItem)e.getSource()).getText().equals(hideRule)) {
                    this.setRuleContextVisible(this.first, this.second, false);
                    this.setRuleVisible(this.first, this.second, false);
                    this.refreshView();
                } else if (((JMenuItem)e.getSource()).getText().equals(showRule)) {
                    this.setRuleContextVisible(this.first, this.second, true);
                    this.setRuleVisible(this.first, this.second, true);
                    this.refreshView();
                }
            }
        } else if (e.getSource() instanceof JButton) {
            this.first = this.firstRules.get(source);
            this.second = this.secondRules.get(source);
            if (this.first != null && this.second != null) {
                if (this.b2cpData.get(e.getSource()) == null) {
                    ExcludePairContainer.Entry entry = this.container.getEntry(this.first, this.second);
                    if (entry.getState() != 5 && entry.getState() != 4 && entry.getState() != 2) {
                        Pair<Rule, Rule> pair = new Pair<Rule, Rule>(this.first, this.second);
                        this.fireParserGUIEvent(pair);
                    }
                } else {
                    CriticalPairData data = this.b2cpData.get(e.getSource());
                    this.fireParserGUIEvent(data);
                }
            }
        }
    }

    private void clearRulePair(Rule rule1, Rule rule2) {
        if (this.container.getKindOfConflict() == 0) {
            this.fireParserGUIEvent(new CriticalPairEvent(this.container, rule1, rule2, 6));
        } else {
            this.fireParserGUIEvent(new CriticalPairEvent(this.container, rule1, rule2, 6));
        }
    }

    private void setRuleVisible(Rule rule1, Rule rule2, boolean vis) {
        JButton b = this.buttons.get(rule1).get(rule2);
        if (!vis) {
            b.setForeground(Color.darkGray);
            b.setToolTipText(String.valueOf(b.getToolTipText()) + ":HIDDEN");
        } else {
            b.setForeground(Color.white);
            b.setToolTipText("[" + rule1.getQualifiedName() + ", " + rule2.getQualifiedName() + "]");
        }
        if (this.container.getKindOfConflict() == 0) {
            this.fireParserGUIEvent(new CPAEventData(rule1, rule2, CPAEventData.SHOW_RULE, "C", vis));
        } else {
            this.fireParserGUIEvent(new CPAEventData(rule1, rule2, CPAEventData.SHOW_RULE, "D", vis));
        }
        this.container.setEntryRuleVisible(rule1, rule2, vis, true, false);
    }

    private void setRuleContextVisible(Rule rule1, Rule rule2, boolean vis) {
        Enumeration<Rule> keys = this.container.getExcludeContainer().keys();
        while (keys.hasMoreElements()) {
            Rule r2;
            Rule r1 = keys.nextElement();
            if (r1 != rule1) continue;
            Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> secondPart = this.container.getExcludeContainer().get(r1);
            Enumeration<Rule> k2 = secondPart.keys();
            while (k2.hasMoreElements()) {
                r2 = k2.nextElement();
                this.setRelationVisible(r1, r2, vis);
            }
            k2 = secondPart.keys();
            while (k2.hasMoreElements()) {
                r2 = k2.nextElement();
                this.setRelationVisible(r2, r1, vis);
            }
            break block0;
        }
    }

    private void setRelationVisible(Rule rule1, Rule rule2, boolean vis) {
        JButton b = this.buttons.get(rule1).get(rule2);
        if (b != null) {
            if (!vis) {
                b.setForeground(Color.darkGray);
                b.setToolTipText(String.valueOf(b.getToolTipText()) + ":HIDDEN");
            } else {
                b.setForeground(Color.white);
                b.setToolTipText("[" + rule1.getQualifiedName() + ", " + rule2.getQualifiedName() + "]");
            }
            if (this.container.getKindOfConflict() == 0) {
                this.fireParserGUIEvent(new CPAEventData(rule1, rule2, CPAEventData.SHOW_RELATION, "C", vis));
            } else {
                this.fireParserGUIEvent(new CPAEventData(rule1, rule2, CPAEventData.SHOW_RELATION, "D", vis));
            }
            this.container.setEntryRelationVisible(rule1, rule2, vis, true);
        }
    }

    public void addParserGUIListener(ParserGUIListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeParserGUIListener(ParserGUIListener listener) {
        this.listeners.removeElement(listener);
    }

    private void fireParserGUIEvent(Object data) {
        ParserGUIEvent event = new ParserGUIEvent(this, data);
        int i = 0;
        while (i < this.listeners.size()) {
            ParserGUIListener l = this.listeners.elementAt(i);
            l.occured(event);
            ++i;
        }
    }

    private void fireParserGUIEvent(Object data, int msg) {
        ParserGUIEvent event = new ParserGUIEvent(this, data, msg);
        int i = 0;
        while (i < this.listeners.size()) {
            ParserGUIListener l = this.listeners.elementAt(i);
            l.occured(event);
            ++i;
        }
    }

    void addButton(Rule r1, Rule r2, JButton button) {
        Hashtable<Rule, JButton> hash1 = this.buttons.get(r1);
        if (hash1 == null) {
            hash1 = new Hashtable();
            this.buttons.put(r1, hash1);
        }
        hash1.put(r2, button);
        this.firstRules.put(button, r1);
        this.secondRules.put(button, r2);
    }

    JButton getButton(Rule r1, Rule r2) {
        Hashtable<Rule, JButton> hash1 = this.buttons.get(r1);
        if (hash1 == null) {
            return null;
        }
        return hash1.get(r2);
    }

    public void showCriticalPairsOfKind(String kind) {
        this.b2cpData.clear();
        this.clearView();
        List<CriticalPairData> list = this.container.getCriticalPairDataOfKind(kind);
        int i = 0;
        while (i < list.size()) {
            CriticalPairData data = list.get(i);
            JButton b = this.getButton(data.getRule1(), data.getRule2());
            b.setActionCommand("VIEW");
            this.b2cpData.put(b, data);
            this.refreshView(data, b);
            ++i;
        }
    }

    void refreshView(CriticalPairData pairData, JButton button) {
        Rule r2;
        if (button == null) {
            return;
        }
        Rule r1 = pairData.getRule1();
        ExcludePairContainer.Entry entry = this.container.getEntry(r1, r2 = pairData.getRule2());
        if (entry != null && (entry.getState() == 3 || entry.getState() == 31 || entry.getState() == 32) && entry.isCritical() && entry.getOverlapping() != null) {
            button.setText("" + pairData.getCriticalsOfKind(-1).size());
            if (this.container.getKindOfConflict() == 1 || this.container.getKindOfConflict() == 2) {
                if (entry.getState() == 3) {
                    button.setBackground(DEPEND);
                } else if (entry.getState() == 31) {
                    button.setBackground(DEPEND2);
                } else if (entry.getState() == 32) {
                    button.setBackground(DEPEND);
                    button.setBorder(BorderFactory.createMatteBorder(this.borderWidth, this.borderWidth, this.borderWidth, this.borderWidth, DEPEND2));
                }
            } else if (this.container.getKindOfConflict() == 0) {
                button.setBackground(CRITIC);
            }
            button.setEnabled(true);
        }
    }

    private void clearView() {
        Enumeration<Rule> en1 = this.buttons.keys();
        while (en1.hasMoreElements()) {
            Rule r1 = en1.nextElement();
            Enumeration<Rule> en2 = this.buttons.get(r1).keys();
            while (en2.hasMoreElements()) {
                Rule r2 = en2.nextElement();
                JButton btn = this.getButton(r1, r2);
                this.clearButtonView(r1, r2, btn);
            }
        }
    }

    private void clearButtonView(Rule r1, Rule r2, JButton button) {
        if (button == null) {
            return;
        }
        if (!button.getText().equals("?")) {
            button.setBackground(NOT_CRITIC);
            button.setText("0");
            button.setToolTipText("");
            button.setEnabled(false);
        }
    }

    public void refreshView() {
        this.b2cpData.clear();
        Enumeration<Rule> en1 = this.buttons.keys();
        while (en1.hasMoreElements()) {
            Rule r1 = en1.nextElement();
            Enumeration<Rule> en2 = this.buttons.get(r1).keys();
            while (en2.hasMoreElements()) {
                Rule r2 = en2.nextElement();
                this.refreshView(r1, r2, this.getButton(r1, r2), -1);
            }
        }
    }

    void refreshView(Rule r1, Rule r2, int key) {
        this.refreshView(r1, r2, this.getButton(r1, r2), key);
    }

    void refreshView(Rule r1, Rule r2, JButton button, int key) {
        if (button == null) {
            return;
        }
        button.setEnabled(true);
        button.setActionCommand("");
        ExcludePairContainer.Entry entry = this.container.getEntry(r1, r2);
        ExcludePairContainer.Entry entry1 = this.container.getEntry(r1, r1);
        ExcludePairContainer.Entry entry2 = this.container.getEntry(r2, r2);
        if (entry.getState() == 0) {
            button.setBackground(NOT_SET);
            button.setText("?");
            button.setForeground(Color.black);
            if (button.getBorder() instanceof MatteBorder) {
                button.setBorder(border);
            }
        } else if (entry.getState() == 1) {
            button.setBackground(NOT_SET);
            button.setText("?");
            if (button.getBorder() instanceof MatteBorder) {
                button.setBorder(border);
            }
        } else if (entry.getState() == 2) {
            button.setBackground(COMPUTING);
            button.setText("C");
            if (button.getBorder() instanceof MatteBorder) {
                button.setBorder(border);
            }
        } else if (entry.getState() == 3 || entry.getState() == 31 || entry.getState() == 32) {
            if (entry.isCritical()) {
                if (this.container.getKindOfConflict() == 1 || this.container.getKindOfConflict() == 2) {
                    if (entry.getState() == 3) {
                        button.setBackground(DEPEND);
                    } else if (entry.getState() == 31) {
                        button.setBackground(DEPEND2);
                    } else if (entry.getState() == 32) {
                        button.setBackground(DEPEND);
                        button.setBorder(BorderFactory.createMatteBorder(this.borderWidth, this.borderWidth, this.borderWidth, this.borderWidth, DEPEND2));
                    }
                } else if (this.container.getKindOfConflict() == 0) {
                    button.setBackground(CRITIC);
                }
                if (entry.getStatus() == 8) {
                    button.setBorder(BorderFactory.createMatteBorder(3, 3, 3, 3, Color.BLACK));
                }
                if (entry.getOverlapping() != null) {
                    button.setText("" + entry.getOverlapping().size());
                } else {
                    button.setText("!");
                }
                if (!entry.isRuleVisible() || !entry.isRelationVisible()) {
                    button.setForeground(Color.white);
                    if (button.getToolTipText().indexOf("HIDDEN") == -1) {
                        button.setToolTipText(String.valueOf(button.getToolTipText()) + ":HIDDEN");
                    }
                } else if (entry1 != null && !entry1.isRuleVisible() || entry2 != null && !entry2.isRuleVisible()) {
                    button.setForeground(Color.white);
                    if (button.getToolTipText().indexOf("HIDDEN") == -1) {
                        button.setToolTipText(String.valueOf(button.getToolTipText()) + ":HIDDEN");
                    }
                } else {
                    button.setForeground(Color.black);
                    button.setToolTipText("[" + r1.getQualifiedName() + ", " + r2.getQualifiedName() + "]");
                }
                if (key == 0 || entry.getStatus() == 6) {
                    button.setEnabled(false);
                } else if (entry.getState() != 5) {
                    button.setEnabled(true);
                }
            } else {
                button.setBackground(NOT_CRITIC);
                if (entry.getStatus() == 8) {
                    button.setBorder(BorderFactory.createMatteBorder(3, 3, 3, 3, Color.BLACK));
                }
                button.setText("0");
                if (!entry.isRuleVisible() || !entry.isRelationVisible()) {
                    button.setForeground(Color.white);
                    if (button.getToolTipText().indexOf("HIDDEN") == -1) {
                        button.setToolTipText(String.valueOf(button.getToolTipText()) + ":HIDDEN");
                    }
                } else if (entry1 != null && !entry1.isRuleVisible() || entry2 != null && !entry2.isRuleVisible()) {
                    button.setForeground(Color.white);
                    if (button.getToolTipText().indexOf("HIDDEN") == -1) {
                        button.setToolTipText(String.valueOf(button.getToolTipText()) + ":HIDDEN");
                    }
                } else {
                    button.setForeground(Color.black);
                    button.setToolTipText("[" + r1.getQualifiedName() + ", " + r2.getQualifiedName() + "]");
                }
            }
            if (key == 2 || entry.getStatus() == 6) {
                button.setEnabled(false);
            } else if (entry.getStatus() == 7) {
                button.setToolTipText("[" + r1.getQualifiedName() + ", " + r2.getQualifiedName() + "]" + " - not computed");
                button.setBackground(Color.LIGHT_GRAY);
                button.setText("");
            } else if (entry.getState() != 5) {
                button.setEnabled(true);
            }
        } else if (entry.getState() == 5) {
            if (!r1.isEnabled() || !r2.isEnabled()) {
                String s = String.valueOf(r1.getName()) + ": DISABLED";
                if (!r1.isEnabled() && !r2.isEnabled()) {
                    s = "DISABLED";
                } else if (!r2.isEnabled()) {
                    s = String.valueOf(r2.getName()) + ": DISABLED";
                }
                button.setBackground(DISABLED);
                button.setText("");
                button.setToolTipText(s);
            } else {
                entry.setState(0);
                this.container.clearEntry(r1, r2);
                button.setBackground(NOT_SET);
                button.setText("?");
                button.setForeground(Color.black);
            }
        } else if (entry.getState() == 4) {
            button.setBackground(NOT_RELATED);
            button.setText("");
        } else if (entry.getState() == 6) {
            button.setEnabled(false);
        }
    }

    @Override
    public void parserEventOccured(ParserEvent p) {
        if (p instanceof CriticalPairEvent) {
            if (((CriticalPairEvent)p).getFirstRule() == null || ((CriticalPairEvent)p).getSecondRule() == null) {
                return;
            }
            Rule r1 = ((CriticalPairEvent)p).getFirstRule();
            Rule r2 = ((CriticalPairEvent)p).getSecondRule();
            this.refreshView(r1, r2, ((CriticalPairEvent)p).getKey());
        }
    }
}

