/*
 * Decompiled with CFR 0.152.
 */
package agg.cons;

import agg.cons.Evaluable;
import agg.cons.Formula;
import agg.util.Pair;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.Node;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class FormulaGraph {
    public static final String AND = "AND";
    public static final String OR = "OR";
    public static final String NOT = "NOT";
    public static final String FORALL = "FORALL";
    List<Evaluable> evals = new Vector<Evaluable>();
    List<String> vars = new Vector<String>();
    Formula formula;
    String fStr;
    String fNameStr;
    Graph g;
    Type not;
    Type and;
    Type or;
    Type forall;
    Type connectAt;
    Type refinedBy;
    Node top;
    final HashMap<String, Type> name2type = new HashMap();
    final HashMap<String, Integer> name2indx = new HashMap();

    public FormulaGraph() {
        this.g = new Graph();
        this.createDefaultTypes(this.g.getTypeSet());
    }

    private void createDefaultTypes(TypeSet types) {
        this.not = types.createNodeType(false);
        this.not.setStringRepr(NOT);
        this.not.setAdditionalRepr(":ROUNDRECT:java.awt.Color[r=255,g=0,b=0]::[NODE]:");
        this.name2type.put(NOT, this.not);
        this.and = types.createNodeType(false);
        this.and.setStringRepr(AND);
        this.and.setAdditionalRepr(":ROUNDRECT:java.awt.Color[r=0,g=0,b=0]::[NODE]:");
        this.name2type.put(AND, this.and);
        this.or = types.createNodeType(false);
        this.or.setStringRepr(OR);
        this.or.setAdditionalRepr(":ROUNDRECT:java.awt.Color[r=0,g=0,b=0]::[NODE]:");
        this.name2type.put(OR, this.or);
        this.forall = types.createNodeType(false);
        this.forall.setStringRepr(FORALL);
        this.forall.setAdditionalRepr(":ROUNDRECT:java.awt.Color[r=0,g=0,b=0]::[NODE]:");
        this.name2type.put(FORALL, this.forall);
        this.connectAt = types.createArcType(false);
        this.connectAt.setAdditionalRepr(":SOLID_LINE:java.awt.Color[r=0,g=0,b=0]::[EDGE]:");
        this.refinedBy = types.createArcType(false);
        this.refinedBy.setAdditionalRepr(":SOLID_LINE:java.awt.Color[r=0,g=0,b=255]::[EDGE]:");
    }

    public Graph getGraph() {
        return this.g;
    }

    public Formula getFormula() {
        return this.formula;
    }

    public String getFormulaTextByIndex() {
        if ("".equals(this.fStr)) {
            return "true";
        }
        return this.fStr;
    }

    public String getFormulaTextByName() {
        if ("".equals(this.fStr)) {
            return "true";
        }
        return this.fNameStr;
    }

    public Node setTop(String name) {
        Type t = this.getNodeType(name);
        if (t != null) {
            try {
                this.top = this.g.createNode(t);
                return this.top;
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        return null;
    }

    public Node setTop(String name, Evaluable obj) {
        Type t = this.getNodeType(name);
        if (t != null) {
            try {
                this.top = this.g.createNode(t);
                if (obj != null && !this.isOpType(t)) {
                    this.evals.add(obj);
                }
                return this.top;
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        return null;
    }

    public Node connectAt(Node node, String name) {
        Node n = null;
        if (node != null) {
            Type t = this.getNodeType(name);
            try {
                n = this.g.createNode(t);
                this.g.createArc(this.connectAt, node, n);
            }
            catch (TypeException ex) {
                System.out.println(ex.getLocalizedMessage());
            }
        }
        return n;
    }

    public Node connectAt(Node node, String name, Evaluable obj) {
        Node n = null;
        if (node != null) {
            Type t = this.getNodeType(name);
            try {
                n = this.g.createNode(t);
                this.g.createArc(this.connectAt, node, n);
                if (obj != null && !this.isOpType(t)) {
                    this.evals.add(obj);
                }
            }
            catch (TypeException ex) {
                System.out.println(ex.getLocalizedMessage());
            }
        }
        return n;
    }

    public void graph2formula() {
        if (this.top != null) {
            Pair<String, String> p = this.graph2text(this.top);
            this.fNameStr = (String)p.first;
            this.fStr = (String)p.second;
            if (this.evals.size() > 0) {
                this.formula = new Formula(this.evals, (String)p.second);
            }
        }
    }

    private Type getNodeType(String name) {
        Type t = this.name2type.get(name);
        if (t == null) {
            t = this.createType(name);
        }
        return t;
    }

    private Type createType(String name) {
        Type t = this.g.getTypeSet().createNodeType(false);
        t.setStringRepr(name);
        t.setAdditionalRepr(":RECT:java.awt.Color[r=0,g=0,b=0]::[NODE]:");
        this.name2type.put(name, t);
        this.vars.add(name);
        this.name2indx.put(name, this.vars.size());
        return t;
    }

    private Pair<String, String> graph2text(Node n) {
        Node n1 = null;
        String s1 = "";
        String s2 = "";
        int c = n.getNumberOfOutgoingArcs();
        switch (c) {
            case 0: {
                s1 = n.getType().getName();
                if (this.name2indx.get(n.getType().getName()) != null) {
                    s2 = String.valueOf(this.name2indx.get(n.getType().getName()));
                    break;
                }
                s2 = n.getType().getName();
                break;
            }
            case 1: {
                if (n.getOutgoingArcs().next().getContextUsage() == -1) {
                    s1 = n.getType().getName();
                    if (this.name2indx.get(n.getType().getName()) != null) {
                        s2 = String.valueOf(this.name2indx.get(n.getType().getName()));
                        break;
                    }
                    s2 = n.getType().getName();
                    break;
                }
                n1 = (Node)n.getOutgoingArcs().next().getTarget();
                if (n.getType().getName().equals(NOT)) {
                    Pair<String, String> p = this.graph2text(n1);
                    s1 = " !" + (String)p.first;
                    s2 = " !" + (String)p.second;
                    break;
                }
                if (n.getType().getName().equals(FORALL)) {
                    Pair<String, String> p1 = this.graph2text(n1);
                    s1 = " FORALL(" + (String)p1.first + ")";
                    s2 = " A(" + (String)p1.second + ")";
                    break;
                }
                Pair<String, String> p = this.graph2text(n1);
                s1 = String.valueOf(n.getType().getName()) + "(" + (String)p.first + ")";
                s2 = String.valueOf(n.getType().getName()) + "(" + (String)p.second + ")";
                break;
            }
            case 2: {
                Iterator<Arc> outs = n.getOutgoingArcs();
                n1 = (Node)outs.next().getTarget();
                Node n2 = (Node)outs.next().getTarget();
                if (n.getType().getName().equals(AND)) {
                    Pair<String, String> p1 = this.graph2text(n1);
                    Pair<String, String> p2 = this.graph2text(n2);
                    s1 = "(" + (String)p1.first + " & " + (String)p2.first + ")";
                    s2 = "(" + (String)p1.second + " & " + (String)p2.second + ")";
                    break;
                }
                if (!n.getType().getName().equals(OR)) break;
                Pair<String, String> p1 = this.graph2text(n1);
                Pair<String, String> p2 = this.graph2text(n2);
                s1 = "(" + (String)p1.first + " | " + (String)p2.first + ")";
                s2 = "(" + (String)p1.second + " | " + (String)p2.second + ")";
            }
        }
        return new Pair<String, String>(s1, s2);
    }

    private boolean isOpType(Type t) {
        return t == this.and || t == this.or || t == this.not || t == this.forall;
    }
}

