/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.parser.javaExpr;

import agg.attribute.parser.javaExpr.ASTEmptyDimension;
import agg.attribute.parser.javaExpr.ASTWrongTypeException;
import agg.attribute.parser.javaExpr.Node;
import agg.attribute.parser.javaExpr.SimpleNode;
import java.lang.reflect.Array;

public class ASTArrayAllocation
extends SimpleNode {
    static final long serialVersionUID = 1L;
    Class<?> componentClass = null;
    int nDimensions = 0;

    ASTArrayAllocation(String id) {
        super(id);
    }

    public static Node jjtCreate(String id) {
        return new ASTArrayAllocation(id);
    }

    @Override
    protected boolean isConstantExpr() {
        return false;
    }

    @Override
    public void checkContext() {
        int nChildren = this.jjtGetNumChildren();
        Node componentNode = this.jjtGetChild(0);
        componentNode.checkContext();
        this.componentClass = ((SimpleNode)componentNode).getNodeClass();
        this.nDimensions = nChildren - 1;
        int i = 1;
        while (i < nChildren) {
            Node lengthNode = this.jjtGetChild(i);
            lengthNode.checkContext();
            if (((SimpleNode)lengthNode).getNodeClass() != Integer.TYPE) {
                String reqSig = "An array length must be of type integer (int).";
                String foundSig = "Tried to pass an object of type\n'" + ((SimpleNode)lengthNode).getNodeClass() + "' as array length.";
                throw new ASTWrongTypeException(reqSig, foundSig);
            }
            ++i;
        }
        int[] dimArray = new int[this.nDimensions];
        dimArray[0] = 1;
        i = 1;
        while (i < this.nDimensions) {
            dimArray[i] = 0;
            ++i;
        }
        Object arrayInst = Array.newInstance(this.componentClass, dimArray);
        Class<?> resultClass = arrayInst.getClass();
        this.setNodeClass(resultClass);
    }

    @Override
    public void interpret() {
        int nChildren = this.jjtGetNumChildren();
        Node componentNode = this.jjtGetChild(0);
        boolean isLengthAllowed = true;
        int[] lengthList = new int[nChildren - 1];
        componentNode.interpret();
        this.componentClass = (Class)stack.get(top--);
        int i = 1;
        while (i < nChildren) {
            int length;
            Node lengthNode = this.jjtGetChild(i);
            lengthNode.interpret();
            lengthList[i - 1] = length = ((Integer)stack.get(top--)).intValue();
            if (length < 0) {
                throw new RuntimeException("An array length must be a non-negative integer number (int) or empty.\nTried to pass a value of " + length + " as length.");
            }
            if (length == 0) {
                if (i == 1) {
                    throw new RuntimeException("A positive array length value is required\nat least for the first dimension.");
                }
                isLengthAllowed = false;
            } else if (!isLengthAllowed) {
                throw new RuntimeException("A positive array length value is illegal after a previous\ndimension length was empty.");
            }
            ++i;
        }
        stack.add(++top, Array.newInstance(this.componentClass, lengthList));
    }

    @Override
    public String getString() {
        String dimString = "";
        Node constructorName = this.jjtGetChild(0);
        int nChildren = this.jjtGetNumChildren();
        int i = 1;
        while (i < nChildren) {
            Node dimension = this.jjtGetChild(i);
            dimString = dimension instanceof ASTEmptyDimension ? String.valueOf(dimString) + "[]" : String.valueOf(dimString) + "[" + dimension.getString() + "]";
            ++i;
        }
        return "new " + constructorName.getString() + dimString;
    }

    @Override
    public Node copy() {
        Node copy = super.copy();
        ((ASTArrayAllocation)copy).componentClass = this.componentClass;
        ((ASTArrayAllocation)copy).nDimensions = this.nDimensions;
        return copy;
    }
}

