/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.compare.ui.editor.ModelCompareEditorInput;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.henshin.interpreter.ApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.BasicApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.interpreter.ui.InterpreterUIPlugin;
import org.eclipse.emf.henshin.interpreter.ui.util.Capsule;
import org.eclipse.emf.henshin.interpreter.ui.util.Tuple;
import org.eclipse.emf.henshin.interpreter.ui.util.Tuples;
import org.eclipse.emf.henshin.interpreter.ui.wizard.HenshinationException;
import org.eclipse.emf.henshin.interpreter.ui.wizard.HenshinationPreview;
import org.eclipse.emf.henshin.interpreter.ui.wizard.HenshinationResult;
import org.eclipse.emf.henshin.interpreter.ui.wizard.HenshinationResultView;
import org.eclipse.emf.henshin.interpreter.ui.wizard.ParameterConfiguration;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class Henshination {
    protected Unit unit;
    protected Collection<ParameterConfiguration> paramCfgs;
    protected URI modelUri;
    protected Resource modelResource;
    protected ResourceSet resourceSet;

    public URI getModelUri() {
        return this.modelUri;
    }

    public void setModelUri(URI modelUri) {
        this.modelUri = modelUri;
        this.modelResource = null;
        this.resourceSet = new ResourceSetImpl();
        this.registerImportedPackages();
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit, Collection<ParameterConfiguration> paramCfgs) {
        this.unit = unit;
        this.paramCfgs = paramCfgs;
        this.registerImportedPackages();
    }

    private void registerImportedPackages() {
        if (this.resourceSet == null || this.unit == null) {
            return;
        }
        for (EPackage pack : this.unit.getModule().getImports()) {
            String nsURI = pack.getNsURI();
            if (nsURI == null || this.resourceSet.getPackageRegistry().getEPackage(nsURI) != null) continue;
            this.resourceSet.getPackageRegistry().put((Object)nsURI, (Object)pack);
        }
    }

    public Object getParameterValue(String parameterName) {
        ParameterConfiguration pCfg = this.getParameterConfiguration(parameterName);
        if (pCfg == null) {
            return null;
        }
        return pCfg.getValue();
    }

    public ParameterConfiguration getParameterConfiguration(String parameterName) {
        for (ParameterConfiguration pCfg : this.paramCfgs) {
            if (!pCfg.getName().equals(parameterName)) continue;
            return pCfg;
        }
        return null;
    }

    public Collection<ParameterConfiguration> getParameterConfigurations() {
        return this.paramCfgs;
    }

    protected Map<String, Object> prepareParameterValues() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (ParameterConfiguration paramCfg : this.paramCfgs) {
            if (paramCfg.isClear()) continue;
            result.put(paramCfg.getName(), paramCfg.getValue());
        }
        return result;
    }

    protected HenshinationResult applyTo(Resource model) throws HenshinationException {
        UnitApplication unitApplication = this.createUnitApplication(model);
        boolean result = this.runUnitApplication(unitApplication, model, false).getSecond();
        return new HenshinationResult(this, unitApplication, result);
    }

    protected Tuple<Boolean, Boolean> runUnitApplication(UnitApplication ua, Resource model, final boolean undoOnCancel) {
        HashSet oldRoots = new HashSet();
        oldRoots.addAll(ua.getEGraph().getRoots());
        BasicApplicationMonitor appMon = new BasicApplicationMonitor();
        Capsule<Boolean> result = new Capsule<Boolean>(false);
        IRunnableWithProgress unitApplicationMonitor = new IRunnableWithProgress((ApplicationMonitor)appMon, result, ua){
            private final /* synthetic */ ApplicationMonitor val$appMon;
            private final /* synthetic */ Capsule val$result;
            private final /* synthetic */ UnitApplication val$ua;
            {
                this.val$appMon = applicationMonitor;
                this.val$result = capsule;
                this.val$ua = unitApplication;
            }

            public synchronized void run(IProgressMonitor progMon) {
                Thread unitAppThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        val$result.setValue(val$ua.execute(val$appMon));
                    }
                });
                unitAppThread.start();
                while (unitAppThread.isAlive() && !progMon.isCanceled()) {
                    try {
                        this.wait(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (progMon.isCanceled() && unitAppThread.isAlive()) {
                    if (undoOnCancel) {
                        this.val$appMon.cancelAndUndo();
                    } else {
                        this.val$appMon.cancel();
                    }
                    try {
                        unitAppThread.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        try {
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, true, unitApplicationMonitor);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (EObject root : ua.getEGraph().getRoots()) {
            if (oldRoots.contains(root)) continue;
            model.getContents().add((Object)root);
        }
        return new Tuple<Boolean, Boolean>(!appMon.isCanceled(), result.getValue());
    }

    protected UnitApplication createUnitApplication(Resource model) {
        EGraphImpl graph = new EGraphImpl(model);
        EngineImpl engine = new EngineImpl();
        UnitApplicationImpl unitApplication = new UnitApplicationImpl((Engine)engine, (EGraph)graph, this.unit, null);
        for (Map.Entry<String, Object> entry : this.prepareParameterValues().entrySet()) {
            unitApplication.setParameterValue(entry.getKey(), entry.getValue());
        }
        return unitApplication;
    }

    public boolean isModelAffectedByTransformation() {
        Module module = this.unit.getModule();
        for (EPackage ep : module.getImports()) {
            EcoreUtil.resolveAll((EObject)ep);
        }
        for (EObject obj : this.getModel().getContents()) {
            if (!module.getImports().contains((Object)obj.eClass().getEPackage())) continue;
            return true;
        }
        return false;
    }

    public HenshinationResultView createPreview() throws HenshinationException {
        Resource originalModel = this.getModel();
        Resource previewModel = this.createCopy(originalModel);
        HenshinationResult result = this.applyTo(previewModel);
        if (!result.isSuccess()) {
            return new HenshinationResultView(){

                @Override
                public void showDialog(Shell shell) {
                    MessageBox mb = new MessageBox(shell, 40);
                    mb.setText(InterpreterUIPlugin.LL("_UI_Preview_ApplicationNotSuccessful_Title"));
                    mb.setMessage(InterpreterUIPlugin.LL("_UI_Preview_ApplicationNotSuccessful_Message"));
                    mb.open();
                }
            };
        }
        try {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("match.ignore.xmi.id", new Boolean(true));
            MatchModel matchModel = MatchService.doResourceMatch((Resource)previewModel, (Resource)originalModel, options);
            DiffModel diffModel = DiffService.doDiff((MatchModel)matchModel);
            ComparisonResourceSnapshot snapshot = DiffFactory.eINSTANCE.createComparisonResourceSnapshot();
            snapshot.setMatch(matchModel);
            snapshot.setDiff(diffModel);
            ModelCompareEditorInput input = new ModelCompareEditorInput((ComparisonSnapshot)snapshot);
            return new HenshinationPreview(input, result);
        }
        catch (Exception exception) {
            return new HenshinationPreview(null, result);
        }
    }

    protected Resource createCopy(Resource resource) {
        ResourceImpl copy = new ResourceImpl();
        copy.setURI(URI.createURI((String)"dummy"));
        copy.getContents().addAll(EcoreUtil.copyAll((Collection)resource.getContents()));
        return copy;
    }

    public Resource getModel() {
        if (this.modelResource != null) {
            return this.modelResource;
        }
        if (this.modelUri == null || this.modelUri.isEmpty()) {
            return null;
        }
        Map extReg = this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        if (!extReg.containsKey(this.modelUri.fileExtension())) {
            extReg.put(this.modelUri.fileExtension(), new XMIResourceFactoryImpl());
        }
        try {
            this.modelResource = this.resourceSet.getResource(this.modelUri, true);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to load Resource");
        }
        return this.modelResource;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ": " + this.unit.getName() + " " + this.paramCfgs.toString();
    }

    public IUndoableOperation getUndoableOperation() {
        Object resSet = this.resourceSet != null ? this.resourceSet : new ResourceSetImpl();
        Map extReg = resSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        if (!extReg.containsKey(this.modelUri.fileExtension())) {
            extReg.put(this.modelUri.fileExtension(), new XMIResourceFactoryImpl());
        }
        final Resource model = resSet.getResource(this.modelUri, true);
        final UnitApplication unitApplication = this.createUnitApplication(model);
        String title = String.valueOf(InterpreterUIPlugin.LL("_UI_UndoableOperation_Henshin")) + ": " + this.getUnit().getName();
        AbstractOperation operation = new AbstractOperation(title){

            public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                try {
                    if (Tuples.and(Henshination.this.runUnitApplication(unitApplication, model, true)).booleanValue()) {
                        model.save(null);
                        return Status.OK_STATUS;
                    }
                    return new Status(4, "org.eclipse.emf.henshin.interpreter.ui", "Canceled by user!");
                }
                catch (Exception e) {
                    return new Status(4, "org.eclipse.emf.henshin.interpreter.ui", e.getMessage());
                }
            }

            public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                try {
                    unitApplication.redo(null);
                    model.save(null);
                }
                catch (Exception e) {
                    return new Status(4, "org.eclipse.emf.henshin.interpreter.ui", e.getMessage());
                }
                return Status.OK_STATUS;
            }

            public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                try {
                    unitApplication.undo(null);
                    model.save(null);
                }
                catch (Exception e) {
                    return new Status(4, "org.eclipse.emf.henshin.interpreter.ui", e.getMessage());
                }
                return Status.OK_STATUS;
            }
        };
        operation.addContext(IOperationHistory.GLOBAL_UNDO_CONTEXT);
        return operation;
    }
}

