/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.testframework;

import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.InterpreterFactory;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.model.Unit;

public class Units {
    public static void assertTransformationUnitCanBeExecutedMultipleTimes(Unit tu, EGraph graph, Engine engine) throws AssertionError {
        UnitApplication ua = InterpreterFactory.INSTANCE.createUnitApplication(engine);
        ua.setUnit(tu);
        ua.setEGraph(graph);
        Units.assertUnitApplicationCanBeExecutedMultipleTimes(ua);
    }

    public static void assertUnitApplicationCanBeExecutedMultipleTimes(UnitApplication ua) throws AssertionError {
        boolean success = ua.execute(null);
        if (success) {
            success = ua.execute(null);
        }
        if (!success) {
            throw new AssertionError((Object)"expected: UnitApplication can be executed multiple times, but could not.");
        }
    }

    public static void assertTransformationUnitCanBeExecutedNTimes(Unit tu, EGraph graph, Engine engine, int n) throws AssertionError {
        UnitApplication ua = InterpreterFactory.INSTANCE.createUnitApplication(engine);
        ua.setUnit(tu);
        ua.setEGraph(graph);
        Units.assertUnitApplicationCanBeExecutedNTimes(ua, n);
    }

    public static void assertUnitApplicationCanBeExecutedNTimes(UnitApplication ua, int n) throws AssertionError {
        boolean success = true;
        int i = 0;
        while (i < n) {
            success = ua.execute(null);
            if (!success) break;
            ++i;
        }
        if (!success) {
            throw new AssertionError((Object)("expected: UnitApplication can be executed at least " + n + " times, but could only be executed " + i + " times"));
        }
    }

    public static void assertTuCanBeExecuted(UnitApplication ua) throws AssertionError {
        if (!ua.execute(null)) {
            throw new AssertionError((Object)"expected: UnitApplication can be executed.");
        }
    }

    public static void assertTuCanNotBeExecuted(UnitApplication ua) throws AssertionError {
        if (ua.execute(null)) {
            throw new AssertionError((Object)"expected: UnitApplication can not be executed.");
        }
    }
}

