/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.testframework;

import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchElement;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EGraph;

public class Graphs {
    public static void assertObjectInGraph(EObject obj, EGraph graph) throws AssertionError {
        if (!graph.contains((Object)obj)) {
            throw new AssertionError((Object)("expected: Object " + obj.toString() + " contained in graph"));
        }
    }

    public static void assertObjectNotInGraph(EObject obj, EGraph graph) throws AssertionError {
        if (graph.contains((Object)obj)) {
            throw new AssertionError((Object)("expected: Object " + obj.toString() + " not contained in graph"));
        }
    }

    public static void assertGraphsEqual(EGraph graph1, EGraph graph2, double matchSimilarityThreshold) throws AssertionError {
        MatchModel matchM;
        try {
            matchM = MatchService.doMatch((EObject)graph1.getRoots().toArray(new EObject[1])[0], (EObject)graph2.getRoots().toArray(new EObject[1])[0], null);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new AssertionError((Object)"!!!! execution interrupted.");
        }
        for (MatchElement ma : matchM.getMatchedElements()) {
            if (ma.getSimilarity() < matchSimilarityThreshold) {
                throw new AssertionError((Object)("expected: Graphs equal, but graphs not equal. Reason: Could not match graphs. Threshold exceeded: (" + ma.getSimilarity() + "), threshold " + matchSimilarityThreshold + "."));
            }
        }
        DiffModel diffM = DiffService.doDiff((MatchModel)matchM);
        if (diffM.getDifferences().size() != 0) {
            throw new AssertionError((Object)("expected: Graphs equal, but graphs not equal (" + diffM.getDifferences().size() + " changes occured.)"));
        }
    }

    public static boolean graphsEqual(EGraph graph1, EGraph graph2, double matchSimilarityThreshold) {
        MatchModel matchM;
        try {
            matchM = MatchService.doMatch((EObject)graph1.getRoots().toArray(new EObject[1])[0], (EObject)graph2.getRoots().toArray(new EObject[1])[0], null);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        for (MatchElement ma : matchM.getMatchedElements()) {
            if (!(ma.getSimilarity() < matchSimilarityThreshold)) continue;
            System.out.println("graphs not equal->similarity threshold too high");
            return false;
        }
        DiffModel diffM = DiffService.doDiff((MatchModel)matchM);
        if (diffM.getDifferences().size() == 0) {
            return true;
        }
        System.out.println("graphs not equal->differences found");
        for (DiffElement de : diffM.getDifferences()) {
            System.out.println("\t" + de);
        }
        return false;
    }
}

