/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.impl.BasicStateSpaceManager;

public class ParallelStateSpaceManager
extends BasicStateSpaceManager {
    private ExecutorService executor;
    private ExplorationWorker[] workers;
    private Future<StateSpaceException>[] futures;
    private List<State> states;
    private List<State> result;
    private boolean generateLocations;

    public ParallelStateSpaceManager(StateSpace stateSpace, int numThreads) {
        super(stateSpace);
        numThreads = Math.max(numThreads, 1);
        this.executor = Executors.newFixedThreadPool(numThreads);
        this.futures = new Future[numThreads];
        this.workers = new ExplorationWorker[numThreads];
        int i = 0;
        while (i < this.workers.length) {
            this.workers[i] = new ExplorationWorker();
            ++i;
        }
    }

    public ParallelStateSpaceManager(StateSpace stateSpace) {
        this(stateSpace, Runtime.getRuntime().availableProcessors());
    }

    @Override
    public synchronized List<State> exploreStates(List<State> states, boolean generateLocations) throws StateSpaceException {
        this.generateLocations = generateLocations;
        this.states = new Vector<State>(states);
        this.result = new Vector<State>();
        try {
            int i = 0;
            while (i < this.workers.length) {
                this.futures[i] = this.executor.submit(this.workers[i]);
                ++i;
            }
            i = 0;
            while (i < this.workers.length) {
                StateSpaceException e = this.futures[i].get();
                if (e != null) {
                    throw e;
                }
                ++i;
            }
        }
        catch (Throwable t) {
            throw this.wrapException(t);
        }
        return this.result;
    }

    private StateSpaceException wrapException(Throwable t) {
        return t instanceof StateSpaceException ? (StateSpaceException)t : new StateSpaceException(t);
    }

    @Override
    public int getNumThreads() {
        return this.workers.length;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executor.shutdownNow();
    }

    private class ExplorationWorker
    implements Callable<StateSpaceException> {
        private ExplorationWorker() {
        }

        @Override
        public StateSpaceException call() {
            while (true) {
                State next;
                try {
                    next = (State)ParallelStateSpaceManager.this.states.remove(0);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return null;
                }
                try {
                    ParallelStateSpaceManager.this.result.addAll(ParallelStateSpaceManager.this.exploreState(next, ParallelStateSpaceManager.this.generateLocations));
                }
                catch (Throwable t) {
                    return ParallelStateSpaceManager.this.wrapException(t);
                }
            }
        }
    }
}

