/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.service;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.diff.EMFCompareDiffMessages;
import org.eclipse.emf.compare.diff.engine.IDiffEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffEngineDescriptor
implements Comparable<DiffEngineDescriptor> {
    private static final String WILDCARD = "*";
    protected final String contentType;
    protected final IConfigurationElement element;
    protected final String engineClassName;
    protected final String fileExtension;
    protected final String icon;
    protected final String label;
    protected final String namespace;
    protected final String namespacePattern;
    protected final String priority;
    private IDiffEngine engine;
    private int priorityValue = -1;

    public DiffEngineDescriptor(IConfigurationElement configuration) {
        this.element = configuration;
        this.priority = this.getAttribute("priority", "low");
        this.engineClassName = this.getAttribute("engineClass", null);
        this.label = this.getAttribute("label", "");
        this.icon = this.getAttribute("icon", "");
        this.contentType = this.getAttribute("contentType", "");
        this.namespace = this.getAttribute("namespace", "");
        this.namespacePattern = this.getAttribute("namespacePattern", "");
        this.fileExtension = "".equals(this.contentType) && "".equals(this.namespace) && "".equals(this.namespacePattern) ? this.getAttribute("fileExtension", WILDCARD) : this.getAttribute("fileExtension", "");
    }

    @Override
    public int compareTo(DiffEngineDescriptor other) {
        int nombre1 = other.getPriorityValue();
        int nombre2 = this.getPriorityValue();
        return nombre2 - nombre1;
    }

    public boolean equals(Object obj) {
        boolean isEqual = true;
        if (this == obj) {
            isEqual = true;
        } else if (obj == null || this.getClass() != obj.getClass()) {
            isEqual = false;
        } else {
            DiffEngineDescriptor other = (DiffEngineDescriptor)obj;
            if (this.engineClassName == null && other.engineClassName != null) {
                isEqual = false;
            } else if (this.engineClassName != null && !this.engineClassName.equals(other.engineClassName)) {
                isEqual = false;
            } else if (this.fileExtension == null && other.fileExtension != null) {
                isEqual = false;
            } else if (this.fileExtension != null && !this.fileExtension.equals(other.fileExtension)) {
                isEqual = false;
            } else if (this.contentType == null && other.contentType != null) {
                isEqual = false;
            } else if (this.contentType != null && !this.contentType.equals(other.contentType)) {
                isEqual = false;
            } else if (this.namespace == null && other.namespace != null) {
                isEqual = false;
            } else if (this.namespace != null && !this.namespace.equals(other.namespace)) {
                isEqual = false;
            } else if (this.priority == null && other.priority != null) {
                isEqual = false;
            } else if (this.priority != null && !this.priority.equals(other.priority)) {
                isEqual = false;
            }
        }
        return isEqual;
    }

    public String getContentType() {
        return this.contentType;
    }

    public IConfigurationElement getElement() {
        return this.element;
    }

    public String getEngineClassName() {
        return this.engineClassName;
    }

    public IDiffEngine getEngineInstance() {
        if (this.engine == null) {
            try {
                this.engine = (IDiffEngine)this.element.createExecutableExtension("engineClass");
            }
            catch (CoreException e) {
                EMFComparePlugin.log((Exception)((Object)e), (boolean)false);
            }
        }
        if (this.engine != null) {
            this.engine.reset();
        }
        return this.engine;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getLabel() {
        return this.label;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getNamespacePattern() {
        return this.namespacePattern;
    }

    public String getPriority() {
        return this.priority.toLowerCase();
    }

    public int getPriorityValue() {
        if (this.priorityValue == -1) {
            this.priorityValue = 3;
            if ("lowest".equals(this.priority)) {
                this.priorityValue = 1;
            } else if ("low".equals(this.priority)) {
                this.priorityValue = 2;
            } else if ("high".equals(this.priority)) {
                this.priorityValue = 4;
            } else if ("highest".equals(this.priority)) {
                this.priorityValue = 5;
            }
        }
        return this.priorityValue;
    }

    public int hashCode() {
        int classNameHash = 0;
        if (this.engineClassName != null) {
            classNameHash = this.engineClassName.hashCode();
        }
        int namespaceHash = 0;
        if (this.namespace != null) {
            namespaceHash = this.namespace.hashCode();
        }
        int contentTypeHash = 0;
        if (this.contentType != null) {
            contentTypeHash = this.contentType.hashCode();
        }
        int extensionHash = 0;
        if (this.fileExtension != null) {
            extensionHash = this.fileExtension.hashCode();
        }
        int priorityHash = 0;
        if (this.priority != null) {
            priorityHash = this.priority.hashCode();
        }
        int hashCode = (31 + classNameHash) * 31;
        hashCode <<= 2;
        hashCode = (hashCode + extensionHash + namespaceHash + contentTypeHash) * 31;
        hashCode <<= 1;
        return hashCode += priorityHash;
    }

    private String getAttribute(String name, String defaultValue) {
        String value = this.element.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new IllegalArgumentException(EMFCompareDiffMessages.getString("Descriptor.MissingAttribute", name));
    }
}

