/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceContentTypeFilter;
import org.eclipse.emf.transaction.internal.Tracing;

class ResourceContentTypeFilter
extends NotificationFilter {
    private final IContentType contentType;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    ResourceContentTypeFilter(String contentType) {
        this.contentType = Platform.getContentTypeManager().getContentType(contentType);
        if (this.contentType == null) {
            IllegalArgumentException exc = new IllegalArgumentException("No such content type: " + contentType);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.transaction.NotificationFilter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Tracing.throwing(clazz, "createResourceContentTypeFilter", exc);
            throw exc;
        }
    }

    public boolean matches(Notification notification) {
        boolean result = false;
        IContentType[] actualTypes = this.getContentTypes(notification);
        int i = 0;
        while (!result && i < actualTypes.length) {
            result = actualTypes[i].isKindOf(this.contentType);
            ++i;
        }
        return result;
    }

    private IContentType[] getContentTypes(Notification notification) {
        Object notifier = notification.getNotifier();
        Resource res = null;
        if (notifier instanceof EObject) {
            res = ((EObject)notifier).eResource();
        } else if (notifier instanceof Resource) {
            res = (Resource)notifier;
        }
        IContentType[] result = res == null ? new IContentType[]{} : this.getContentTypes(res);
        return result;
    }

    private IContentType[] getContentTypes(Resource res) {
        class Cache
        extends AdapterImpl {
            private IContentType[] contentTypes;
            final /* synthetic */ ResourceContentTypeFilter this$0;

            Cache(ResourceContentTypeFilter resourceContentTypeFilter, IContentType[] contentTypes) {
                this.this$0 = resourceContentTypeFilter;
                this.contentTypes = contentTypes;
            }

            IContentType[] getContentTypes() {
                return this.contentTypes;
            }

            public boolean isAdapterForType(Object type) {
                Class<?> clazz = ResourceContentTypeFilter.class$1;
                if (clazz == null) {
                    try {
                        clazz = ResourceContentTypeFilter.class$1 = Class.forName("org.eclipse.emf.transaction.ResourceContentTypeFilter$1$Cache");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return type == clazz;
            }

            public void notifyChanged(Notification msg) {
                if (!msg.isTouch()) {
                    this.getTarget().eAdapters().remove((Object)((Object)this));
                }
            }
        }
        Cache cache;
        EList eList = res.eAdapters();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.emf.transaction.ResourceContentTypeFilter$1$Cache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((cache = (Cache)EcoreUtil.getAdapter((List)eList, (Object)clazz)) == null) {
            cache = new Cache(this, this.computeContentTypes(res));
            res.eAdapters().add((Object)cache);
        }
        return cache.getContentTypes();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IContentType[] computeContentTypes(Resource res) {
        ResourceSet rset = res.getResourceSet();
        if (rset == null) {
            return new IContentType[0];
        }
        URI uri = res.getURI();
        String filename = uri.trimQuery().lastSegment();
        try {
            IContentType[] result;
            InputStream stream = rset.getURIConverter().createInputStream(uri);
            try {
                try {
                    result = Platform.getContentTypeManager().findContentTypesFor(stream, filename);
                }
                catch (IOException e) {
                    Tracing.catching(this.getClass(), "getContentTypes", e);
                    result = new IContentType[]{};
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                stream.close();
                throw throwable;
            }
            {
                Object var8_11 = null;
                stream.close();
                return result;
            }
        }
        catch (IOException e) {
            Tracing.catching(this.getClass(), "getContentTypes", e);
            return Platform.getContentTypeManager().findContentTypesFor(filename);
        }
    }
}

