/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.validation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.teneo.TeneoException;

public class JPOXEmfDiagnosticException
extends TeneoException {
    private static final long serialVersionUID = 7433341056815136417L;
    private static Log log = LogFactory.getLog(JPOXEmfDiagnosticException.class);
    private final Diagnostic diagnostic;

    public static void logDiagnostic(Diagnostic diag) {
        if (diag.getSeverity() == 0 || diag.getSeverity() == 1) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Diagnostic for saving EObject");
            JPOXEmfDiagnosticException.logDiags("", diag);
        }
    }

    private static void logDiags(String prefix, Diagnostic diag) {
        log.debug((Object)(String.valueOf(prefix) + "SOURCE: " + diag.getSource()));
        switch (diag.getSeverity()) {
            case 8: {
                log.debug((Object)(String.valueOf(prefix) + "SEVERITY: CANCEL"));
                break;
            }
            case 4: {
                log.debug((Object)(String.valueOf(prefix) + "SEVERITY: ERROR"));
                break;
            }
            case 1: {
                log.debug((Object)(String.valueOf(prefix) + "SEVERITY: INFO"));
                break;
            }
            case 2: {
                log.debug((Object)(String.valueOf(prefix) + "SEVERITY: WARNING"));
            }
        }
        log.debug((Object)(String.valueOf(prefix) + "MSG: " + diag.getMessage()));
        for (Object element : diag.getChildren()) {
            JPOXEmfDiagnosticException.logDiags(String.valueOf(prefix) + ">", (Diagnostic)element);
        }
    }

    public JPOXEmfDiagnosticException(Diagnostic diag) {
        super(diag.getMessage());
        this.diagnostic = diag;
        JPOXEmfDiagnosticException.logDiagnostic(diag);
    }

    public Diagnostic getDiagnostic() {
        return this.diagnostic;
    }
}

