/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeRunnableImpl;
import org.eclipse.emf.compare.internal.merge.MergeDataImpl;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.DiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.framework.AbstractInputData;
import org.eclipse.emf.compare.tests.nodes.Node;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBug434828 {
    private IMerger.Registry mergerRegistry;
    private DefaultComparisonScope scope;
    private Diff deletedNodeDeletionDiff;
    private Diff holdingRefDeletionDiff;
    private Diff refChangeDiff;

    @Before
    public void setUp() throws IOException {
        Bug434828InputData inputData = new Bug434828InputData();
        Resource left = inputData.getResource("left.nodes");
        Resource right = inputData.getResource("right.nodes");
        Resource origin = inputData.getResource("origin.nodes");
        this.scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)this.scope);
        comparison.eAdapters().add((Object)new MergeDataImpl(true, false));
        this.mergerRegistry = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Conflict conflict = (Conflict)conflicts.get(0);
        EList leftConflicts = conflict.getLeftDifferences();
        Assert.assertEquals((long)2L, (long)leftConflicts.size());
        this.refChangeDiff = (Diff)leftConflicts.get(0);
        EList rightConflicts = conflict.getRightDifferences();
        Assert.assertEquals((long)1L, (long)rightConflicts.size());
        this.holdingRefDeletionDiff = (Diff)rightConflicts.get(0);
        EList rightRequiredBy = this.holdingRefDeletionDiff.getRequiredBy();
        Assert.assertEquals((long)1L, (long)rightRequiredBy.size());
        this.deletedNodeDeletionDiff = (Diff)rightRequiredBy.get(0);
    }

    @Test
    public void testAcceptConflictDiffWithConflictingDiffWithRequiredBy() {
        MergeRunnableImpl mergeRunnable = new MergeRunnableImpl(true, false, MergeMode.ACCEPT, (IDiffRelationshipComputer)new DiffRelationshipComputer(this.mergerRegistry));
        mergeRunnable.merge(Collections.singletonList(this.refChangeDiff), false, this.mergerRegistry);
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)this.refChangeDiff.getState());
        Assert.assertEquals((Object)MergeMode.ACCEPT, (Object)MergeMode.getMergeMode((Diff)this.refChangeDiff, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)this.holdingRefDeletionDiff.getState());
        Assert.assertEquals((Object)MergeMode.REJECT, (Object)MergeMode.getMergeMode((Diff)this.holdingRefDeletionDiff, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)this.deletedNodeDeletionDiff.getState());
        Assert.assertEquals((Object)MergeMode.REJECT, (Object)MergeMode.getMergeMode((Diff)this.deletedNodeDeletionDiff, (boolean)true, (boolean)false));
        Resource leftResource = (Resource)this.scope.getLeft();
        EList content = leftResource.getContents();
        Assert.assertEquals((long)1L, (long)content.size());
        Node root = (Node)content.get(0);
        EList children = root.getContainmentRef1();
        Assert.assertEquals((long)2L, (long)children.size());
        Node firstChildren = (Node)children.get(0);
        Assert.assertEquals((long)1L, (long)firstChildren.getContainmentRef1().size());
    }

    @Test
    public void testAcceptConflictDiffWithConflictingDiffWithRequiredByProg() {
        new BatchMerger(this.mergerRegistry).copyAllLeftToRight(Arrays.asList(this.refChangeDiff), (Monitor)new BasicMonitor());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)this.refChangeDiff.getState());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)this.holdingRefDeletionDiff.getState());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)this.deletedNodeDeletionDiff.getState());
        Resource leftResource = (Resource)this.scope.getLeft();
        EList content = leftResource.getContents();
        Assert.assertEquals((long)1L, (long)content.size());
        Node root = (Node)content.get(0);
        EList children = root.getContainmentRef1();
        Assert.assertEquals((long)2L, (long)children.size());
        Node firstChildren = (Node)children.get(0);
        Assert.assertEquals((long)1L, (long)firstChildren.getContainmentRef1().size());
    }

    public class Bug434828InputData
    extends AbstractInputData {
        private static final String PATH_PREFIX = "data/_434828/";

        public Resource getResource(String resourceName) throws IOException {
            StringBuilder resourceURL = new StringBuilder(PATH_PREFIX);
            resourceURL.append(resourceName);
            return this.loadFromClassLoader(resourceURL.toString());
        }
    }
}

