/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.restclient.java;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;
import org.eclipse.lsp4mp.jdt.core.utils.PositionUtils;
import org.eclipse.lsp4mp.jdt.internal.restclient.MicroProfileRestClientErrorCode;

public class MicroProfileRestClientDiagnosticsParticipant
implements IJavaDiagnosticsParticipant {
    @Override
    public boolean isAdaptedForDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = context.getJavaProject();
        return JDTTypeUtils.findType(javaProject, "org.eclipse.microprofile.rest.client.inject.RestClient") != null;
    }

    @Override
    public List<Diagnostic> collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        ITypeRoot typeRoot = context.getTypeRoot();
        IJavaElement[] elements = typeRoot.getChildren();
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        MicroProfileRestClientDiagnosticsParticipant.collectDiagnostics(elements, diagnostics, context, monitor);
        return diagnostics;
    }

    private static void collectDiagnostics(IJavaElement[] elements, List<Diagnostic> diagnostics, JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (element.getElementType() == 7) {
                IType type = (IType)element;
                if (type.isInterface()) {
                    MicroProfileRestClientDiagnosticsParticipant.validateInterfaceType(type, diagnostics, context, monitor);
                } else {
                    MicroProfileRestClientDiagnosticsParticipant.validateClassType(type, diagnostics, context, monitor);
                }
            }
            ++n2;
        }
    }

    private static void validateClassType(IType classType, List<Diagnostic> diagnostics, JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IJavaElement[] iJavaElementArray = classType.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (element.getElementType() == 8) {
                IField field = (IField)element;
                MicroProfileRestClientDiagnosticsParticipant.validateField(field, diagnostics, context);
            }
            ++n2;
        }
    }

    private static void validateField(IField field, List<Diagnostic> diagnostics, JavaDiagnosticsContext context) throws CoreException {
        boolean hasRegisterRestClient;
        String uri = context.getUri();
        DocumentFormat documentFormat = context.getDocumentFormat();
        boolean hasInjectAnnotation = AnnotationUtils.hasAnnotation((IAnnotatable)field, "javax.inject.Inject");
        boolean hasRestClientAnnotation = AnnotationUtils.hasAnnotation((IAnnotatable)field, "org.eclipse.microprofile.rest.client.inject.RestClient");
        String fieldTypeName = JDTTypeUtils.getResolvedTypeName(field);
        IType fieldType = JDTTypeUtils.findType(field.getJavaProject(), fieldTypeName);
        boolean bl = hasRegisterRestClient = AnnotationUtils.hasAnnotation((IAnnotatable)fieldType, "org.eclipse.microprofile.rest.client.inject.RegisterRestClient") && fieldType.isInterface();
        if (!hasRegisterRestClient) {
            if (hasInjectAnnotation && hasRestClientAnnotation) {
                Range restClientRange = PositionUtils.toNameRange(field, context.getUtils());
                Diagnostic d = context.createDiagnostic(uri, MicroProfileRestClientDiagnosticsParticipant.createDiagnostic1Message(field, fieldTypeName, documentFormat), restClientRange, "microprofile-restclient", null);
                diagnostics.add(d);
            }
        } else if (hasInjectAnnotation && !hasRestClientAnnotation) {
            Range restClientRange = PositionUtils.toNameRange(field, context.getUtils());
            Diagnostic d = context.createDiagnostic(uri, "The Rest Client object should have the @RestClient annotation to be injected as a CDI bean.", restClientRange, "microprofile-restclient", MicroProfileRestClientErrorCode.RestClientAnnotationMissing);
            diagnostics.add(d);
        } else if (!hasInjectAnnotation && hasRestClientAnnotation) {
            Range restClientRange = PositionUtils.toNameRange(field, context.getUtils());
            Diagnostic d = context.createDiagnostic(uri, "The Rest Client object should have the @Inject annotation to be injected as a CDI bean.", restClientRange, "microprofile-restclient", MicroProfileRestClientErrorCode.InjectAnnotationMissing);
            diagnostics.add(d);
        } else if (!hasInjectAnnotation && !hasRestClientAnnotation) {
            Range restClientRange = PositionUtils.toNameRange(field, context.getUtils());
            Diagnostic d = context.createDiagnostic(uri, "The Rest Client object should have the @Inject and @RestClient annotations to be injected as a CDI bean.", restClientRange, "microprofile-restclient", MicroProfileRestClientErrorCode.InjectAndRestClientAnnotationMissing);
            diagnostics.add(d);
        }
    }

    private static String createDiagnostic1Message(IField field, String fieldTypeName, DocumentFormat documentFormat) {
        StringBuilder message = new StringBuilder("The corresponding ");
        if (DocumentFormat.Markdown.equals((Object)documentFormat)) {
            message.append("`");
        }
        message.append(fieldTypeName);
        if (DocumentFormat.Markdown.equals((Object)documentFormat)) {
            message.append("`");
        }
        message.append(" interface does not have the @RegisterRestClient annotation. The field ");
        if (DocumentFormat.Markdown.equals((Object)documentFormat)) {
            message.append("`");
        }
        message.append(field.getElementName());
        if (DocumentFormat.Markdown.equals((Object)documentFormat)) {
            message.append("`");
        }
        message.append(" will not be injected as a CDI bean.");
        return message.toString();
    }

    private static void validateInterfaceType(IType interfaceType, List<Diagnostic> diagnostics, JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        boolean hasRegisterRestClient = AnnotationUtils.hasAnnotation((IAnnotatable)interfaceType, "org.eclipse.microprofile.rest.client.inject.RegisterRestClient");
        if (hasRegisterRestClient) {
            return;
        }
        final AtomicInteger nbReferences = new AtomicInteger(0);
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)interfaceType, (int)2);
        SearchEngine engine = new SearchEngine();
        engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, MicroProfileRestClientDiagnosticsParticipant.createSearchScope(interfaceType.getJavaProject()), new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object o = match.getElement();
                if (o instanceof IField) {
                    this.validateReferenceField((IField)o);
                }
            }

            private void validateReferenceField(IField field) throws CoreException {
                boolean hasInjectAnnotation = AnnotationUtils.hasAnnotation((IAnnotatable)field, "javax.inject.Inject");
                boolean hasRestClientAnnotation = AnnotationUtils.hasAnnotation((IAnnotatable)field, "org.eclipse.microprofile.rest.client.inject.RestClient");
                if (hasInjectAnnotation && hasRestClientAnnotation) {
                    nbReferences.incrementAndGet();
                }
            }
        }, monitor);
        if (nbReferences.get() > 0) {
            String uri = context.getUri();
            Range restInterfaceRange = PositionUtils.toNameRange(interfaceType, context.getUtils());
            Diagnostic d = context.createDiagnostic(uri, "The interface `" + interfaceType.getElementName() + "` does not have the @RegisterRestClient annotation. The " + nbReferences.get() + " fields references will not be injected as CDI beans.", restInterfaceRange, "microprofile-restclient", MicroProfileRestClientErrorCode.RegisterRestClientAnnotationMissing);
            diagnostics.add(d);
        }
    }

    private static IJavaSearchScope createSearchScope(IJavaProject javaProject) throws CoreException {
        return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{javaProject}, (int)1);
    }
}

