/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.cdi;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.utils.PositionUtils;
import org.eclipse.lsp4jakarta.jdt.internal.DiagnosticUtils;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;
import org.eclipse.lsp4jakarta.jdt.internal.cdi.Constants;
import org.eclipse.lsp4jakarta.jdt.internal.cdi.ErrorCode;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;

public class ManagedBeanDiagnosticsParticipant
implements IJavaDiagnosticsParticipant {
    @Override
    public List<Diagnostic> collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IJDTUtils utils = JDTUtilsLSImpl.getInstance();
        String uri = context.getUri();
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (unit == null) {
            return diagnostics;
        }
        IType[] types = unit.getAllTypes();
        String[] scopeFQNames = (String[])Constants.SCOPE_FQ_NAMES.toArray(String[]::new);
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            int isProducerMethod;
            Range range;
            Object[] annotationNames;
            int fieldFlags;
            IField[] fields;
            boolean isManagedBean;
            IType type = iTypeArray[n2];
            List<String> managedBeanAnnotations = DiagnosticUtils.getMatchedJavaElementNames(type, (String[])Stream.of(type.getAnnotations()).map(annotation -> annotation.getElementName()).toArray(String[]::new), scopeFQNames);
            boolean bl = isManagedBean = managedBeanAnnotations.size() > 0;
            if (managedBeanAnnotations.size() > 1) {
                List diagnosticData = managedBeanAnnotations.stream().map(annotation -> DiagnosticUtils.getSimpleName(annotation)).collect(Collectors.toList());
                Range range2 = PositionUtils.toNameRange(type, context.getUtils());
                diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ScopeTypeAnnotationsManagedBean", new Object[0]), range2, "jakarta-cdi", new Gson().toJsonTree(diagnosticData), ErrorCode.InvalidNumberOfScopedAnnotationsByManagedBean, DiagnosticSeverity.Error));
            }
            String[] injectAnnotations = new String[]{"jakarta.enterprise.inject.Produces", "jakarta.inject.Inject"};
            IField[] iFieldArray = fields = type.getFields();
            int n3 = fields.length;
            int n4 = 0;
            while (n4 < n3) {
                IField field = iFieldArray[n4];
                fieldFlags = field.getFlags();
                annotationNames = (String[])Stream.of(field.getAnnotations()).map(annotation -> annotation.getElementName()).toArray(String[]::new);
                List<String> fieldScopes = DiagnosticUtils.getMatchedJavaElementNames(type, (String[])annotationNames, scopeFQNames);
                if (isManagedBean && Flags.isPublic((int)fieldFlags) && !Flags.isStatic((int)fieldFlags) && !managedBeanAnnotations.contains("jakarta.enterprise.context.Dependent")) {
                    Range range3 = PositionUtils.toNameRange(field, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ManagedBeanWithNonStaticPublicField", new Object[0]), range3, "jakarta-cdi", null, ErrorCode.InvalidManagedBeanWithNonStaticPublicField, DiagnosticSeverity.Error));
                }
                List<String> fieldInjects = DiagnosticUtils.getMatchedJavaElementNames(type, (String[])annotationNames, injectAnnotations);
                boolean isProducerField = false;
                boolean isInjectField = false;
                for (String annotation2 : fieldInjects) {
                    if ("jakarta.enterprise.inject.Produces".equals(annotation2)) {
                        isProducerField = true;
                        continue;
                    }
                    if (!"jakarta.inject.Inject".equals(annotation2)) continue;
                    isInjectField = true;
                }
                if (isProducerField && fieldScopes.size() > 1) {
                    List diagnosticData = fieldScopes.stream().map(annotation -> DiagnosticUtils.getSimpleName(annotation)).collect(Collectors.toList());
                    diagnosticData.add("Produces");
                    range = PositionUtils.toNameRange(field, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ScopeTypeAnnotationsProducerField", new Object[0]), range, "jakarta-cdi", new Gson().toJsonTree(diagnosticData), ErrorCode.InvalidNumberOfScopeAnnotationsByProducerField, DiagnosticSeverity.Error));
                }
                if (isProducerField && isInjectField) {
                    Range range4 = PositionUtils.toNameRange(field, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ManagedBeanProducesAndInjectField", new Object[0]), range4, "jakarta-cdi", null, ErrorCode.InvalidFieldWithProducesAndInjectAnnotations, DiagnosticSeverity.Error));
                }
                ++n4;
            }
            IMethod[] methods = type.getMethods();
            ArrayList<IMethod> constructorMethods = new ArrayList<IMethod>();
            annotationNames = methods;
            fieldFlags = methods.length;
            int n5 = 0;
            while (n5 < fieldFlags) {
                IMethod method = annotationNames[n5];
                if (DiagnosticUtils.isConstructorMethod(method)) {
                    constructorMethods.add(method);
                }
                String[] annotationNames2 = (String[])Stream.of(method.getAnnotations()).map(annotation -> annotation.getElementName()).toArray(String[]::new);
                List<String> methodScopes = DiagnosticUtils.getMatchedJavaElementNames(type, annotationNames2, scopeFQNames);
                List<String> methodInjects = DiagnosticUtils.getMatchedJavaElementNames(type, annotationNames2, injectAnnotations);
                isProducerMethod = 0;
                boolean isInjectMethod = false;
                for (String annotation3 : methodInjects) {
                    if ("jakarta.enterprise.inject.Produces".equals(annotation3)) {
                        isProducerMethod = 1;
                        continue;
                    }
                    if (!"jakarta.inject.Inject".equals(annotation3)) continue;
                    isInjectMethod = true;
                }
                if (isProducerMethod != 0 && methodScopes.size() > 1) {
                    List diagnosticData = methodScopes.stream().map(annotation -> DiagnosticUtils.getSimpleName(annotation)).collect(Collectors.toList());
                    diagnosticData.add("Produces");
                    Range range5 = PositionUtils.toNameRange(method, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ScopeTypeAnnotationsProducerMethod", new Object[0]), range5, "jakarta-cdi", new Gson().toJsonTree(diagnosticData), ErrorCode.InvalidNumberOfScopeAnnotationsByProducerMethod, DiagnosticSeverity.Error));
                }
                if (isProducerMethod != 0 && isInjectMethod) {
                    range = PositionUtils.toNameRange(method, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ManagedBeanProducesAndInjectMethod", new Object[0]), range, "jakarta-cdi", null, ErrorCode.InvalidMethodWithProducesAndInjectAnnotations, DiagnosticSeverity.Error));
                }
                ++n5;
            }
            if (isManagedBean && constructorMethods.size() > 0) {
                ArrayList<IMethod> methodsNeedingDiagnostics = new ArrayList<IMethod>();
                for (IMethod m : constructorMethods) {
                    if (m.getNumberOfParameters() == 0) {
                        methodsNeedingDiagnostics.clear();
                        break;
                    }
                    IAnnotation[] annotations = m.getAnnotations();
                    boolean hasParameterizedInjectConstructor = false;
                    IAnnotation[] iAnnotationArray = annotations;
                    isProducerMethod = annotations.length;
                    int methodInjects = 0;
                    while (methodInjects < isProducerMethod) {
                        IAnnotation annotation4 = iAnnotationArray[methodInjects];
                        if (DiagnosticUtils.isMatchedJavaElement(type, annotation4.getElementName(), "jakarta.inject.Inject")) {
                            hasParameterizedInjectConstructor = true;
                            break;
                        }
                        ++methodInjects;
                    }
                    if (hasParameterizedInjectConstructor) {
                        methodsNeedingDiagnostics.clear();
                        break;
                    }
                    methodsNeedingDiagnostics.add(m);
                }
                for (IMethod m : methodsNeedingDiagnostics) {
                    Range range6 = PositionUtils.toNameRange(m, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ManagedBeanConstructorWithParameters", new Object[0]), range6, "jakarta-cdi", null, ErrorCode.InvalidManagedBeanWithInvalidConstructor, DiagnosticSeverity.Error));
                }
            }
            if (isManagedBean) {
                boolean isClassGeneric = type.getTypeParameters().length != 0;
                boolean isDependent = managedBeanAnnotations.stream().anyMatch(annotation -> "jakarta.enterprise.context.Dependent".equals(annotation));
                if (isClassGeneric && !isDependent) {
                    Range range7 = PositionUtils.toNameRange(type, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ManagedBeanGenericType", new Object[0]), range7, "jakarta-cdi", null, ErrorCode.InvalidGenericManagedBeanClassWithNoDependentScope, DiagnosticSeverity.Error));
                }
            }
            this.invalidParamsCheck(context, uri, unit, diagnostics, type, "jakarta.inject.Inject");
            if (isManagedBean) {
                this.invalidParamsCheck(context, uri, unit, diagnostics, type, "jakarta.enterprise.inject.Produces");
                IMethod[] iMethodArray = methods;
                int n6 = methods.length;
                int n7 = 0;
                while (n7 < n6) {
                    ILocalVariable[] params;
                    IMethod method = iMethodArray[n7];
                    int numDisposes = 0;
                    TreeSet<String> invalidAnnotations = new TreeSet<String>();
                    ILocalVariable[] iLocalVariableArray = params = method.getParameters();
                    int n8 = params.length;
                    int n9 = 0;
                    while (n9 < n8) {
                        IAnnotation[] annotations;
                        ILocalVariable param = iLocalVariableArray[n9];
                        IAnnotation[] iAnnotationArray = annotations = param.getAnnotations();
                        int n10 = annotations.length;
                        int n11 = 0;
                        while (n11 < n10) {
                            IAnnotation annotation5 = iAnnotationArray[n11];
                            String matchedAnnotation = DiagnosticUtils.getMatchedJavaElementName(type, annotation5.getElementName(), Constants.INVALID_PRODUCER_PARAMS_FQ);
                            if ("jakarta.enterprise.inject.Disposes".equals(matchedAnnotation)) {
                                ++numDisposes;
                            } else if ("jakarta.enterprise.event.Observes".equals(matchedAnnotation) || "jakarta.enterprise.event.ObservesAsync".equals(matchedAnnotation)) {
                                invalidAnnotations.add("@" + annotation5.getElementName());
                            }
                            ++n11;
                        }
                        ++n9;
                    }
                    if (numDisposes != 0) {
                        if (numDisposes > 1) {
                            Range range8 = PositionUtils.toNameRange(method, context.getUtils());
                            diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ManagedBeanDisposeOneParameter", new Object[0]), range8, "jakarta-cdi", null, ErrorCode.InvalidDisposesAnnotationOnMultipleMethodParams, DiagnosticSeverity.Error));
                        }
                        if (!invalidAnnotations.isEmpty()) {
                            Range range9 = PositionUtils.toNameRange(method, context.getUtils());
                            diagnostics.add(context.createDiagnostic(uri, this.createInvalidDisposesLabel(invalidAnnotations), range9, "jakarta-cdi", null, ErrorCode.InvalidDisposerMethodParamAnnotation, DiagnosticSeverity.Error));
                        }
                    }
                    ++n7;
                }
            }
            ++n2;
        }
        return diagnostics;
    }

    private void invalidParamsCheck(JavaDiagnosticsContext context, String uri, ICompilationUnit unit, List<Diagnostic> diagnostics, IType type, String target) throws JavaModelException {
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            IAnnotation targetAnnotation = null;
            IAnnotation[] iAnnotationArray = method.getAnnotations();
            int n3 = iAnnotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IAnnotation annotation2 = iAnnotationArray[n4];
                if (DiagnosticUtils.isMatchedJavaElement(type, annotation2.getElementName(), target)) {
                    targetAnnotation = annotation2;
                    break;
                }
                ++n4;
            }
            if (targetAnnotation != null) {
                ILocalVariable[] params;
                TreeSet<String> invalidAnnotations = new TreeSet<String>();
                ILocalVariable[] iLocalVariableArray = params = method.getParameters();
                int n5 = params.length;
                int n6 = 0;
                while (n6 < n5) {
                    ILocalVariable param = iLocalVariableArray[n6];
                    List<String> paramScopes = "jakarta.enterprise.inject.Produces".equals(target) ? DiagnosticUtils.getMatchedJavaElementNames(type, (String[])Stream.of(param.getAnnotations()).map(annotation -> annotation.getElementName()).toArray(String[]::new), Constants.INVALID_PRODUCER_PARAMS_FQ) : DiagnosticUtils.getMatchedJavaElementNames(type, (String[])Stream.of(param.getAnnotations()).map(annotation -> annotation.getElementName()).toArray(String[]::new), Constants.INVALID_INITIALIZER_PARAMS_FQ);
                    for (String annotation3 : paramScopes) {
                        invalidAnnotations.add("@" + DiagnosticUtils.getSimpleName(annotation3));
                    }
                    ++n6;
                }
                if (!invalidAnnotations.isEmpty()) {
                    Range range = PositionUtils.toNameRange(method, context.getUtils());
                    if ("jakarta.enterprise.inject.Produces".equals(target)) {
                        diagnostics.add(context.createDiagnostic(uri, this.createInvalidProducesLabel(invalidAnnotations), range, "jakarta-cdi", null, ErrorCode.InvalidProducerMethodParamAnnotation, DiagnosticSeverity.Error));
                    } else {
                        diagnostics.add(context.createDiagnostic(uri, this.createInvalidInjectLabel(invalidAnnotations), range, "jakarta-cdi", null, ErrorCode.InvalidInjectAnnotatedMethodParamAnnotation, DiagnosticSeverity.Error));
                    }
                }
            }
            ++n2;
        }
    }

    private String createInvalidInjectLabel(Set<String> invalidAnnotations) {
        return Messages.getMessage("ManagedBeanInvalidInject", String.join((CharSequence)", ", invalidAnnotations));
    }

    private String createInvalidProducesLabel(Set<String> invalidAnnotations) {
        return Messages.getMessage("ManagedBeanInvalidProduces", String.join((CharSequence)", ", invalidAnnotations));
    }

    private String createInvalidDisposesLabel(Set<String> invalidAnnotations) {
        return Messages.getMessage("ManagedBeanInvalidDisposer", String.join((CharSequence)", ", invalidAnnotations));
    }
}

