/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.generators.FileContentGeneratorManager;
import org.eclipse.lemminx.extensions.generators.FileContentGeneratorSettings;
import org.eclipse.lemminx.services.extensions.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.IComponentProvider;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;

public abstract class AbstractFixMissingGrammarCodeAction
implements ICodeActionParticipant {
    private static final String FILE_SCHEME = "'file:///";

    @Override
    public void doCodeAction(Diagnostic diagnostic, Range range, DOMDocument document, List<CodeAction> codeActions, SharedSettings sharedSettings, IComponentProvider componentProvider) {
        String missingFilePath = this.getPathFromDiagnostic(diagnostic);
        if (StringUtils.isEmpty(missingFilePath)) {
            return;
        }
        Path p = Paths.get(missingFilePath, new String[0]);
        if (p.toFile().exists()) {
            return;
        }
        FileContentGeneratorManager generator = (FileContentGeneratorManager)componentProvider.getComponent(FileContentGeneratorManager.class);
        String schemaTemplate = generator.generate(document, sharedSettings, this.getFileContentGeneratorSettings());
        CodeAction makeSchemaFile = CodeActionFactory.createFile("Generate missing file '" + p.toFile().getName() + "'", "file:///" + missingFilePath, schemaTemplate, diagnostic);
        codeActions.add(makeSchemaFile);
    }

    private String getPathFromDiagnostic(Diagnostic diagnostic) {
        String message = diagnostic.getMessage();
        int startIndex = message.indexOf(FILE_SCHEME);
        if (startIndex != -1) {
            int endIndex = message.indexOf("'", startIndex + 1);
            return message.substring(startIndex + FILE_SCHEME.length(), endIndex);
        }
        return null;
    }

    protected abstract FileContentGeneratorSettings getFileContentGeneratorSettings();
}

