/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.util.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.kura.util.validation.PredicateValidator;
import org.eclipse.kura.util.validation.RegexValidator;
import org.eclipse.kura.util.validation.Validator;
import org.eclipse.kura.util.validation.ValidatorOptions;

public class PasswordStrengthValidators {
    private static final String CONTAINS_DIGITS = ".*\\d.*";
    private static final String CONTAINS_NOT_ALPHANUMERIC = ".*[^a-zA-Z0-9].*";
    private static final String LOWERCASE = ".*[a-z].*";
    private static final String UPPERCASE = ".*[A-Z].*";

    private PasswordStrengthValidators() {
    }

    public static List<Validator<String>> fromConfig(ValidatorOptions userOptions) {
        return PasswordStrengthValidators.fromConfig(userOptions, new DefaultMessages());
    }

    public static List<Validator<String>> fromConfig(ValidatorOptions userOptions, Messages messages) {
        ArrayList<Validator<String>> result = new ArrayList<Validator<String>>();
        int minPasswordLength = userOptions.isPasswordMinimumLength();
        if (minPasswordLength > 0) {
            result.add(PasswordStrengthValidators.passwordLengthValidator(minPasswordLength, messages));
        }
        if (userOptions.isPasswordRequireDigits()) {
            result.add(PasswordStrengthValidators.containsDigitsValidator(messages));
        }
        if (userOptions.isPasswordRequireBothCases()) {
            result.add(PasswordStrengthValidators.containsBothCases(messages));
        }
        if (userOptions.isPasswordRequireSpecialChars()) {
            result.add(PasswordStrengthValidators.containsSpecialChars(messages));
        }
        return result;
    }

    private static Validator<String> passwordLengthValidator(int minPasswordLength, Messages messages) {
        return new PredicateValidator(v -> {
            int passwordLength;
            int n2 = passwordLength = v == null ? 0 : v.length();
            return passwordLength >= minPasswordLength;
        }, messages.pwdStrengthMinLength(minPasswordLength));
    }

    private static Validator<String> containsDigitsValidator(Messages messages) {
        return new RegexValidator(CONTAINS_DIGITS, messages.pwdStrengthDigitsRequired()){};
    }

    private static Validator<String> containsSpecialChars(Messages messages) {
        return new RegexValidator(CONTAINS_NOT_ALPHANUMERIC, messages.pwdStrengthNonAlphanumericRequired()){};
    }

    private static Validator<String> containsBothCases(Messages messages) {
        RegexValidator containsLowercase = new RegexValidator(LOWERCASE, messages.pwdStrengthBothCasesRequired());
        RegexValidator containsUppercase = new RegexValidator(UPPERCASE, messages.pwdStrengthBothCasesRequired());
        return (v, c) -> {
            containsLowercase.validate((String)v, (Consumer<String>)c);
            containsUppercase.validate((String)v, (Consumer<String>)c);
        };
    }

    private static class DefaultMessages
    implements Messages {
        private DefaultMessages() {
        }

        @Override
        public String pwdStrengthDigitsRequired() {
            return "Password must contain at least one digit";
        }

        @Override
        public String pwdStrengthNonAlphanumericRequired() {
            return "Password must contain at least one non alphanumeric character";
        }

        @Override
        public String pwdStrengthBothCasesRequired() {
            return "Password must contain both uppercase and lowercase characters";
        }

        @Override
        public String pwdStrengthMinLength(int value) {
            return "Password length must be at least " + value + " characters";
        }
    }

    public static interface Messages {
        public String pwdStrengthDigitsRequired();

        public String pwdStrengthNonAlphanumericRequired();

        public String pwdStrengthBothCasesRequired();

        public String pwdStrengthMinLength(int var1);
    }
}

