/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.db.filter;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.db.BaseDbService;
import org.eclipse.kura.db.H2DbService;
import org.eclipse.kura.internal.wire.db.common.BaseDbServiceProviderImpl;
import org.eclipse.kura.internal.wire.db.common.DbServiceProvider;
import org.eclipse.kura.internal.wire.db.common.H2DbServiceProviderImpl;
import org.eclipse.kura.internal.wire.db.filter.DbWireRecordFilterOptions;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEmitter;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireReceiver;
import org.eclipse.kura.wire.WireRecord;
import org.eclipse.kura.wire.WireSupport;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.wireadmin.Wire;

public class DbWireRecordFilter
implements WireEmitter,
WireReceiver,
ConfigurableComponent {
    private static final Logger logger = LogManager.getLogger(DbWireRecordFilter.class);
    private DbServiceProvider dbServiceProvider;
    private List<WireRecord> lastRecords;
    private BaseDbService dbService;
    private DbWireRecordFilterOptions options;
    private WireHelperService wireHelperService;
    private WireSupport wireSupport;
    private Calendar lastRefreshedTime;
    private int cacheExpirationInterval;

    public synchronized void bindDbService(BaseDbService dbService) {
        this.dbService = dbService;
        this.dbServiceProvider = this.dbService instanceof H2DbService ? new H2DbServiceProviderImpl((H2DbService)this.dbService) : new BaseDbServiceProviderImpl(this.dbService);
    }

    public synchronized void unbindDbService(BaseDbService dbService) {
        if (this.dbService == dbService) {
            this.dbServiceProvider = null;
            this.dbService = null;
            this.options = null;
        }
    }

    public void bindWireHelperService(WireHelperService wireHelperService) {
        if (Objects.isNull(this.wireHelperService)) {
            this.wireHelperService = wireHelperService;
        }
    }

    public void unbindWireHelperService(WireHelperService wireHelperService) {
        if (this.wireHelperService == wireHelperService) {
            this.wireHelperService = null;
        }
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.debug("Activating DB Wire Record Filter...");
        this.options = new DbWireRecordFilterOptions(properties);
        this.wireSupport = this.wireHelperService.newWireSupport((WireComponent)this, componentContext.getServiceReference());
        this.cacheExpirationInterval = this.options.getCacheExpirationInterval();
        this.lastRefreshedTime = Calendar.getInstance();
        this.lastRefreshedTime.add(13, -this.cacheExpirationInterval);
        logger.debug("Activating DB Wire Record Filter... Done");
    }

    public void updated(Map<String, Object> properties) {
        logger.debug("Updating DB Wire Record Filter... {}", properties);
        String oldSqlView = this.options.getSqlView();
        this.options = new DbWireRecordFilterOptions(properties);
        this.cacheExpirationInterval = this.options.getCacheExpirationInterval();
        this.lastRefreshedTime = Calendar.getInstance();
        this.lastRefreshedTime.add(13, -this.cacheExpirationInterval);
        if (!oldSqlView.equals(this.options.getSqlView())) {
            this.lastRecords = null;
        }
        logger.debug("Updating DB Wire Record Filter... Done");
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.debug("Dectivating DB Wire Record Filter...");
        this.dbServiceProvider = null;
        this.dbService = null;
        this.options = null;
        logger.debug("Dectivating DB Wire Record Filter... Done");
    }

    public void consumersConnected(Wire[] wires) {
        this.wireSupport.consumersConnected(wires);
    }

    private List<WireRecord> performSQLQuery() throws SQLException {
        String sqlView = this.options.getSqlView();
        return this.dbServiceProvider.performSQLQuery(sqlView);
    }

    public synchronized void onWireReceive(WireEnvelope wireEnvelope) {
        List<Object> result;
        Objects.requireNonNull(wireEnvelope, "Wire Envelope cannot be null");
        if (this.dbServiceProvider == null) {
            logger.warn("DbService instance not attached");
            return;
        }
        if (this.isCacheExpired()) {
            this.refreshCachedRecords();
        }
        if (!(result = Objects.nonNull(this.lastRecords) ? Collections.unmodifiableList(this.lastRecords) : Collections.unmodifiableList(new ArrayList())).isEmpty() || this.options.emitOnEmptyResult()) {
            this.wireSupport.emit(result);
        }
    }

    private void refreshCachedRecords() {
        try {
            List<WireRecord> tmpWireRecords = this.performSQLQuery();
            this.lastRecords = tmpWireRecords;
            this.lastRefreshedTime = Calendar.getInstance(this.lastRefreshedTime.getTimeZone());
        }
        catch (SQLException e) {
            logger.error("Error while filtering Wire Records...", (Throwable)e);
        }
    }

    public Object polled(Wire wire) {
        return this.wireSupport.polled(wire);
    }

    public void producersConnected(Wire[] wires) {
        this.wireSupport.producersConnected(wires);
    }

    public void updated(Wire wire, Object value) {
        this.wireSupport.updated(wire, value);
    }

    private boolean isCacheExpired() {
        Calendar now = Calendar.getInstance();
        Calendar nextRefreshTime = Calendar.getInstance(this.lastRefreshedTime.getTimeZone());
        nextRefreshTime.setTime(this.lastRefreshedTime.getTime());
        nextRefreshTime.add(13, this.cacheExpirationInterval);
        return !nextRefreshTime.after(now);
    }
}

