/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.report.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.report.model.LogEntry;
import org.polarsys.kitalpha.report.model.ReportList;
import org.polarsys.kitalpha.report.registry.ReportRegistry;
import org.polarsys.kitalpha.report.ui.Activator;
import org.polarsys.kitalpha.report.ui.description.ReportsUI;
import org.polarsys.kitalpha.report.ui.views.FileAction;
import org.polarsys.kitalpha.report.ui.views.ReportsView;

public class LoadReportListAction
extends FileAction {
    public static final String LOADED_REPORT_LIST = "loaded.report.list";

    public LoadReportListAction(ReportsView view) {
        super(view);
        this.setToolTipText("Load reports from a file");
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/load.png"));
        this.setDisabledImageDescriptor(Activator.getDefault().getImageDescriptor("icons/load_disabled.png"));
    }

    @Override
    protected void doRun(String filename) throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createFileURI((String)filename);
        Resource resource = resourceSet.getResource(uri, true);
        resource.load(Collections.emptyMap());
        EcoreUtil.resolveAll((Resource)resource);
        ReportList list = ReportRegistry.INSTANCE.getList(LOADED_REPORT_LIST);
        for (EObject object : new ArrayList(resource.getContents())) {
            if (!(object instanceof LogEntry)) continue;
            LogEntry entry = (LogEntry)object;
            list.getReports().add((Object)entry);
        }
        resource.unload();
        ReportsUI.showList(list);
    }

    @Override
    protected int getDialogStyle() {
        return 4096;
    }
}

