/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.generators.actions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.validation.IConcreteSyntaxValidator;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.VpdescFactory;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.generator.IViewpointSynchronizer;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.resources.ResourceHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.generators.Messages;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.generators.internal.Activator;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.generators.setup.BackwardSynchronizerSetup;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.generators.util.ReferenceUtil;

public class SynchronizerAction
extends BaseSelectionListenerAction
implements IObjectActionDelegate {
    private ISelection selection;
    @Inject
    private Injector injector;

    private Injector getInjector() {
        if (this.injector == null) {
            this.injector = new BackwardSynchronizerSetup().createInjectorAndDoEMFRegistration();
        }
        return this.injector;
    }

    public SynchronizerAction() {
        super(Messages.ViewpointDSLActions_BackwardSynchronizer_GeneratorMessage);
    }

    protected SynchronizerAction(String text) {
        super(text);
    }

    public void run(IAction action) {
        IStructuredSelection structuredSelection = (IStructuredSelection)this.selection;
        Object obj = structuredSelection.getFirstElement();
        IFile file = (IFile)Platform.getAdapterManager().getAdapter(obj, IFile.class);
        this.doSynchronize(file);
    }

    protected boolean doSynchronize(IFile file) {
        boolean result = false;
        XtextResourceSet resourceSet = (XtextResourceSet)this.getInjector().getInstance(XtextResourceSet.class);
        List loadedResources = ResourceHelper.validateAndloadResource((IFile)file, (ResourceSet)new ResourceSetImpl());
        if (loadedResources != null && !loadedResources.isEmpty()) {
            EObject textRoot = (EObject)loadedResources.get(0);
            if (textRoot != null) {
                EObject synchronizedObject;
                XtextResource resource = (XtextResource)textRoot.eResource();
                IResourceServiceProvider resourceServiceProvider = resource.getResourceServiceProvider();
                IViewpointSynchronizer generator = (IViewpointSynchronizer)resourceServiceProvider.get(IViewpointSynchronizer.class);
                String projectName = file.getProject().getName();
                Resource targetResource = this.loadTargetModel((ResourceSet)resourceSet, projectName);
                Viewpoint viewpoint = (Viewpoint)targetResource.getContents().get(0);
                List<EObject> inputObjects = this.loadInputModels(file, (ResourceSet)resourceSet);
                if (this.validate(inputObjects) && (synchronizedObject = generator.synchronize(inputObjects, (EObject)viewpoint)) != null) {
                    try {
                        HashMap<String, String> saveOptions = new HashMap<String, String>();
                        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
                        synchronizedObject.eResource().save(saveOptions);
                        result = true;
                    }
                    catch (IOException e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.generators", e.getMessage(), (Throwable)e));
                    }
                }
            }
            resourceSet.eSetDeliver(false);
            resourceSet.getResources().clear();
            resourceSet.eAdapters().clear();
        } else {
            String message = "Cannot generate Viewpoint dsl standalone resource from: " + file.getName() + ". One or more resources are invalidate";
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.generators", message));
        }
        return result;
    }

    protected Resource loadTargetModel(ResourceSet resourceSet, String projectName) {
        URI uri = ResourceHelper.getStandaloneResourceURI((String)projectName);
        boolean exists = resourceSet.getURIConverter().exists(uri, null);
        if (!exists || uri == null) {
            org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint viewpoint = (org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint)ResourceHelper.loadPrimaryResource((String)projectName, (ResourceSet)resourceSet).get(0);
            String shortName = viewpoint.getShortName().replaceAll("\"", "");
            uri = ResourceHelper.computeURI((String)projectName, (String)shortName, (String)"vpdesc");
            Resource resource = resourceSet.createResource(uri);
            Viewpoint target = VpdescFactory.eINSTANCE.createViewpoint();
            target.setShortName(shortName);
            target.setName(shortName);
            ReferenceUtil.setTargetReferences(viewpoint, target, resourceSet);
            resource.getContents().add((Object)target);
            return resource;
        }
        return resourceSet.getResource(uri, true);
    }

    private boolean validate(List<EObject> inputObjects) {
        for (EObject current : inputObjects) {
            if (this.validate(current)) continue;
            return false;
        }
        return true;
    }

    private boolean validate(EObject object) {
        ArrayList diagnostics = new ArrayList();
        IConcreteSyntaxValidator concreteSyntaxValidator = ((XtextResource)object.eResource()).getConcreteSyntaxValidator();
        concreteSyntaxValidator.validateRecursive(object, (IConcreteSyntaxValidator.IDiagnosticAcceptor)new IConcreteSyntaxValidator.DiagnosticListAcceptor(diagnostics), new HashMap());
        return diagnostics.isEmpty();
    }

    protected List<EObject> loadInputModels(IFile file, ResourceSet resourceSet) {
        Iterable<Object> inputModels = Collections.emptyList();
        inputModels = Iterables.concat(inputModels, (Iterable)ResourceHelper.validateAndLoadDataResource((IFile)file, (ResourceSet)resourceSet));
        inputModels = Iterables.concat(inputModels, (Iterable)ResourceHelper.validateAndLoadConfigurationResource((IFile)file, (ResourceSet)resourceSet));
        inputModels = Iterables.concat(inputModels, (Iterable)ResourceHelper.validateAndLoadUIResource((IFile)file, (ResourceSet)resourceSet));
        inputModels = Iterables.concat(inputModels, (Iterable)ResourceHelper.validateAndLoadDiagramResource((IFile)file, (ResourceSet)resourceSet));
        inputModels = Iterables.concat(inputModels, (Iterable)ResourceHelper.validateAndLoadBuildResource((IFile)file, (ResourceSet)resourceSet));
        inputModels = Iterables.concat(inputModels, (Iterable)ResourceHelper.validateAndLoadServicesResource((IFile)file, (ResourceSet)resourceSet));
        inputModels = Iterables.concat(inputModels, (Iterable)ResourceHelper.validateAndLoadActivityexplorerResource((IFile)file, (ResourceSet)resourceSet));
        return Lists.newArrayList(inputModels);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.selection = targetPart.getSite().getWorkbenchWindow().getSelectionService().getSelection();
    }
}

