/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.templates.SimpleTemplateVariableResolver;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.templates.AbstractTemplateVariableResolver;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContext;

public class CommonTemplateVariableResolver
extends AbstractTemplateVariableResolver {
    public static final String FILE_NAME = "fileName";
    public static final String FILE_NAME_DESCRIPTION = "File name";
    public static final String SHORT_NAME = "shortName";
    public static final String SHORT_NAME_DESCRIPTION = "Viewpoint short name";
    public static final String VIEWPOINT_NAME = "viewpointName";
    public static final String VIEWPOINT_NAME_DESCRIPTION = "Viewpoint Complete Name";

    public List<String> resolveValues(TemplateVariable variable, XtextTemplateContext xtextTemplateContext) {
        return null;
    }

    public static class FileName
    extends SimpleTemplateVariableResolver {
        public FileName() {
            super(CommonTemplateVariableResolver.FILE_NAME, CommonTemplateVariableResolver.FILE_NAME_DESCRIPTION);
        }

        protected String resolve(TemplateContext context) {
            XtextTemplateContext castedContext = (XtextTemplateContext)context;
            XtextDocument document = (XtextDocument)castedContext.getDocument();
            URI resourceURI = document.getResourceURI();
            if (resourceURI != null) {
                return resourceURI.trimFileExtension().lastSegment();
            }
            return CommonTemplateVariableResolver.FILE_NAME;
        }
    }

    public static class ShortName
    extends SimpleTemplateVariableResolver {
        public ShortName() {
            super(CommonTemplateVariableResolver.SHORT_NAME, CommonTemplateVariableResolver.SHORT_NAME_DESCRIPTION);
        }

        protected String resolve(TemplateContext context) {
            XtextTemplateContext castedContext = (XtextTemplateContext)context;
            XtextDocument document = (XtextDocument)castedContext.getDocument();
            URI uri = document.getResourceURI();
            if (uri != null) {
                String lastSegment = uri.trimFileExtension().lastSegment();
                return lastSegment != null ? lastSegment.substring(0, lastSegment.indexOf(46)) : null;
            }
            return CommonTemplateVariableResolver.SHORT_NAME;
        }
    }

    public static class ViewpointName
    extends SimpleTemplateVariableResolver {
        protected ViewpointName() {
            super(CommonTemplateVariableResolver.VIEWPOINT_NAME, CommonTemplateVariableResolver.VIEWPOINT_NAME_DESCRIPTION);
        }

        protected String resolve(TemplateContext context) {
            XtextTemplateContext castedContext = (XtextTemplateContext)context;
            XtextDocument document = (XtextDocument)castedContext.getDocument();
            URI resourceURI = document.getResourceURI();
            String fullyProjectName = resourceURI.segment(1);
            if (fullyProjectName != null && !fullyProjectName.isEmpty()) {
                return fullyProjectName.substring(0, fullyProjectName.lastIndexOf(46));
            }
            return CommonTemplateVariableResolver.VIEWPOINT_NAME;
        }
    }
}

