/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ecore.diagram.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class HideRevealToolsService {
    public Collection<EObject> computeAllReferencesToHide(EPackage element, DSemanticDiagram diagram) {
        return this.computeAllIReferences(element, diagram, true);
    }

    public Collection<EObject> computeAllReferencesToShow(EPackage element, DSemanticDiagram diagram) {
        return this.computeAllIReferences(element, diagram, false);
    }

    public Collection<EObject> computeAllIReferences(EPackage element, DSemanticDiagram diagram, boolean visible) {
        HashSet<EObject> result = new HashSet<EObject>();
        EList containers = diagram.getContainers();
        for (DDiagramElementContainer dDiagramElementContainer : containers) {
            if (!(dDiagramElementContainer instanceof EdgeTarget)) continue;
            EList outgoingEdges = dDiagramElementContainer.getOutgoingEdges();
            for (DEdge dEdge : outgoingEdges) {
                if (dEdge.isVisible() != visible) continue;
                result.add((EObject)dEdge);
            }
            EList incomingEdges = dDiagramElementContainer.getIncomingEdges();
            for (DEdge dEdge : incomingEdges) {
                if (dEdge.isVisible() != visible) continue;
                result.add((EObject)dEdge);
            }
        }
        return result;
    }

    public boolean toolsShowHidePrecondition(EObject eObject, EObject containerView) {
        if (eObject instanceof EStructuralFeature || eObject instanceof EClass || eObject instanceof EOperation) {
            return true;
        }
        if (eObject instanceof EPackage && containerView instanceof DSemanticDiagram) {
            EList containers = ((DSemanticDiagram)containerView).getContainers();
            for (DDiagramElementContainer diagramContainer : containers) {
                if (!(diagramContainer.getTarget() instanceof EClass)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<EObject> revealClassReferencesCandidates(EPackage any, DSemanticDiagram view) {
        return this.getClassReferencesCandidates((DSemanticDecorator)view, false);
    }

    public Collection<EObject> revealClassReferencesCandidates(EClass any, DNodeList view) {
        return this.getClassReferencesCandidates((DSemanticDecorator)view, false);
    }

    public Collection<EObject> revealClassReferencesRoot(EPackage any, DSemanticDiagram view) {
        return this.revealClassReferencesRoot((DSemanticDecorator)view);
    }

    public Collection<EObject> revealClassReferencesRoot(EClass any, DNodeList view) {
        return this.revealClassReferencesRoot((DSemanticDecorator)view);
    }

    public Collection<EObject> revealClassReferencesRoot(DSemanticDecorator view) {
        Collection<EObject> collection = this.getClassReferencesCandidates(view, false);
        ArrayList<EObject> collectionToReturn = new ArrayList<EObject>();
        for (EObject currentEObject : collection) {
            if (!(currentEObject instanceof EReference)) continue;
            if (view instanceof DDiagram) {
                collectionToReturn.add(currentEObject.eContainer());
                continue;
            }
            collectionToReturn.add(currentEObject);
        }
        return collectionToReturn;
    }

    private Collection<EObject> getClassReferencesCandidates(DSemanticDecorator view, boolean visible) {
        ArrayList<EObject> collection;
        block4: {
            block3: {
                collection = new ArrayList<EObject>();
                if (!(view instanceof EdgeTarget)) break block3;
                EdgeTarget edgeTarget = (EdgeTarget)view;
                for (DEdge edge : edgeTarget.getIncomingEdges()) {
                    if (visible != edge.isVisible() || !(edge.getTarget() instanceof EReference)) continue;
                    collection.add(edge.getTarget());
                    collection.add(edge.getTarget().eContainer());
                }
                for (DEdge edge : edgeTarget.getOutgoingEdges()) {
                    if (visible != edge.isVisible() || !(edge.getTarget() instanceof EReference)) continue;
                    collection.add(edge.getTarget());
                    collection.add(edge.getTarget().eContainer());
                }
                break block4;
            }
            if (!(view instanceof DDiagram)) break block4;
            DDiagram diagram = (DDiagram)view;
            for (DEdge edge : diagram.getEdges()) {
                if (visible != edge.isVisible()) continue;
                collection.add(edge.getTarget());
                collection.add(edge.getTarget().eContainer());
            }
        }
        return collection;
    }

    public Collection<EObject> hideClassReferencesCandidates(EClass any, DNodeList view) {
        return this.hideClassReferencesCandidates((DSemanticDecorator)view);
    }

    public Collection<EObject> hideClassReferencesCandidates(EPackage any, DSemanticDiagram view) {
        return this.hideClassReferencesCandidates((DSemanticDecorator)view);
    }

    public Collection<EObject> hideClassReferencesCandidates(DSemanticDecorator view) {
        ArrayList<EObject> collection;
        block4: {
            block3: {
                collection = new ArrayList<EObject>();
                if (!(view instanceof EdgeTarget)) break block3;
                EdgeTarget edgeTarget = (EdgeTarget)view;
                for (DEdge edge : edgeTarget.getIncomingEdges()) {
                    if (!edge.isVisible() || !(edge.getTarget() instanceof EReference)) continue;
                    collection.add(edge.getTarget());
                    collection.add(edge.getTarget().eContainer());
                }
                for (DEdge edge : edgeTarget.getOutgoingEdges()) {
                    if (!edge.isVisible() || !(edge.getTarget() instanceof EReference)) continue;
                    collection.add(edge.getTarget());
                    collection.add(edge.getTarget().eContainer());
                }
                break block4;
            }
            if (!(view instanceof DDiagram)) break block4;
            DDiagram diagram = (DDiagram)view;
            for (DEdge edge : diagram.getEdges()) {
                if (!edge.isVisible()) continue;
                collection.add(edge.getTarget());
                collection.add(edge.getTarget().eContainer());
            }
        }
        return collection;
    }

    public Collection<EObject> hideClassReferencesRoot(EClass any, DNodeList view) {
        return this.hideClassReferencesRoot((DSemanticDecorator)view);
    }

    public Collection<EObject> hideClassReferencesRoot(EPackage any, DSemanticDiagram view) {
        return this.hideClassReferencesRoot((DSemanticDecorator)view);
    }

    public Collection<EObject> hideClassReferencesRoot(DSemanticDecorator view) {
        Collection<EObject> collection = this.hideClassReferencesCandidates(view);
        ArrayList<EObject> collectionToReturn = new ArrayList<EObject>();
        for (EObject currentEObject : collection) {
            if (!(currentEObject instanceof EReference)) continue;
            if (view instanceof DDiagram) {
                collectionToReturn.add(currentEObject.eContainer());
                continue;
            }
            collectionToReturn.add(currentEObject);
        }
        return collectionToReturn;
    }

    public Collection<EObject> getViewElement(DSemanticDiagram view) {
        return this.getAnyViewElement((DSemanticDecorator)view);
    }

    public Collection<EObject> getViewElement(DNodeList view) {
        return this.getAnyViewElement((DSemanticDecorator)view);
    }

    public Collection<EObject> getAnyViewElement(DSemanticDecorator view) {
        ArrayList<EObject> collection = new ArrayList<EObject>();
        if (view instanceof EdgeTarget) {
            collection.addAll((Collection<EObject>)((EdgeTarget)view).getIncomingEdges());
            collection.addAll((Collection<EObject>)((EdgeTarget)view).getOutgoingEdges());
        } else if (view instanceof DDiagram) {
            collection.addAll((Collection<EObject>)((DDiagram)view).getEdges());
        }
        return collection;
    }
}

