/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.af.dsl.servicies.project.ui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.kitalpha.ad.af.dsl.as.model.afdesc.AfdescFactory;
import org.polarsys.kitalpha.ad.af.dsl.as.model.afdesc.ArchitectureFramework;
import org.polarsys.kitalpha.ad.af.dsl.as.model.afdesc.Configuration;
import org.polarsys.kitalpha.ad.af.dsl.as.model.afdesc.GenerationConfiguration;
import org.polarsys.kitalpha.ad.af.dsl.as.model.afdesc.Viewpoints;
import org.polarsys.kitalpha.ad.af.dsl.servicies.project.extension.ConcreteSyntaxResourceCreationManager;
import org.polarsys.kitalpha.ad.af.dsl.servicies.project.ui.AFSpecProjectWizardFirstPage;
import org.polarsys.kitalpha.ad.af.dsl.servicies.project.ui.AFSpecProjectWizardSecondPage;
import org.polarsys.kitalpha.ad.af.dsl.servicies.project.ui.util.ProjectsManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;

public class NewAFSpecProject
extends Wizard
implements INewWizard {
    private final StringBuffer PLUGIN_XML_HEADER = new StringBuffer().append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<?eclipse version=\"3.4\"?>\n").append("<plugin>\n");
    private final StringBuffer PLUGIN_XML_FOOTER = new StringBuffer().append("</plugin>\n");
    protected String afShortName;
    protected String afSpecificationProjectName;
    protected String afRootProjectName;
    protected List<Viewpoint> selectedViewpoint = new ArrayList<Viewpoint>();
    protected Map<String, String> selectedConcreteSyntaxCreators;
    private AFSpecProjectWizardFirstPage fPage;
    private AFSpecProjectWizardSecondPage sPage;
    protected ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.polarsys.kitalpha.ad.af.dsl.servicies.project", (String)"icons/af_newproject.png");

    public NewAFSpecProject() {
        this.setWindowTitle("New Architecture Framework");
        super.setDefaultPageImageDescriptor(this.image);
        super.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        NewAFSpecProject.this.createAfDslProject(monitor);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    NewAFSpecProject.this.createConcretSyntaxResources(monitor);
                    NewAFSpecProject.this.createPluginXml(monitor);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void addPages() {
        super.addPages();
        this.addFirstPage();
        if (ConcreteSyntaxResourceCreationManager.isThereAFConcreteSyntaxResourceCreators()) {
            this.addSecondPage();
        }
    }

    protected void addFirstPage() {
        this.fPage = new AFSpecProjectWizardFirstPage();
        this.fPage.setTitle("Architecture Framework");
        this.fPage.setDescription("Create an Architecture Framework (1/2)");
        this.addPage((IWizardPage)this.fPage);
    }

    protected void addSecondPage() {
        this.sPage = new AFSpecProjectWizardSecondPage();
        this.sPage.setTitle("Architecture Framework");
        this.sPage.setDescription("Create an Architecture Framework (2/2)");
        this.addPage((IWizardPage)this.sPage);
    }

    protected void createAfDslProject(IProgressMonitor monitor) throws CoreException, IOException {
        monitor.beginTask("AfSpec resource creation", 3);
        monitor.subTask("AFDsl project creation");
        IProject prj = ProjectsManager.createProject(this.afSpecificationProjectName, this.afShortName, monitor);
        monitor.worked(2);
        monitor.subTask("VPdesc resources creation");
        this.createAFSpecResource(prj);
        monitor.worked(1);
    }

    public void createAFSpecResource(IProject project) {
        ArchitectureFramework af = AfdescFactory.eINSTANCE.createArchitectureFramework();
        af.setShortName(this.afShortName);
        af.setName(this.afShortName);
        if (this.selectedViewpoint.size() > 0) {
            Viewpoints viewpoints = AfdescFactory.eINSTANCE.createViewpoints();
            af.setAf_viewpoints(viewpoints);
            for (Viewpoint viewpoint : this.selectedViewpoint) {
                viewpoints.getOwned_viewpoints().add((Object)viewpoint);
            }
        }
        Configuration configuration = AfdescFactory.eINSTANCE.createConfiguration();
        af.setOwned_configuration(configuration);
        GenerationConfiguration generationConfiguration = AfdescFactory.eINSTANCE.createGenerationConfiguration();
        generationConfiguration.setRootProjectName(this.afRootProjectName);
        configuration.getOwned_element().add((Object)generationConfiguration);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        String uri_s = "/" + project.getName() + "/model/" + this.afShortName.toLowerCase() + ".afdesc";
        URI uri = URI.createPlatformResourceURI((String)uri_s, (boolean)false);
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().add((Object)af);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void createConcretSyntaxResources(IProgressMonitor monitor) {
        if (this.selectedConcreteSyntaxCreators != null && this.selectedConcreteSyntaxCreators.size() != 0) {
            monitor.beginTask("Concrete syntax resources creation", this.selectedConcreteSyntaxCreators.size());
            Set<String> set = this.selectedConcreteSyntaxCreators.keySet();
            for (String id : set) {
                try {
                    monitor.subTask("creation of " + id + " resource");
                    ConcreteSyntaxResourceCreationManager.createAdditionalResource(id, this.afShortName, this.afRootProjectName, this.afSpecificationProjectName, this.selectedViewpoint);
                    monitor.worked(1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void createPluginXml(IProgressMonitor monitor) {
        StringBuffer pluginXmlContent = new StringBuffer();
        pluginXmlContent.append(this.PLUGIN_XML_HEADER);
        pluginXmlContent.append("\n");
        pluginXmlContent.append(this.createConcretSyntaxExtensions(monitor));
        pluginXmlContent.append("\n");
        pluginXmlContent.append(this.PLUGIN_XML_FOOTER);
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.afSpecificationProjectName);
        final ByteArrayInputStream fileInputStream = new ByteArrayInputStream(pluginXmlContent.toString().getBytes());
        try {
            new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    IFile pluginXml = project.getFile("plugin.xml");
                    if (pluginXml.exists()) {
                        pluginXml.setContents((InputStream)fileInputStream, true, false, null);
                    } else {
                        pluginXml.create((InputStream)fileInputStream, true, null);
                    }
                    project.refreshLocal(2, monitor);
                }
            }.run(monitor);
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    protected StringBuffer createConcretSyntaxExtensions(IProgressMonitor monitor) {
        StringBuffer result = null;
        if (this.selectedConcreteSyntaxCreators != null && this.selectedConcreteSyntaxCreators.size() != 0) {
            result = new StringBuffer();
            monitor.beginTask("Concrete syntax resources creation", this.selectedConcreteSyntaxCreators.size());
            Set<String> set = this.selectedConcreteSyntaxCreators.keySet();
            for (String id : set) {
                try {
                    monitor.subTask("creation of " + id + " contribution");
                    StringBuffer content = ConcreteSyntaxResourceCreationManager.createAdditionalPluginXmlContribution(id, this.afShortName, this.afRootProjectName, this.afSpecificationProjectName);
                    if (content != null) {
                        result.append(content);
                        result.append("\n");
                    }
                    monitor.worked(1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public String getAfShortName() {
        return this.afShortName;
    }

    public void setAfShortName(String afShortName) {
        this.afShortName = afShortName;
    }

    public String getAfSpecificationProjectName() {
        return this.afSpecificationProjectName;
    }

    public void setAfSpecificationProjectName(String afSpecificationProjectName) {
        this.afSpecificationProjectName = afSpecificationProjectName;
    }

    public String getAfRootProjectName() {
        return this.afRootProjectName;
    }

    public void setAfRootProjectName(String afRootProjectName) {
        this.afRootProjectName = afRootProjectName;
    }

    public List<Viewpoint> getSelectedViewpoint() {
        return this.selectedViewpoint;
    }

    public void setSelectedViewpoint(List<Viewpoint> selectedViewpoint) {
        this.selectedViewpoint = selectedViewpoint;
    }

    public Map<String, String> getSelectedConcreteSyntaxCreators() {
        return this.selectedConcreteSyntaxCreators;
    }

    public void setSelectedConcreteSyntaxCreators(Map<String, String> selectedConcreteSyntaxCreators) {
        this.selectedConcreteSyntaxCreators = selectedConcreteSyntaxCreators;
    }
}

