/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.DatasetException;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.LazyDataset;
import org.eclipse.january.dataset.Random;
import org.eclipse.january.dataset.Slice;
import org.junit.Assert;
import org.junit.Test;

public class LazyDatasetTest {
    private void setShape(String msg, boolean well, LazyDataset l, int ... shape) {
        try {
            l.setShape(shape);
            if (well) {
                TestUtils.verbosePrintf((String)"Succeeded setting shape for %s\n", (Object[])new Object[]{msg});
            } else {
                Assert.fail((String)("Should have thrown exception for " + msg));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (well) {
                Assert.fail((String)("Unexpected exception for " + msg));
            } else {
                TestUtils.verbosePrintf((String)"Correctly failed setting shape for %s\n", (Object[])new Object[]{msg});
            }
        }
        catch (Exception e) {
            msg = String.valueOf(msg) + ": " + e.getMessage();
            if (well) {
                Assert.fail((String)("Unexpected exception for " + msg));
            }
            Assert.fail((String)("Thrown wrong exception for " + msg));
        }
    }

    @Test
    public void testSetShape() {
        LazyDataset ld = new LazyDataset("", 3, new int[]{1, 2, 3, 4}, null);
        this.setShape("check on same rank", true, ld, 1, 2, 3, 4);
        this.setShape("check on same rank", false, ld, 1, 2, 3, 5);
        this.setShape("check on greater rank", true, ld, 1, 1, 1, 2, 3, 4);
        this.setShape("check on greater rank", false, ld, 1, 2, 2, 3, 5);
        this.setShape("check on greater rank", false, ld, 2, 1, 2, 3, 4);
        this.setShape("check on greater rank", true, ld, 2, 3, 4, 1, 1, 1);
        this.setShape("check on greater rank", true, ld, 1, 1, 2, 3, 4, 1, 1, 1);
        this.setShape("check on lesser rank", true, ld, 2, 3, 4);
        this.setShape("check on lesser rank", false, ld, 3, 4);
        this.setShape("check on lesser rank", false, ld, 2, 3);
        ld = new LazyDataset("", 3, new int[]{2, 3, 4, 1}, null);
        this.setShape("check on lesser rank", true, ld, 2, 3, 4);
        ld = new LazyDataset("", 3, new int[]{1, 2, 3, 4, 1}, null);
        this.setShape("check on lesser rank", true, ld, 2, 3, 4);
    }

    @Test
    public void testGetSlice() throws Exception {
        int[] shape = new int[]{1, 2, 3, 4};
        DoubleDataset d = Random.randn((int[])shape);
        LazyDataset ld = LazyDataset.createLazyDataset((Dataset)d);
        Slice[] sliceArray = new Slice[4];
        sliceArray[1] = new Slice(Integer.valueOf(1));
        sliceArray[3] = new Slice(Integer.valueOf(1), Integer.valueOf(3));
        Slice[] slice = sliceArray;
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)ld.getSlice(new Slice[0]));
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)ld.getSlice(new Slice[]{null}));
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)ld.getSlice(new Slice[]{null, null}));
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)ld.getSlice(null, null));
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)ld.getSlice(null, null, null));
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)ld.getSlice(null, null, new int[]{1, 1, 1, 1}));
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)ld.getSlice(new int[4], null, new int[]{1, 1, 1, 1}));
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)ld.getSlice(new int[4], new int[]{1, 2, 3, 4}, new int[]{1, 1, 1, 1}));
        Assert.assertEquals((String)"Part slice", (Object)d.getSlice(slice), (Object)ld.getSlice(slice));
        ld.setShape(new int[]{1, 1, 1, 2, 3, 4});
        Dataset nd = d.getView(true);
        nd.setShape(new int[]{1, 1, 1, 2, 3, 4});
        Assert.assertEquals((String)"Full slice", (Object)nd, (Object)ld.getSlice(new Slice[0]));
        Slice[] sliceArray2 = new Slice[6];
        sliceArray2[3] = new Slice(Integer.valueOf(1));
        sliceArray2[5] = new Slice(Integer.valueOf(1), Integer.valueOf(3));
        slice = sliceArray2;
        Assert.assertEquals((String)"Part slice", (Object)nd.getSlice(slice), (Object)ld.getSlice(slice));
        ld.setShape(new int[]{2, 3, 4});
        nd = d.getView(true);
        nd.setShape(new int[]{2, 3, 4});
        Assert.assertEquals((String)"Full slice", (Object)nd, (Object)ld.getSlice(new Slice[0]));
        Slice[] sliceArray3 = new Slice[3];
        sliceArray3[0] = new Slice(Integer.valueOf(1));
        sliceArray3[2] = new Slice(Integer.valueOf(1), Integer.valueOf(3));
        slice = sliceArray3;
        Assert.assertEquals((String)"Part slice", (Object)nd.getSlice(slice), (Object)ld.getSlice(slice));
        ld.setShape(new int[]{2, 3, 4, 1, 1, 1});
        nd = d.getView(true);
        nd.setShape(new int[]{2, 3, 4, 1, 1, 1});
        Assert.assertEquals((String)"Full slice", (Object)nd, (Object)ld.getSlice(new Slice[0]));
        Slice[] sliceArray4 = new Slice[6];
        sliceArray4[0] = new Slice(Integer.valueOf(1));
        sliceArray4[2] = new Slice(Integer.valueOf(1), Integer.valueOf(3));
        slice = sliceArray4;
        Assert.assertEquals((String)"Part slice", (Object)nd.getSlice(slice), (Object)ld.getSlice(slice));
        ld.setShape(new int[]{1, 2, 3, 4, 1, 1, 1});
        nd = d.getView(true);
        nd.setShape(new int[]{1, 2, 3, 4, 1, 1, 1});
        Assert.assertEquals((String)"Full slice", (Object)nd, (Object)ld.getSlice(new Slice[0]));
        Slice[] sliceArray5 = new Slice[7];
        sliceArray5[1] = new Slice(Integer.valueOf(1));
        sliceArray5[3] = new Slice(Integer.valueOf(1), Integer.valueOf(3));
        slice = sliceArray5;
        Assert.assertEquals((String)"Part slice", (Object)nd.getSlice(slice), (Object)ld.getSlice(slice));
        ld.setShape(shape);
        Slice[] sliceArray6 = new Slice[4];
        sliceArray6[0] = new Slice(null, null, Integer.valueOf(-1));
        slice = sliceArray6;
        nd = ld.getSlice(slice);
        Assert.assertEquals((String)"Full negative slice", (Object)d.getSlice(slice), (Object)nd);
        Slice[] sliceArray7 = new Slice[4];
        sliceArray7[3] = new Slice(null, null, Integer.valueOf(-1));
        slice = sliceArray7;
        nd = ld.getSlice(slice);
        Assert.assertEquals((String)"Full negative slice", (Object)d.getSlice(slice), (Object)nd);
    }

    @Test
    public void testGetSliceView() throws Exception {
        int[] shape = new int[]{6, 2, 4, 1};
        DoubleDataset d = Random.randn((int[])shape);
        LazyDataset ld = LazyDataset.createLazyDataset((Dataset)d);
        Slice[] sliceArray = new Slice[4];
        sliceArray[0] = new Slice(Integer.valueOf(1), null, Integer.valueOf(3));
        sliceArray[1] = new Slice(Integer.valueOf(1));
        sliceArray[2] = new Slice(Integer.valueOf(1), Integer.valueOf(3));
        Slice[] slice = sliceArray;
        LazyDataset l = ld.getSliceView(null, shape, null);
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{l.toString()});
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)l.getSlice(new Slice[0]));
        l = ld.getSliceView(slice);
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{l.toString()});
        Assert.assertEquals((String)"Part slice", (Object)d.getSlice(slice), (Object)l.getSlice(new Slice[0]));
        l = ld.getSliceView(new Slice[0]);
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{l.toString()});
        Assert.assertEquals((String)"Full slice", (Object)d, (Object)l.getSlice(new Slice[0]));
        l = ld.getSliceView(slice);
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{l.toString()});
        Assert.assertEquals((String)"Part slice", (Object)d.getSlice(slice), (Object)l.getSlice(new Slice[0]));
        l = ld.getSliceView(new Slice[0]);
        l.squeezeEnds();
        Assert.assertEquals((String)"Full slice", (long)3L, (long)l.getSlice(new Slice[0]).getRank());
        Slice[] sliceArray2 = new Slice[4];
        sliceArray2[0] = new Slice(null, null, Integer.valueOf(-1));
        slice = sliceArray2;
        l = ld.getSliceView(slice);
        Assert.assertEquals((String)"Full negative slice", (Object)d.getSlice(slice), (Object)l.getSlice(new Slice[0]));
        Slice[] sliceArray3 = new Slice[4];
        sliceArray3[3] = new Slice(null, null, Integer.valueOf(-1));
        slice = sliceArray3;
        l = ld.getSliceView(slice);
        Assert.assertEquals((String)"Full negative slice", (Object)d.getSlice(slice), (Object)l.getSlice(new Slice[0]));
    }

    @Test
    public void testShape() throws DatasetException {
        DoubleDataset data = Random.rand((int[])new int[]{1, 2, 3, 4});
        data.setName("random");
        LazyDataset ld = LazyDataset.createLazyDataset((Dataset)data);
        ld.setShape(new int[]{1, 1, 2, 3, 4, 1});
        Assert.assertArrayEquals((int[])new int[]{1, 1, 2, 3, 4, 1}, (int[])ld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{1, 1, 2, 3, 4, 1}), (Dataset)ld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        LazyDataset tld = ld.getSliceView(new Slice[0]);
        Assert.assertArrayEquals((int[])new int[]{1, 1, 2, 3, 4, 1}, (int[])tld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{1, 1, 2, 3, 4, 1}), (Dataset)tld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        ld.setShape(new int[]{1, 2, 3, 4});
        tld = ld.getSliceView(new Slice[0]);
        ld.setShape(new int[]{1, 1, 2, 3, 4, 1});
        Assert.assertArrayEquals((int[])new int[]{1, 1, 2, 3, 4, 1}, (int[])ld.getShape());
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])tld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{1, 1, 2, 3, 4, 1}), (Dataset)ld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{1, 1, 2, 3, 4, 1}), (Dataset)ld.getSliceView(new Slice[0]).getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        tld.setShape(new int[]{1, 1, 2, 3, 4, 1});
        Assert.assertArrayEquals((int[])new int[]{1, 1, 2, 3, 4, 1}, (int[])tld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{1, 1, 2, 3, 4, 1}), (Dataset)tld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{1, 1, 2, 3, 4, 1}), (Dataset)tld.getSliceView(new Slice[0]).getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        LazyDataset uld = tld.getSliceView(new Slice[0]);
        Assert.assertArrayEquals((int[])new int[]{1, 1, 2, 3, 4, 1}, (int[])uld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{1, 1, 2, 3, 4, 1}), (Dataset)uld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{1, 1, 2, 3, 4, 1}), (Dataset)uld.getSliceView(new Slice[0]).getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        uld.setShape(new int[]{2, 3, 4});
        Assert.assertArrayEquals((int[])new int[]{2, 3, 4}, (int[])uld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{2, 3, 4}), (Dataset)uld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{2, 3, 4}), (Dataset)uld.getSliceView(new Slice[0]).getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        Slice[] sliceArray = new Slice[4];
        sliceArray[3] = new Slice(Integer.valueOf(1), null, Integer.valueOf(2));
        Slice[] slice = sliceArray;
        ld.setShape(new int[]{1, 2, 3, 4});
        tld = ld.getSliceView(slice);
        tld.squeezeEnds();
        TestUtils.assertDatasetEquals((Dataset)data.getSliceView(slice).squeezeEnds(), (Dataset)tld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        TestUtils.assertDatasetEquals((Dataset)data.getSliceView(slice).squeezeEnds(), (Dataset)tld.getSliceView(new Slice[0]).getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
    }

    @Test
    public void testTranspose() throws DatasetException {
        DoubleDataset data = Random.rand((int[])new int[]{1, 2, 3, 4});
        data.setName("random");
        LazyDataset ld = LazyDataset.createLazyDataset((Dataset)data);
        LazyDataset tld = ld.getTransposedView(new int[]{3, 1, 0, 2});
        Assert.assertEquals((long)tld.getSize(), (long)ld.getSize());
        Assert.assertArrayEquals((int[])new int[]{4, 2, 1, 3}, (int[])tld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{3, 1, 0, 2}), (Dataset)tld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        LazyDataset uld = tld.getTransposedView(new int[]{3, 2, 1, 0});
        Assert.assertArrayEquals((int[])new int[]{3, 1, 2, 4}, (int[])uld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{3, 1, 0, 2}).getTransposedView(new int[]{3, 2, 1, 0}), (Dataset)uld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        Assert.assertArrayEquals((int[])new int[]{3, 1, 2, 4}, (int[])ld.getTransposedView(new int[]{2, 0, 1, 3}).getShape());
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{2, 0, 1, 3}), (Dataset)uld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        tld.setShape(new int[]{1, 4, 2, 1, 3, 1});
        Assert.assertArrayEquals((int[])new int[]{1, 4, 2, 1, 3, 1}, (int[])tld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{3, 1, 0, 2}).reshape(new int[]{1, 4, 2, 1, 3, 1}), (Dataset)tld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        ld.setShape(new int[]{1, 1, 2, 3, 4, 1});
        tld = ld.getTransposedView(new int[]{3, 1, 0, 2, 4, 5});
        Assert.assertArrayEquals((int[])new int[]{3, 1, 1, 2, 4, 1}, (int[])tld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.reshape(new int[]{1, 1, 2, 3, 4, 1}).getTransposedView(new int[]{3, 1, 0, 2, 4, 5}), (Dataset)tld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        ld.setShape(new int[]{1, 2, 3, 4});
        tld = ld.getSliceView(new Slice[]{null, null, null, new Slice(Integer.valueOf(1), null, Integer.valueOf(2))});
        TestUtils.assertDatasetEquals((Dataset)data.getSliceView(new Slice[]{null, null, null, new Slice(Integer.valueOf(1), null, Integer.valueOf(2))}), (Dataset)tld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        TestUtils.assertDatasetEquals((Dataset)data.getSliceView(new Slice[]{null, null, null, new Slice(Integer.valueOf(1), null, Integer.valueOf(2))}), (Dataset)tld.getSliceView(new Slice[0]).getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        uld = tld.getTransposedView(new int[]{3, 1, 0, 2});
        Assert.assertEquals((long)tld.getSize(), (long)uld.getSize());
        Assert.assertArrayEquals((int[])new int[]{2, 2, 1, 3}, (int[])uld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.getSliceView(new Slice[]{null, null, null, new Slice(Integer.valueOf(1), null, Integer.valueOf(2))}).getTransposedView(new int[]{3, 1, 0, 2}), (Dataset)uld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        tld = ld.getTransposedView(new int[]{3, 1, 0, 2});
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{3, 1, 0, 2}), (Dataset)tld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{3, 1, 0, 2}), (Dataset)tld.getSliceView(new Slice[0]).getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        LazyDataset vld = tld.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), null, Integer.valueOf(2))});
        Assert.assertEquals((long)12L, (long)vld.getSize());
        Assert.assertArrayEquals((int[])new int[]{2, 2, 1, 3}, (int[])vld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{3, 1, 0, 2}).getSliceView(new Slice[]{new Slice(Integer.valueOf(1), null, Integer.valueOf(2))}), (Dataset)vld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        tld.setShape(new int[]{1, 4, 2, 1, 3, 1});
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{3, 1, 0, 2}).reshape(new int[]{1, 4, 2, 1, 3, 1}), (Dataset)tld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{3, 1, 0, 2}).reshape(new int[]{1, 4, 2, 1, 3, 1}), (Dataset)tld.getSliceView(new Slice[0]).getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        uld = tld.getTransposedView(new int[0]);
        Assert.assertArrayEquals((int[])new int[]{1, 3, 1, 2, 4, 1}, (int[])uld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{3, 1, 0, 2}).reshape(new int[]{1, 4, 2, 1, 3, 1}).getTransposedView(new int[0]), (Dataset)uld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
        uld.setShape(new int[]{3, 1, 2, 4, 1});
        Assert.assertArrayEquals((int[])new int[]{3, 1, 2, 4, 1}, (int[])uld.getShape());
        TestUtils.assertDatasetEquals((Dataset)data.getTransposedView(new int[]{3, 1, 0, 2}).reshape(new int[]{1, 4, 2, 1, 3, 1}).getTransposedView(new int[0]).reshape(new int[]{3, 1, 2, 4, 1}), (Dataset)uld.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
    }

    @Test
    public void testSlicePadRankSlice() throws DatasetException {
        DoubleDataset data = Random.rand((int[])new int[]{10});
        data.setName("random");
        LazyDataset ld = LazyDataset.createLazyDataset((Dataset)data);
        LazyDataset sv = ld.getSliceView(new int[1], new int[]{5}, null);
        sv.setShape(new int[]{1, 1, 5});
        LazyDataset view = sv.getSliceView(new int[3], new int[]{1, 1, 4}, null);
        TestUtils.assertDatasetEquals((Dataset)data.getSliceView(new Slice[]{new Slice(Integer.valueOf(5))}).reshape(new int[]{1, 1, 5}).getSliceView(new Slice[]{null, null, new Slice(Integer.valueOf(4))}), (Dataset)view.getSlice(new Slice[0]), (boolean)true, (double)1.0E-14, (double)1.0E-14);
    }
}

