/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.january.form.AbstractEntry;
import org.eclipse.january.form.Component;
import org.eclipse.january.form.ContinuousEntry;
import org.eclipse.january.form.DataComponent;
import org.eclipse.january.form.DiscreteEntry;
import org.eclipse.january.form.Form;
import org.eclipse.january.form.ICEObject;
import org.eclipse.january.form.IEntry;
import org.eclipse.january.form.StringEntry;
import org.eclipse.january.form.TableComponent;

@XmlRootElement(name="Form")
public class PainfullySimpleForm
extends Form {
    private HashMap<String, ArrayList<IEntry>> rowTemplates = new HashMap();
    private String currentGroup;

    public void loadFromPSF(ArrayList<String> inputLines) throws IOException {
        int firstEntryLine = 0;
        new ArrayList();
        ArrayList<String> formAndGroupLines = new ArrayList<String>();
        new ArrayList();
        if (inputLines != null) {
            for (String currentLine : inputLines) {
                if (currentLine.startsWith("group=") || currentLine.startsWith("table=") || currentLine.startsWith("groupDescription=") || currentLine.startsWith("tableDescription=") || currentLine.startsWith("formName=") || currentLine.startsWith("formDescription=") || currentLine.startsWith("formType=")) {
                    formAndGroupLines.add(currentLine);
                    continue;
                }
                if (currentLine.matches("^$|(?m)^\\s+$") || currentLine.startsWith("#") || currentLine.startsWith("//") || !currentLine.contains("=")) continue;
                firstEntryLine = inputLines.indexOf(currentLine);
                break;
            }
            if (!this.isPSF(formAndGroupLines)) {
                throw new IOException("This is not a PSF InputStream! Check the blocks and make sure they are in the proper order!");
            }
        } else {
            throw new IOException("PSF InputStream cannot be null!");
        }
        this.setName(formAndGroupLines.get(0).split("=")[1].trim());
        this.setDescription(formAndGroupLines.get(1).split("=")[1].trim());
        this.loadComponents(formAndGroupLines);
        this.loadEntries(new ArrayList<String>(inputLines.subList(firstEntryLine, inputLines.size())));
        this.setupRowTemplates();
    }

    private boolean isPSF(ArrayList<String> lines) {
        boolean retFlag = false;
        if (lines.get(0).contains("=")) {
            retFlag = "formName".equals(lines.get(0).split("=")[0]) && "group".equals(lines.get(3).split("=")[0]) && "groupDescription".equals(lines.get(4).split("=")[0]);
        }
        return retFlag;
    }

    private void loadComponents(ArrayList<String> lines) throws IOException {
        String[] splitLines = new String[]{"", ""};
        ArrayList<String> groups = new ArrayList<String>();
        ArrayList<String> groupDescriptions = new ArrayList<String>();
        ArrayList<String> tables = new ArrayList<String>();
        ArrayList<String> tableDescriptions = new ArrayList<String>();
        DataComponent dataComp = null;
        TableComponent tableComp = null;
        boolean hitGroupsBlock = false;
        int i = 3;
        while (i < lines.size()) {
            String currentLine = lines.get(i);
            splitLines = currentLine.split("=");
            if (currentLine.startsWith("group=")) {
                groups.add(splitLines[1].trim());
                hitGroupsBlock = true;
            }
            if (currentLine.startsWith("table=")) {
                tables.add(splitLines[1].trim());
                hitGroupsBlock = true;
            } else if (currentLine.startsWith("groupDescription=")) {
                groupDescriptions.add(splitLines[1].trim());
            } else if (currentLine.startsWith("tableDescription=")) {
                tableDescriptions.add(splitLines[1].trim());
            } else if (currentLine.matches("^$|(?m)^\\s+$") && hitGroupsBlock) break;
            ++i;
        }
        if (groups.size() != groupDescriptions.size()) {
            throw new IOException("This file does not appear to contain a group description for each of its groups and thereby violates the PSF specification. Please check your file!");
        }
        i = 0;
        while (i < groups.size()) {
            dataComp = new DataComponent();
            dataComp.setId(i + 1);
            dataComp.setName((String)groups.get(i));
            dataComp.setDescription((String)groupDescriptions.get(i));
            this.addComponent(dataComp);
            ++i;
        }
        i = 0;
        while (i < tables.size()) {
            tableComp = new TableComponent();
            tableComp.setId(groups.size() + i + 1);
            tableComp.setName((String)tables.get(i));
            tableComp.setDescription((String)tableDescriptions.get(i));
            this.addComponent(tableComp);
            this.rowTemplates.put(tableComp.getName(), new ArrayList());
            ++i;
        }
    }

    private void loadEntries(ArrayList<String> lines) throws IOException {
        int lowerBound = 0;
        int upperBound = 0;
        ArrayList<Integer> emptyLines = new ArrayList<Integer>();
        HashMap<String, Integer> componentMap = new HashMap<String, Integer>();
        ICEObject compRef = null;
        DataComponent dataRef = null;
        ArrayList<IEntry> tempArray = null;
        IEntry entry = null;
        boolean lastLineEmpty = false;
        for (Component i : this.getComponents()) {
            compRef = (ICEObject)((Object)i);
            componentMap.put(compRef.getName(), compRef.getId());
        }
        if (!lines.get(lines.size() - 1).matches("^$|(?m)^\\s+$")) {
            lines.add("\t \n");
        }
        int i = 0;
        while (i < lines.size()) {
            String currentLine = lines.get(i);
            if (currentLine.matches("^$|(?m)^\\s+$") && !lastLineEmpty) {
                emptyLines.add(i);
                lastLineEmpty = true;
            } else {
                lastLineEmpty = currentLine.startsWith("//") || currentLine.startsWith("#");
            }
            ++i;
        }
        lowerBound = 0;
        upperBound = (Integer)emptyLines.get(0);
        i = 0;
        while (i < emptyLines.size()) {
            new ArrayList<String>(lines.subList(lowerBound, upperBound + 1));
            entry = this.loadFromPSFBlock(new ArrayList<String>(lines.subList(lowerBound, upperBound + 1)));
            entry.setId(i + 1);
            if (componentMap.containsKey(this.currentGroup)) {
                compRef = (ICEObject)((Object)this.getComponent((Integer)componentMap.get(this.currentGroup)));
                if (this.rowTemplates.containsKey(this.currentGroup)) {
                    tempArray = this.rowTemplates.get(this.currentGroup);
                    tempArray.add(entry);
                } else {
                    dataRef = (DataComponent)compRef;
                    dataRef.addEntry(entry);
                }
            } else {
                throw new IOException("Entry " + entry.getName() + " has an invalid group! Group = " + this.currentGroup);
            }
            lowerBound = upperBound;
            upperBound = upperBound == (Integer)emptyLines.get(emptyLines.size() - 1) || upperBound == lines.size() ? lines.size() : ((Integer)emptyLines.get(i + 1)).intValue();
            ++i;
        }
    }

    private IEntry loadFromPSFBlock(ArrayList<String> inputStrings) throws IOException {
        new ArrayList();
        String[] splitStrings = new String[]{"", ""};
        ArrayList<String> validKeys = new ArrayList<String>();
        AbstractEntry retEntry = null;
        String name = "";
        String description = "";
        String tag = "";
        String defaultValue = "";
        String valueType = "";
        ArrayList<String> allowed = new ArrayList<String>();
        if (inputStrings != null) {
            validKeys.add("name");
            validKeys.add("description");
            validKeys.add("defaultValue");
            validKeys.add("allowedValueType");
            validKeys.add("allowedValue");
            validKeys.add("tag");
            validKeys.add("group");
            for (String currentString : inputStrings) {
                if (currentString.matches("^$|(?m)^\\s+$") || currentString.startsWith("#") || currentString.startsWith("//")) continue;
                if (currentString.contains("#")) {
                    currentString = currentString.replaceAll("\\#.*", "");
                } else if (currentString.contains("//")) {
                    currentString = currentString.replaceAll("\\/\\/.*", "");
                }
                if (!currentString.contains("=")) {
                    throw new IOException("String in Entry block does not contain an equals sign! The string was at line " + inputStrings.indexOf(currentString) + ":\n" + currentString);
                }
                splitStrings = currentString.trim().split("\\=");
                if ("name".equals(splitStrings[0])) {
                    name = splitStrings[1];
                    continue;
                }
                if ("description".equals(splitStrings[0])) {
                    description = splitStrings[1];
                    continue;
                }
                if ("defaultValue".equals(splitStrings[0])) {
                    defaultValue = splitStrings[1];
                    continue;
                }
                if ("allowedValueType".equals(splitStrings[0])) {
                    valueType = splitStrings[1];
                    continue;
                }
                if ("allowedValue".equals(splitStrings[0])) {
                    allowed.add(splitStrings[1]);
                    continue;
                }
                if ("tag".equals(splitStrings[0])) {
                    tag = splitStrings[1];
                    continue;
                }
                if ("group".equals(splitStrings[0])) {
                    this.currentGroup = splitStrings[1];
                    continue;
                }
                if (validKeys.contains(splitStrings[0])) continue;
                throw new IOException("Invalid PSF statement: " + currentString);
            }
        }
        if ("Discrete".equals(valueType)) {
            retEntry = new DiscreteEntry(allowed.toArray(new String[allowed.size()]));
        } else if ("Continuous".equals(valueType)) {
            retEntry = new ContinuousEntry(allowed.toArray(new String[allowed.size()]));
        } else if ("Undefined".equals(valueType)) {
            retEntry = new StringEntry();
        }
        retEntry.setName(name);
        retEntry.setDefaultValue(defaultValue);
        retEntry.setValue(defaultValue);
        retEntry.setDescription(description);
        retEntry.setTag(tag);
        return retEntry;
    }

    private void getFormNameAndDescription(ArrayList<String> lines) {
        boolean hasName = false;
        boolean hasDescription = false;
        String[] splitLines = new String[]{"", ""};
        for (String currentLine : lines) {
            splitLines = currentLine.split("=");
            if (currentLine.startsWith("formName")) {
                this.setName(splitLines[1].trim());
                hasName = true;
                continue;
            }
            if (currentLine.startsWith("formDescription")) {
                this.setDescription(splitLines[1].trim());
                hasDescription = true;
                continue;
            }
            if (hasName && hasDescription) break;
        }
    }

    private void setupRowTemplates() {
        ICEObject compRef = null;
        TableComponent tableRef = null;
        ArrayList<IEntry> tempArray = null;
        int i = 0;
        while (i < this.getComponents().size()) {
            compRef = (ICEObject)((Object)this.getComponents().get(i));
            if (this.rowTemplates.containsKey(compRef.getName())) {
                tempArray = this.rowTemplates.get(compRef.getName());
                tableRef = (TableComponent)compRef;
                tableRef.setRowTemplate(tempArray);
            }
            ++i;
        }
    }
}

