/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.january.IMonitor;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.LazyDynamicDataset;
import org.eclipse.january.dataset.LongDataset;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceND;
import org.eclipse.january.dataset.SliceNDIterator;
import org.eclipse.january.io.ILazyDynamicLoader;
import org.eclipse.january.io.ILazyLoader;
import org.eclipse.january.metadata.AxesMetadata;
import org.eclipse.january.metadata.DynamicMetadataUtils;
import org.eclipse.january.metadata.MetadataFactory;
import org.eclipse.january.metadata.MetadataType;
import org.junit.Assert;
import org.junit.Test;

public class LazyDynamicLoaderTest {
    @Test
    public void testLoader() throws Exception {
        Dataset range = DatasetFactory.createRange(LongDataset.class, (double)52000.0);
        range.setShape(new int[]{10, 13, 20, 20});
        LazyDynamicDataset dataset = this.getDataset((IDataset)range, 2, "data");
        AxesMetadata ax = (AxesMetadata)MetadataFactory.createMetadata(AxesMetadata.class, (Object[])new Object[]{4});
        ax.setAxis(0, new ILazyDataset[]{DatasetFactory.createRange(LongDataset.class, (double)10.0)});
        ax.setAxis(1, new ILazyDataset[]{DatasetFactory.createRange(LongDataset.class, (double)13.0)});
        dataset.addMetadata((MetadataType)ax);
        int max = 399;
        int i = 0;
        while (i < 130) {
            SliceND slice = new SliceND(dataset.getShape());
            int[] shape = dataset.getShape();
            slice.setSlice(0, shape[0] - 1, shape[0], 1);
            slice.setSlice(1, shape[1] - 1, shape[1], 1);
            Dataset s = dataset.getSlice(slice);
            Assert.assertEquals((long)max, (long)s.max(new boolean[0]).intValue());
            max += 400;
            AxesMetadata axm = (AxesMetadata)s.getFirstMetadata(AxesMetadata.class);
            Assert.assertEquals((long)axm.getAxis(0)[0].getSlice(new Slice[0]).getInt(new int[]{0, 0, 0, 0}), (long)(shape[0] - 1));
            Assert.assertEquals((long)axm.getAxis(1)[0].getSlice(new Slice[0]).getInt(new int[]{0, 0, 0, 0}), (long)(shape[1] - 1));
            dataset.refreshShape();
            ++i;
        }
        Assert.assertArrayEquals((int[])new int[]{10, 13, 20, 20}, (int[])dataset.getShape());
    }

    @Test
    public void testDynamicAxesMetadata() throws Exception {
        int[] maxShape = new int[]{10, 13, 20, 20};
        Dataset range = DatasetFactory.createRange(LongDataset.class, (double)52000.0);
        range.setShape(maxShape);
        LazyDynamicDataset dataset = this.getDataset((IDataset)range, 2, "data");
        LazyDynamicDataset ax1 = this.getDataset((IDataset)DatasetFactory.createRange(LongDataset.class, (double)10.0), 0, "ax0");
        LazyDynamicDataset ax2 = this.getDataset((IDataset)DatasetFactory.createRange(LongDataset.class, (double)13.0), 0, "ax1");
        AxesMetadata ax = (AxesMetadata)MetadataFactory.createMetadata(AxesMetadata.class, (Object[])new Object[]{4});
        ax.setAxis(0, new ILazyDataset[]{ax1});
        ax.setAxis(1, new ILazyDataset[]{ax2});
        dataset.addMetadata((MetadataType)ax);
        int max = 399;
        SliceND slice = new SliceND(dataset.getShape(), maxShape, new Slice[0]);
        int[] axShape = new int[]{1, 1, 1, 1};
        int i = 0;
        while (i < 130) {
            int[] shape = dataset.getShape();
            int[] so = DynamicMetadataUtils.refreshDynamicAxesMetadata((List)dataset.getMetadata(AxesMetadata.class), (int[])shape);
            slice.setSlice(0, shape[0] - 1, shape[0], 1);
            slice.setSlice(1, shape[1] - 1, shape[1], 1);
            Dataset s = dataset.getSlice(slice);
            Assert.assertEquals((long)max, (long)s.max(new boolean[0]).longValue());
            max += 400;
            AxesMetadata axm = (AxesMetadata)s.getFirstMetadata(AxesMetadata.class);
            IDataset s0 = axm.getAxis(0)[0].getSlice(new Slice[0]);
            Assert.assertArrayEquals((int[])axShape, (int[])s0.getShape());
            Assert.assertEquals((long)s0.getInt(new int[]{0, 0, 0, 0}), (long)(shape[0] - 1));
            s0 = axm.getAxis(1)[0].getSlice(new Slice[0]);
            Assert.assertArrayEquals((int[])axShape, (int[])s0.getShape());
            Assert.assertEquals((long)axm.getAxis(1)[0].getSlice(new Slice[0]).getInt(new int[]{0, 0, 0, 0}), (long)(shape[1] - 1));
            dataset.refreshShape();
            ++i;
        }
        Assert.assertArrayEquals((int[])new int[]{10, 13, 20, 20}, (int[])dataset.getShape());
    }

    private LazyDynamicDataset getDataset(IDataset data, int detectorRank, String name) {
        int[] shape = LazyDynamicLoaderTest.determineInitialShape(data.getShape(), detectorRank);
        return new LazyDynamicDataset((ILazyLoader)new LazyDynamicTestLoader(data, detectorRank), name, 1, DoubleDataset.class, shape, data.getShape());
    }

    private static int[] determineInitialShape(int[] maxShape, int detectorRank) {
        int[] shape = (int[])maxShape.clone();
        Arrays.fill(shape, 1);
        int i = 0;
        while (i < detectorRank) {
            shape[shape.length - i - 1] = maxShape[shape.length - i - 1];
            ++i;
        }
        return shape;
    }

    private class LazyDynamicTestLoader
    implements ILazyLoader,
    ILazyDynamicLoader {
        private static final long serialVersionUID = -2336998015537666270L;
        int[] currentShape;
        IDataset data;
        SliceNDIterator iterator;
        boolean hasNext = true;
        private int[] dShape;

        LazyDynamicTestLoader(IDataset data, int detectorRank) {
            this.data = data;
            this.dShape = data.getShape();
            this.currentShape = LazyDynamicLoaderTest.determineInitialShape(this.dShape, detectorRank);
            int[] axes = new int[detectorRank];
            int i = 0;
            while (i < detectorRank) {
                axes[i] = data.getRank() - 1 - i;
                ++i;
            }
            this.iterator = new SliceNDIterator(new SliceND(this.dShape), axes);
            this.iterator.hasNext();
        }

        public int[] refreshShape() {
            if (!this.iterator.hasNext()) {
                this.hasNext = false;
            }
            if (!this.hasNext) {
                return this.data.getShape();
            }
            SliceND sliceND = this.iterator.getCurrentSlice();
            this.currentShape = sliceND.getStop();
            return (int[])this.currentShape.clone();
        }

        public boolean isFileReadable() {
            return true;
        }

        public IDataset getDataset(IMonitor mon, SliceND slice) throws IOException {
            SliceND nSlice = slice.clone();
            nSlice.updateSourceShape(this.dShape);
            return this.data.getSlice(nSlice);
        }
    }
}

