/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_sndQ;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.ee.mdb.mdb_sndQ.MDB_SNDQ_Test;
import java.util.Properties;
import javax.ejb.EJB;

public class MDBClient
extends EETest {
    @EJB(name="ejb/MDB_SNDQ_Test")
    private static MDB_SNDQ_Test hr = null;
    private Properties props = null;

    public static void main(String[] args) {
        MDBClient theTests = new MDBClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            if (hr == null) {
                throw new EETest.Fault("@EJB injection failed");
            }
            hr.setup(p);
            if (hr.isThereSomethingInTheQueue()) {
                TestUtil.logTrace((String)"Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                TestUtil.logTrace((String)"Nothing left in queue");
            }
            this.logMsg("Setup ok;");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup Failed!", e);
        }
    }

    public void mdbSendTextMsgTest() throws EETest.Fault {
        String messageType = "TextMessage";
        String matchMe = "TextMessageFromMsgBean";
        try {
            TestUtil.logTrace((String)"Call bean - have it tell mdb to send a text message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                TestUtil.logErr((String)"Error: didn't get expected response from mdb");
                throw new EETest.Fault("ERROR: mdbSendTextMsgTest failed");
            }
            TestUtil.logTrace((String)"Test passed!");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void mdbSendBytesMsgTest() throws EETest.Fault {
        String messageType = "BytesMessage";
        String matchMe = "BytesMessageFromMsgBean";
        try {
            TestUtil.logTrace((String)"Call bean - have it tell mdb to send a Bytes message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                TestUtil.logErr((String)"Error: didn't get expected response from mdb");
                throw new EETest.Fault("ERROR: mdbSendBytesMsgTest failed");
            }
            TestUtil.logTrace((String)"Test passed!");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void mdbSendMapMsgTest() throws EETest.Fault {
        String matchMe = "MapMessageFromMsgBean";
        String messageType = "MapMessage";
        try {
            TestUtil.logTrace((String)"Call bean - have it tell mdb to send a map message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                TestUtil.logErr((String)"Error: didn't get expected response from mdb");
                throw new EETest.Fault("ERROR: mdbSendMapMsgTest failed");
            }
            TestUtil.logTrace((String)"Test passed!");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void mdbSendStreamMsgTest() throws EETest.Fault {
        String matchMe = "StreamMessageFromMsgBean";
        String messageType = "StreamMessage";
        try {
            TestUtil.logTrace((String)"Call bean - have it tell mdb to send a stream message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                TestUtil.logErr((String)"Error: didn't get expected response from mdb");
                throw new EETest.Fault("ERROR: mdbSendStreamMsgTest failed");
            }
            TestUtil.logTrace((String)"Test passed!");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void mdbSendObjectMsgTest() throws EETest.Fault {
        String matchMe = "ObjectMessageFromMsgBean";
        String messageType = "ObjectMessage";
        try {
            TestUtil.logTrace((String)"Call bean - have it tell mdb to send an object message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                TestUtil.logErr((String)"Error: didn't get expected response from mdb");
                throw new EETest.Fault("ERROR: mdbSendObjectMsgTest failed");
            }
            TestUtil.logTrace((String)"Test passed!");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        if (hr != null) {
            try {
                if (hr.isThereSomethingInTheQueue()) {
                    TestUtil.logTrace((String)"Error: message(s) left in Q");
                    hr.cleanTheQueue();
                } else {
                    TestUtil.logTrace((String)"Nothing left in queue");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error cleaning up messages", (Throwable)e);
            }
            finally {
                try {
                    hr.remove();
                }
                catch (Exception er) {
                    TestUtil.logErr((String)"Error removing bean", (Throwable)er);
                }
            }
        }
        this.logMsg("End  of client cleanup;");
    }
}

